/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.hud.component;

import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.gui.hud.component.HudComponentMovable;
import net.minecraft.client.gui.hud.component.layout.Layout;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.core.enums.HumanArmorShape;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;

public class HudComponentArmorDurability
extends HudComponentMovable {
    private static final ItemStack[] PREVIEW_STACKS = new ItemStack[]{Items.ARMOR_BOOTS_DIAMOND.getDefaultStack(), Items.ARMOR_LEGGINGS_DIAMOND.getDefaultStack(), Items.ARMOR_CHESTPLATE_DIAMOND.getDefaultStack(), Items.ARMOR_HELMET_DIAMOND.getDefaultStack()};

    public HudComponentArmorDurability(String key, Layout layout) {
        super(key, 64, 64, layout);
    }

    @Override
    public boolean isVisible() {
        return HudComponentArmorDurability.mc.gameSettings.immersiveMode.drawOverlays() && (Boolean)HudComponentArmorDurability.mc.gameSettings.armorDurabilityOverlay.value != false;
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)HudComponentArmorDurability.mc.gameSettings.armorDurabilityOverlay.value;
    }

    @Override
    public void render(HudIngame hud, int xSizeScreen, int ySizeScreen, float partialTick) {
        int x = this.getLayout().getComponentX(this, xSizeScreen);
        int y = this.getLayout().getComponentY(this, ySizeScreen);
        for (int i = 0; i < HudComponentArmorDurability.mc.thePlayer.getNumArmorSlots(); ++i) {
            ItemStack stack = HudComponentArmorDurability.mc.thePlayer.getItemInArmorSlot(HumanArmorShape.values()[i]);
            if (stack == null) continue;
            int xx = x + 2;
            int yy = y + 48 - i * 16;
            ItemModelDispatcher.getInstance().getDispatch(stack).renderGui(GLRenderer.getTessellator(), null, stack, xx, yy, LightmapHelper.getLightmapCoord(15, 15), partialTick);
            if (!stack.isItemStackDamageable()) continue;
            float durability = (float)(stack.getMaxDamage() - stack.getMetadata()) / (float)stack.getMaxDamage();
            int l = (int)(durability * 255.0f);
            int i1 = 255 - l << 16 | l << 8;
            HudComponentArmorDurability.mc.font.render(String.valueOf(stack.getMaxDamage() - stack.getMetadata() + 1), xx + 20, yy + 4).setShadow().setColor(i1).call();
        }
    }

    @Override
    public void renderPreview(Gui gui, Layout layout, int xSizeScreen, int ySizeScreen) {
        int x = this.getLayout().getComponentX(this, xSizeScreen);
        int y = this.getLayout().getComponentY(this, ySizeScreen);
        for (int i = 0; i < PREVIEW_STACKS.length; ++i) {
            ItemStack stack = PREVIEW_STACKS[i];
            int xx = x + 2;
            int yy = y + 48 - i * 16;
            ItemModelDispatcher.getInstance().getDispatch(stack).renderGui(GLRenderer.getTessellator(), null, stack, xx, yy, LightmapHelper.getLightmapCoord(15, 15), 0.0f);
            if (!stack.isItemStackDamageable()) continue;
            float durability = (float)(stack.getMaxDamage() - stack.getMetadata()) / (float)stack.getMaxDamage();
            int l = (int)(durability * 255.0f);
            int i1 = 255 - l << 16 | l << 8;
            HudComponentArmorDurability.mc.font.render(String.valueOf(stack.getMaxDamage() - stack.getMetadata() + 1), xx + 20, yy + 4).setShadow().setColor(i1).call();
        }
    }
}

