/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.nbteditor.components;

import com.mojang.logging.LogUtils;
import com.mojang.nbt.tags.Tag;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.nbteditor.components.AbstractTagComponent;
import net.minecraft.client.gui.popup.PopupBuilder;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.core.util.helper.DyeColor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public abstract class ValueTagComponent<T>
extends AbstractTagComponent<T> {
    private static final Logger LOGGER = LogUtils.getLogger();

    public ValueTagComponent(@NotNull Screen attachedScreen, @NotNull Tag<T> tag) {
        super(attachedScreen, tag);
    }

    @Override
    public void render(@NotNull TessellatorGeneral t, int offX, int offY, int mx, int my, float partialTick) {
        super.render(t, offX, offY, mx, my, partialTick);
        this.drawRect(offX + 12 + 1, offY, offX + this.width(mx, my, partialTick), offY + this.height(mx, my, partialTick), this.isHovered(mx, my, partialTick) ? -2006949728 : -2002739040);
        this.attachedScreen.fontRenderer.render(this.tag.getTagName(), offX + 12 + 1 + 2, offY + 2).setColor(DyeColor.YELLOW.color).call();
        this.attachedScreen.fontRenderer.render(": ", this.attachedScreen.fontRenderer.getLastEndingX(), offY + 2).setColor(DyeColor.YELLOW.color).call();
        this.attachedScreen.fontRenderer.render(this.tag.getValue().toString(), this.attachedScreen.fontRenderer.getLastEndingX(), offY + 2).call();
    }

    @Override
    public void onMouseClick(int mx, int my, int mouseButton, float partialTick) {
        if (this.isHovered(mx, my, partialTick) && mouseButton == 0) {
            this.attachedScreen.mc.displayScreen(new PopupBuilder(this.attachedScreen, 400).withTextField("input", this.valueToString()).closeOnEsc(0).closeOnEnter(0).closeOnClickOut(0).withOnCloseListener((statusCode, results) -> {
                if (statusCode == 0) {
                    try {
                        this.parseValueFromString((String)results.get("input"));
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to parse input '{}' into a '{}'!", results.get("input"), this.tag.getClass().getSimpleName(), e);
                    }
                }
            }).build());
        }
    }

    @NotNull
    public String valueToString() {
        return this.tag.getValue().toString();
    }

    public abstract void parseValueFromString(@NotNull String var1) throws Exception;
}

