/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.block.model.BlockModelTorch;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicRepeater;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.joml.primitives.AABBdc;

public class BlockModelRepeater
extends BlockModelStandard<BlockLogicRepeater> {
    @NotNull
    private static final BlockModelTorch<?> modelTorchActive = (BlockModelTorch)BlockModelDispatcher.getInstance().getDispatch(Blocks.TORCH_REDSTONE_ACTIVE);
    @NotNull
    private static final BlockModelTorch<?> modelTorchIdle = (BlockModelTorch)BlockModelDispatcher.getInstance().getDispatch(Blocks.TORCH_REDSTONE_IDLE);

    public BlockModelRepeater(Block<BlockLogicRepeater> block) {
        super(block);
    }

    @Override
    public boolean render(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        int meta = worldSource.getBlockData(tilePos);
        int direction = meta & 3;
        switch (direction) {
            case 0: {
                BlockModelRepeater.renderBlocks.uvRotateTop = 0;
                break;
            }
            case 2: {
                BlockModelRepeater.renderBlocks.uvRotateTop = 3;
                break;
            }
            case 3: {
                BlockModelRepeater.renderBlocks.uvRotateTop = 2;
                break;
            }
            case 1: {
                BlockModelRepeater.renderBlocks.uvRotateTop = 1;
            }
        }
        int j1 = (meta & 0xC) >> 2;
        renderBlocks.renderStandardBlock(tessellator, worldSource, this, this.block.getBoundsFromState(worldSource, tilePos), tilePos);
        renderBlocks.resetRenderBlocks();
        float brightness = 1.0f;
        int lmc = this.block.getLightmapCoord(worldSource, tilePos);
        if (this.block.emission > 0) {
            lmc = LightmapHelper.setBlocklightValue(lmc, 15);
        }
        tessellator.setLightmapCoord1i(lmc);
        tessellator.setColorOpaque3f(brightness, brightness, brightness);
        double d = -0.1875;
        double d1 = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        switch (direction) {
            case 0: {
                d4 = -0.3125;
                d2 = BlockLogicRepeater.torchPosOffset[j1];
                break;
            }
            case 2: {
                d4 = 0.3125;
                d2 = -BlockLogicRepeater.torchPosOffset[j1];
                break;
            }
            case 3: {
                d3 = -0.3125;
                d1 = BlockLogicRepeater.torchPosOffset[j1];
                break;
            }
            case 1: {
                d3 = 0.3125;
                d1 = -BlockLogicRepeater.torchPosOffset[j1];
            }
        }
        BlockModelTorch<?> modelTorch = ((BlockLogicRepeater)this.block.getLogic()).isRepeaterPowered ? modelTorchActive : modelTorchIdle;
        modelTorch.renderTorchAtAngle(tessellator, (double)tilePos.x() + d1, (double)tilePos.y() + d, (double)tilePos.z() + d2, 0.0, 0.0);
        modelTorch.renderTorchAtAngle(tessellator, (double)tilePos.x() + d3, (double)tilePos.y() + d, (double)tilePos.z() + d4, 0.0, 0.0);
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    public boolean shouldSideBeRendered(@NotNull WorldSource source, @NotNull AABBdc bounds, @NotNull TilePosc tilePos, @NotNull Side side) {
        return true;
    }
}

