/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.render.EntityRendererDispatcher;
import net.minecraft.client.render.ImageParser;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.font.FontRenderer;
import net.minecraft.client.render.renderer.BlendFactor;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.Shaders;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.tessellator.TessellatorShader;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.joml.primitives.AABBdc;
import org.useless.dragonfly.data.entity.mojang.EntityGeometryMojangData;
import org.useless.dragonfly.models.entity.StaticEntityModel;

public abstract class EntityRenderer<T extends Entity> {
    public static boolean renderShadows = true;
    @NotNull
    private final @NotNull Map<@NotNull String, @NotNull StaticEntityModel> modelMap = new HashMap<String, StaticEntityModel>();
    protected EntityRendererDispatcher renderDispatcher = null;
    protected Class<? extends T> appliedClass = null;
    private float shadowSize;
    protected float shadowOpacity;

    public EntityRenderer(float shadowSize) {
        this.shadowSize = shadowSize;
        this.shadowOpacity = 1.0f;
    }

    public EntityRenderer() {
        this(0.0f);
    }

    public float getShadowSize(@NotNull T entity) {
        return this.shadowSize;
    }

    public abstract void render(@NotNull TessellatorGeneral var1, @NotNull T var2, double var3, double var5, double var7, float var9, float var10);

    public void renderPreview(@NotNull TessellatorGeneral tessellator, @NotNull T entity, double x, double y, double z, float yaw, float partialTick) {
        this.render(tessellator, entity, x, y, z, yaw, partialTick);
    }

    protected void bindTexture(@NotNull String texturePath) {
        TextureManager textureManager = this.renderDispatcher.textureManager;
        textureManager.bindTexture(textureManager.loadTexture(texturePath));
    }

    public boolean bindDownloadableTexture(String urlTexture, String backupTexture, ImageParser imageParser) {
        return this.renderDispatcher.textureManager.bindDownloadableTexture(urlTexture, backupTexture, imageParser);
    }

    @NotNull
    protected StaticEntityModel getModel(@NotNull String localId) {
        StaticEntityModel model = this.modelMap.get(localId);
        if (model != null) {
            return model;
        }
        EntityDispatcher.EntityDispatcherEntry<? extends T> entry = EntityDispatcher.getInstance().entryForClass(this.appliedClass);
        NamespaceID id = entry != null ? entry.namespaceID : null;
        model = id != null ? EntityGeometryMojangData.Cache.getModelForEntity(id, localId) : EntityGeometryMojangData.Cache.getFallbackModel();
        this.modelMap.put(localId, model);
        return model;
    }

    @NotNull
    public final EntityRenderer<T> setModel(@NotNull String localId, @NotNull String modelId, double inflation) {
        this.modelMap.put(localId, EntityGeometryMojangData.Cache.getModel(modelId, inflation));
        return this;
    }

    public void onWorldChanged(@NotNull World world) {
    }

    private void renderFire(@NotNull TessellatorGeneral tessellator, @NotNull T entity, double x, double y, double z, float partialTick) {
        GLRenderer.globalSetLightEnabled(false);
        IconCoordinate texture = TextureRegistry.getTexture("minecraft:block/fire");
        texture.parentAtlas.bind();
        GLRenderer.pushFrame();
        GLRenderer.modelM4f().translate((float)x, (float)y, (float)z);
        float f9 = ((Entity)entity).bbWidth * 1.4f;
        GLRenderer.modelM4f().scale(f9, f9, f9);
        float f10 = 0.5f;
        float f11 = 0.0f;
        float f12 = ((Entity)entity).bbHeight;
        float f13 = (float)(((Entity)entity).y - ((Entity)entity).bb.minY);
        GLRenderer.modelM4f().rotateY(Math.toRadians(-this.renderDispatcher.viewLerpYaw));
        GLRenderer.modelM4f().translate(0.0f, 0.0f, -0.3f + (float)((int)f12) * 0.02f);
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        int lightmapCoord = ((Entity)entity).getLightmap(partialTick);
        lightmapCoord = LightmapHelper.setBlocklightValue(lightmapCoord, 15);
        GLRenderer.setLightmapCoord1i(lightmapCoord);
        float f14 = 0.0f;
        int l = 0;
        tessellator.startDrawingQuads();
        while (f12 > 0.0f) {
            double f2 = texture.getIconUMin();
            double f4 = texture.getIconUMax();
            double f6 = texture.getIconVMin();
            double f8 = texture.getIconVMax();
            if (l / 2 % 2 == 0) {
                double f15 = f4;
                f4 = f2;
                f2 = f15;
            }
            tessellator.addVertexWithUV(f10 - 0.0f, 0.0f - f13, f14, f4, f8);
            tessellator.addVertexWithUV(-f10 - 0.0f, 0.0f - f13, f14, f2, f8);
            tessellator.addVertexWithUV(-f10 - 0.0f, 1.4f - f13, f14, f2, f6);
            tessellator.addVertexWithUV(f10 - 0.0f, 1.4f - f13, f14, f4, f6);
            f12 -= 0.45f;
            f13 -= 0.45f;
            f10 *= 0.9f;
            f14 += 0.03f;
            ++l;
        }
        tessellator.draw();
        GLRenderer.popFrame();
        GLRenderer.globalSetLightEnabled(true);
    }

    private void renderShadow(@NotNull TessellatorGeneral tessellator, @NotNull T entity, double posX, double posY, double posZ, float opacity, float partialTick) {
        GLRenderer.enableState(State.BLEND);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        TextureManager textureManager = this.renderDispatcher.textureManager;
        textureManager.bindTexture(textureManager.loadTexture("/assets/minecraft/textures/misc/shadow.png"));
        World world = ((Entity)entity).world;
        GLRenderer.setDepthMask(false);
        double lerpX = ((Entity)entity).xo + (((Entity)entity).x - ((Entity)entity).xo) * (double)partialTick;
        double lerpY = ((Entity)entity).yo + (((Entity)entity).y - ((Entity)entity).yo) * (double)partialTick + (double)((Entity)entity).getShadowHeightOffs();
        double lerpZ = ((Entity)entity).zo + (((Entity)entity).z - ((Entity)entity).zo) * (double)partialTick;
        float shadowSize = this.getShadowSize(entity);
        int minX = MathHelper.floor(lerpX - (double)shadowSize);
        int maxX = MathHelper.floor(lerpX + (double)shadowSize);
        int minY = MathHelper.floor(lerpY - (double)shadowSize);
        int maxY = MathHelper.floor(lerpY);
        int minZ = MathHelper.floor(lerpZ - (double)shadowSize);
        int maxZ = MathHelper.floor(lerpZ + (double)shadowSize);
        double dxLerp = posX - lerpX;
        double dyLerp = posY - lerpY;
        double dzLerp = posZ - lerpZ;
        tessellator.startDrawingQuads();
        for (int blockX = minX; blockX <= maxX; ++blockX) {
            for (int blockY = minY; blockY <= maxY; ++blockY) {
                for (int blockZ = minZ; blockZ <= maxZ; ++blockZ) {
                    int blockId = world.getBlockId(blockX, blockY - 1, blockZ);
                    if (blockId <= 0 || world.getBlockLightValue(blockX, blockY, blockZ) <= 3) continue;
                    this.renderShadowOnBlock(tessellator, entity, Blocks.blocksList[blockId], posX, posY + (double)((Entity)entity).getShadowHeightOffs(), posZ, blockX, blockY, blockZ, opacity, shadowSize, dxLerp, dyLerp + (double)((Entity)entity).getShadowHeightOffs(), dzLerp);
                }
            }
        }
        tessellator.draw();
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GLRenderer.disableState(State.BLEND);
        GLRenderer.setDepthMask(true);
    }

    private void renderShadowOnBlock(@NotNull TessellatorGeneral tessellator, @NotNull T entity, @NotNull Block<?> block, double d, double d1, double d2, int x, int y, int z, float opacity, float size, double xo, double yo, double zo) {
        double alpha;
        if (!block.isCubeShaped()) {
            return;
        }
        double brightness = ((Entity)entity).world.getLightBrightness(x, y, z);
        if (Global.accessor.isFullbrightEnabled()) {
            brightness = 1.0;
        }
        if ((alpha = ((double)opacity - (d1 - ((double)(y + 1) + yo)) / 2.0) * 0.5 * brightness) < 0.0) {
            return;
        }
        if (alpha > 1.0) {
            alpha = 1.0;
        }
        tessellator.setColor4f(1.0f, 1.0f, 1.0f, (float)alpha);
        AABBdc aabb = block.getCollisionBoundingBoxFromPool(((Entity)entity).world, x, y, z);
        if (aabb == null) {
            return;
        }
        double xMin = aabb.minX() + xo;
        double xMax = aabb.maxX() + xo;
        double yMin = aabb.maxY() + yo + 0.015625 - 1.0;
        double zMin = aabb.minZ() + zo;
        double zMax = aabb.maxZ() + zo;
        float f2 = (float)((d - xMin) / 2.0 / (double)size + 0.5);
        float f3 = (float)((d - xMax) / 2.0 / (double)size + 0.5);
        float f4 = (float)((d2 - zMin) / 2.0 / (double)size + 0.5);
        float f5 = (float)((d2 - zMax) / 2.0 / (double)size + 0.5);
        tessellator.addVertexWithUV(xMin, yMin, zMin, f2, f4);
        tessellator.addVertexWithUV(xMin, yMin, zMax, f2, f5);
        tessellator.addVertexWithUV(xMax, yMin, zMax, f3, f5);
        tessellator.addVertexWithUV(xMax, yMin, zMin, f3, f4);
    }

    public static void renderOffsetAABB(@NotNull TessellatorGeneral tessellator, @NotNull AABBdc aabb, double x, double y, double z) {
        GLRenderer.pushFrame();
        GLRenderer.setShader(Shaders.COLOR);
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        tessellator.startDrawingQuads();
        tessellator.setTranslation(x, y, z);
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        tessellator.addVertex(aabb.minX(), aabb.maxY(), aabb.minZ());
        tessellator.addVertex(aabb.maxX(), aabb.maxY(), aabb.minZ());
        tessellator.addVertex(aabb.maxX(), aabb.minY(), aabb.minZ());
        tessellator.addVertex(aabb.minX(), aabb.minY(), aabb.minZ());
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        tessellator.addVertex(aabb.minX(), aabb.minY(), aabb.maxZ());
        tessellator.addVertex(aabb.maxX(), aabb.minY(), aabb.maxZ());
        tessellator.addVertex(aabb.maxX(), aabb.maxY(), aabb.maxZ());
        tessellator.addVertex(aabb.minX(), aabb.maxY(), aabb.maxZ());
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        tessellator.addVertex(aabb.minX(), aabb.minY(), aabb.minZ());
        tessellator.addVertex(aabb.maxX(), aabb.minY(), aabb.minZ());
        tessellator.addVertex(aabb.maxX(), aabb.minY(), aabb.maxZ());
        tessellator.addVertex(aabb.minX(), aabb.minY(), aabb.maxZ());
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        tessellator.addVertex(aabb.minX(), aabb.maxY(), aabb.maxZ());
        tessellator.addVertex(aabb.maxX(), aabb.maxY(), aabb.maxZ());
        tessellator.addVertex(aabb.maxX(), aabb.maxY(), aabb.minZ());
        tessellator.addVertex(aabb.minX(), aabb.maxY(), aabb.minZ());
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        tessellator.addVertex(aabb.minX(), aabb.minY(), aabb.maxZ());
        tessellator.addVertex(aabb.minX(), aabb.maxY(), aabb.maxZ());
        tessellator.addVertex(aabb.minX(), aabb.maxY(), aabb.minZ());
        tessellator.addVertex(aabb.minX(), aabb.minY(), aabb.minZ());
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        tessellator.addVertex(aabb.maxX(), aabb.minY(), aabb.minZ());
        tessellator.addVertex(aabb.maxX(), aabb.maxY(), aabb.minZ());
        tessellator.addVertex(aabb.maxX(), aabb.maxY(), aabb.maxZ());
        tessellator.addVertex(aabb.maxX(), aabb.minY(), aabb.maxZ());
        tessellator.setTranslation(0.0, 0.0, 0.0);
        tessellator.draw();
        GLRenderer.popFrame();
    }

    public static void renderFlatAABB(@NotNull AABBdc aabb) {
        TessellatorShader tessellator = GLRenderer.getTessellator();
        tessellator.startDrawingQuads();
        tessellator.addVertex(aabb.minX(), aabb.maxY(), aabb.minZ());
        tessellator.addVertex(aabb.maxX(), aabb.maxY(), aabb.minZ());
        tessellator.addVertex(aabb.maxX(), aabb.minY(), aabb.minZ());
        tessellator.addVertex(aabb.minX(), aabb.minY(), aabb.minZ());
        tessellator.addVertex(aabb.minX(), aabb.minY(), aabb.maxZ());
        tessellator.addVertex(aabb.maxX(), aabb.minY(), aabb.maxZ());
        tessellator.addVertex(aabb.maxX(), aabb.maxY(), aabb.maxZ());
        tessellator.addVertex(aabb.minX(), aabb.maxY(), aabb.maxZ());
        tessellator.addVertex(aabb.minX(), aabb.minY(), aabb.minZ());
        tessellator.addVertex(aabb.maxX(), aabb.minY(), aabb.minZ());
        tessellator.addVertex(aabb.maxX(), aabb.minY(), aabb.maxZ());
        tessellator.addVertex(aabb.minX(), aabb.minY(), aabb.maxZ());
        tessellator.addVertex(aabb.minX(), aabb.maxY(), aabb.maxZ());
        tessellator.addVertex(aabb.maxX(), aabb.maxY(), aabb.maxZ());
        tessellator.addVertex(aabb.maxX(), aabb.maxY(), aabb.minZ());
        tessellator.addVertex(aabb.minX(), aabb.maxY(), aabb.minZ());
        tessellator.addVertex(aabb.minX(), aabb.minY(), aabb.maxZ());
        tessellator.addVertex(aabb.minX(), aabb.maxY(), aabb.maxZ());
        tessellator.addVertex(aabb.minX(), aabb.maxY(), aabb.minZ());
        tessellator.addVertex(aabb.minX(), aabb.minY(), aabb.minZ());
        tessellator.addVertex(aabb.maxX(), aabb.minY(), aabb.minZ());
        tessellator.addVertex(aabb.maxX(), aabb.maxY(), aabb.minZ());
        tessellator.addVertex(aabb.maxX(), aabb.maxY(), aabb.maxZ());
        tessellator.addVertex(aabb.maxX(), aabb.minY(), aabb.maxZ());
        tessellator.draw();
    }

    public void init(@NotNull Class<? extends T> appliedClass, @NotNull EntityRendererDispatcher dispatcher) {
        this.renderDispatcher = dispatcher;
        this.appliedClass = appliedClass;
    }

    public void postRender(@NotNull TessellatorGeneral tessellator, @NotNull T entity, double x, double y, double z, float yaw, float partialTick) {
        double distance;
        float opacity;
        if (renderShadows && (Integer)this.renderDispatcher.settings.fancyGraphics.value == 1 && this.getShadowSize(entity) > 0.0f && (opacity = (float)((1.0 - (distance = this.renderDispatcher.distanceToLerpSquared(((Entity)entity).x, ((Entity)entity).y, ((Entity)entity).z)) / 256.0) * (double)this.shadowOpacity)) > 0.0f) {
            this.renderShadow(tessellator, entity, x, y, z, opacity, partialTick);
        }
        if (((Entity)entity).isOnFire()) {
            this.renderFire(tessellator, entity, x, y, z, partialTick);
        }
    }

    @NotNull
    public FontRenderer getFont() {
        return this.renderDispatcher.font;
    }

    @NotNull
    public AABBdc entityViewBox(@NotNull T entity) {
        return ((Entity)entity).bb;
    }
}

