/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.font;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.font.Font;
import net.minecraft.client.render.tessellator.TessellatorFont;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.client.render.texturepack.TexturePackList;
import net.minecraft.core.util.helper.ChatAllowedCharacters;
import org.jetbrains.annotations.NotNull;

public class FontFile
implements Font {
    protected static final List<Character> DEFAULT_BLACKLIST = new ObjectArrayList<Character>();
    protected static final int ITALICS_SHIFT = 1;
    protected static final int GLYPHS_PER_TEXTURE = 256;
    protected static final int TEXTURE_UNASSIGNED = -1;
    protected final byte[] charWidth;
    protected final int[] texHandleCache;
    @NotNull
    protected final String textureFormat;
    @NotNull
    protected final String glyphSizesPath;
    @NotNull
    protected final String key;

    public FontFile(@NotNull String key, @NotNull String texturesFormat, @NotNull String glyphSizesPath) {
        this.key = key;
        this.textureFormat = texturesFormat;
        this.glyphSizesPath = glyphSizesPath;
        this.charWidth = new byte[65536];
        this.texHandleCache = new int[256];
    }

    @Override
    public void init(@NotNull TexturePackList packList) {
        Arrays.fill(this.texHandleCache, -1);
        try (InputStream glyphStreamDefault = packList.getResourceAsStream(this.glyphSizesPath);){
            glyphStreamDefault.read(this.charWidth);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    @Override
    public int textureForChar(char c) {
        int index = c / 256;
        if (this.texHandleCache[index] != -1) {
            return this.texHandleCache[index];
        }
        Texture texture = Minecraft.getMinecraft().textureManager.loadTextureNoDefault(String.format(this.textureFormat, index));
        if (texture == null) {
            this.texHandleCache[index] = 0;
            return 0;
        }
        this.texHandleCache[index] = texture.id();
        return texture.id();
    }

    @Override
    public char getObfuscatedChar(char c, Random random) {
        char randomChar;
        if (ChatAllowedCharacters.ALLOWED_CHARACTERS.indexOf(c) < 0) {
            return c;
        }
        int counter = 0;
        do {
            randomChar = ChatAllowedCharacters.ALLOWED_CHARACTERS.charAt(random.nextInt(ChatAllowedCharacters.ALLOWED_CHARACTERS.length()));
            if (counter++ <= 1000) continue;
            randomChar = c;
            break;
        } while (this.charWidth(c) != this.charWidth(randomChar) || !this.canRenderChar(randomChar));
        return randomChar;
    }

    @Override
    public boolean canRenderChar(char c) {
        return c == ' ' || this.textureForChar(c) != 0;
    }

    @Override
    public double charWidthDouble(char c) {
        if (c == ' ') {
            return 4.0;
        }
        int upper = this.charWidth[c] >> 4;
        int lower = this.charWidth[c] & 0xF;
        double fUpper = upper;
        double fLower = lower + 1;
        return (fLower - fUpper) / 2.0 + 1.0;
    }

    @Override
    public int fontHeight() {
        return 8;
    }

    @Override
    public double renderChar(TessellatorFont tessellator, char c, double x, double y, double z, boolean italics) {
        if (c == ' ') {
            return 4.0;
        }
        boolean shift = italics;
        int lower = this.charWidth[c] & 0xF;
        int fLower = lower + 1;
        int upper = this.charWidth[c] >> 4;
        int fUpper = upper;
        if (fLower - fUpper == 0) {
            return 0.0;
        }
        int u = c % 16 * 16 + fUpper;
        int v = (c & 0xFF) / 16 * 16;
        int uWidth = fLower - fUpper;
        int vHeight = 16;
        double width = (double)uWidth / 2.0;
        double height = 8.0;
        tessellator.addChar(x, y, width, 8.0, (double)shift, u, v, uWidth, 16.0);
        return (double)(fLower - fUpper) / 2.0 + 1.0;
    }

    static {
        DEFAULT_BLACKLIST.addAll(Arrays.asList(Character.valueOf('\uff0c'), Character.valueOf('\u3002'), Character.valueOf('\u3001'), Character.valueOf('\u3010'), Character.valueOf('\u3011'), Character.valueOf('\uff1b'), Character.valueOf('\u2019'), Character.valueOf('\u2018'), Character.valueOf('\u201c'), Character.valueOf('\u201d'), Character.valueOf('\uff1f'), Character.valueOf('\uff01'), Character.valueOf('\u00b7')));
    }
}

