/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tileentity;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.render.EntityRendererDispatcher;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.client.world.WorldClient;
import net.minecraft.core.block.entity.TileEntityMobSpawner;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.world.World;
import org.joml.Math;

public class TileEntityRendererMobSpawner
extends TileEntityRenderer<TileEntityMobSpawner> {
    private final Map<String, Entity> entityHashMap = new HashMap<String, Entity>();

    @Override
    public void onWorldChanged(World world) {
        this.entityHashMap.clear();
    }

    @Override
    public void doRender(TessellatorGeneral tessellator, TileEntityMobSpawner mobSpawner, double x, double y, double z, float partialTick) {
        GLRenderer.pushFrame();
        GLRenderer.modelM4f().translate((float)x + 0.5f, (float)y, (float)z + 0.5f);
        Entity entity = this.entityHashMap.get(mobSpawner.getMobId());
        if (entity == null) {
            entity = EntityDispatcher.getInstance().createEntityInWorld(mobSpawner.getMobId(), (World)WorldClient.EMPTY_WORLD);
            this.entityHashMap.put(mobSpawner.getMobId(), entity);
        }
        if (entity != null) {
            entity.setWorld(mobSpawner.worldObj);
            float f1 = 0.4375f;
            GLRenderer.modelM4f().translate(0.0f, 0.4f, 0.0f);
            GLRenderer.modelM4f().rotateY((float)Math.toRadians((mobSpawner.yaw2 + (mobSpawner.yaw - mobSpawner.yaw2) * (double)partialTick) * 10.0));
            GLRenderer.modelM4f().rotateX(Math.toRadians(-30.0f));
            GLRenderer.modelM4f().translate(0.0f, -0.4f, 0.0f);
            GLRenderer.modelM4f().scale(f1, f1, f1);
            entity.moveTo(mobSpawner.x, mobSpawner.y, mobSpawner.z, 0.0f, 0.0f);
            EntityRenderer.renderShadows = false;
            EntityRendererDispatcher.instance.renderEntityWithPosYaw(tessellator, entity, 0.0, 0.0, 0.0, 0.0f, partialTick);
            EntityRenderer.renderShadows = true;
        }
        GLRenderer.popFrame();
    }
}

