/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import net.minecraft.core.Global;
import net.minecraft.core.NextTickListEntry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.current.wire.WireHandler;
import net.minecraft.core.data.gamerule.GameRule;
import net.minecraft.core.data.gamerule.GameRules;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.animal.MobFireflyCluster;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.Difficulty;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.command.CommandManager;
import net.minecraft.core.sound.BlockSound;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.debug.Debug;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.world.AuroraProvider;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.Explosion;
import net.minecraft.core.world.ExplosionCannonball;
import net.minecraft.core.world.LevelListener;
import net.minecraft.core.world.MutableWorldSource;
import net.minecraft.core.world.ProgressListener;
import net.minecraft.core.world.SpawnerMobs;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.biome.provider.BiomeProvider;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.chunk.ChunkCache;
import net.minecraft.core.world.chunk.ChunkCoordinate;
import net.minecraft.core.world.chunk.ChunkCoordinates;
import net.minecraft.core.world.chunk.IChunkLoader;
import net.minecraft.core.world.chunk.provider.IChunkProvider;
import net.minecraft.core.world.config.spawning.SpawnerConfig;
import net.minecraft.core.world.lighting.LightingEngine;
import net.minecraft.core.world.lighting.LightingEngineLegacy;
import net.minecraft.core.world.pathfinder.Path;
import net.minecraft.core.world.pathfinder.PathFinder;
import net.minecraft.core.world.pos.ChunkPos;
import net.minecraft.core.world.pos.ChunkTilePos;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import net.minecraft.core.world.save.DimensionData;
import net.minecraft.core.world.save.LevelData;
import net.minecraft.core.world.save.LevelStorage;
import net.minecraft.core.world.save.PlayerIO;
import net.minecraft.core.world.saveddata.SavedData;
import net.minecraft.core.world.saveddata.SavedDataStorage;
import net.minecraft.core.world.season.SeasonManager;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.core.world.weather.IPrecipitation;
import net.minecraft.core.world.weather.Weather;
import net.minecraft.core.world.weather.WeatherManager;
import net.minecraft.core.world.weather.Weathers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.slf4j.Logger;

public class World
implements MutableWorldSource {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static boolean AUTOSAVE = true;
    public static final int HEIGHT_BLOCKS = 256;
    public static final int MAX_BRIGHTNESS = 15;
    public static final int MAX_BLOCK_X = 32000000;
    public static final int MAX_BLOCK_Z = 32000000;
    public static final int MIN_BLOCK_X = -32000000;
    public static final int MIN_BLOCK_Z = -32000000;
    public static final int MAX_SCHEDULED_TICKS_IN_TICK = 1000;
    public static final int ANIMATION_TICKS_PER_TICK = 1000;
    @NotNull
    public final @NotNull List<@NotNull Entity> entities = new ObjectArrayList<Entity>();
    @NotNull
    private final @NotNull List<@NotNull Entity> entitiesToRemove = new ObjectArrayList<Entity>();
    @NotNull
    private final @NotNull TreeSet<@NotNull NextTickListEntry> tickNextTickList = new TreeSet();
    @NotNull
    private final @NotNull Set<@NotNull NextTickListEntry> tickNextTickSet = new HashSet<NextTickListEntry>();
    @NotNull
    public final @NotNull List<@NotNull TileEntity> tileEntityList = new ObjectArrayList<TileEntity>();
    @NotNull
    public final @NotNull List<@NotNull Player> players = new ObjectArrayList<Player>();
    @NotNull
    public final @NotNull List<@NotNull Entity> weatherEffects = new ObjectArrayList<Entity>();
    @NotNull
    public final @NotNull List<@NotNull AABBdc> collidingBoundingBoxes = new ObjectArrayList<AABBdc>();
    @NotNull
    public final @NotNull List<@NotNull LevelListener> listeners = new ObjectArrayList<LevelListener>();
    @NotNull
    private final @NotNull Set<@NotNull ChunkCoordinate> positionsToUpdate = new ObjectOpenHashSet<ChunkCoordinate>();
    @NotNull
    private final @NotNull List<@NotNull Entity> entityBuffer = new ObjectArrayList<Entity>();
    @NotNull
    private final @NotNull Set<@NotNull NextTickListEntry> immediatelyUpdatedPositions = new ObjectOpenHashSet<NextTickListEntry>();
    public boolean scheduledUpdatesAreImmediate = false;
    public int skyDarken = 0;
    protected int updateLCG = new Random().nextInt();
    public int lightningFlicker = 0;
    public int rainbowTicks = 0;
    public int startingRainbowTicks = 0;
    public boolean dayCanHaveRainbow = true;
    public boolean noNeighborUpdate = false;
    private long lockTimestamp = System.currentTimeMillis();
    @NotNull
    public final Random rand = new Random();
    public boolean isNewWorld = false;
    public Dimension dimension;
    public WorldType worldType;
    public IChunkProvider chunkProvider;
    public LevelStorage saveHandler;
    protected LevelData levelData;
    public DimensionData dimensionData;
    public boolean findingSpawnPoint;
    protected boolean enoughPlayersSleeping;
    public SavedDataStorage savedDataStorage;
    protected final LightingEngine lightingEngine = new LightingEngineLegacy(this);
    private boolean updatingTileEntities;
    private int caveSoundCounter = this.rand.nextInt(12000);
    public boolean isClientSide = false;
    public int sleepPercent = 100;
    private long runtime = 0L;
    public int dayCountLastTick;
    public BiomeProvider biomeProvider;
    public AuroraProvider auroraProvider;
    public SeasonManager seasonManager;
    public WeatherManager weatherManager;
    private CommandManager commandManager;
    @NotNull
    private final WireHandler wireHandler;

    public World(LevelStorage saveHandler, String name, long seed, Dimension dimension, WorldType worldType) {
        this.saveHandler = saveHandler;
        this.savedDataStorage = new SavedDataStorage(saveHandler);
        this.levelData = saveHandler.getLevelData();
        boolean bl = this.isNewWorld = this.levelData == null;
        this.dimension = dimension != null ? dimension : (this.levelData != null ? (Dimension)Dimension.getDimensionList().get(this.levelData.getDimension()) : (Dimension)Dimension.getDimensionList().get(0));
        this.dimensionData = saveHandler.getDimensionData(this.dimension.id);
        this.worldType = worldType != null ? worldType : (this.dimensionData != null ? this.dimensionData.getWorldType() : this.dimension.defaultWorldType);
        boolean isNewWorld = false;
        if (this.levelData == null) {
            this.levelData = new LevelData(seed, name);
            isNewWorld = true;
        }
        if (this.dimensionData == null) {
            this.dimensionData = new DimensionData(this.worldType);
            this.weatherManager = new WeatherManager(this);
        } else {
            this.weatherManager = new WeatherManager(this, this.dimensionData.getCurrentWeather(), this.dimensionData.getNextWeather(), this.dimensionData.getWeatherDuration(), this.dimensionData.getWeatherPower());
        }
        this.chunkProvider = this.createChunkProvider();
        this.auroraProvider = new AuroraProvider(this, this.levelData.getRandomSeed());
        this.seasonManager = SeasonManager.fromConfig(this, this.worldType.getSeasonConfig());
        this.biomeProvider = this.worldType.createBiomeProvider(this);
        if (isNewWorld) {
            this.worldType.onWorldCreation(this);
            this.getInitialSpawnLocation();
        }
        this.updateSkyBrightness();
        this.commandManager = new CommandManager(Global.isServer);
        this.commandManager.init();
        this.wireHandler = new WireHandler(this);
    }

    public World(World world, Dimension dimension) {
        this.lockTimestamp = world.lockTimestamp;
        this.saveHandler = world.saveHandler;
        this.levelData = new LevelData(world.levelData);
        this.dimensionData = world.saveHandler.getDimensionData(dimension.id);
        if (this.dimensionData == null) {
            this.dimensionData = new DimensionData(dimension.defaultWorldType);
            this.weatherManager = new WeatherManager(this);
        } else {
            this.weatherManager = new WeatherManager(this, this.dimensionData.getCurrentWeather(), this.dimensionData.getNextWeather(), this.dimensionData.getWeatherDuration(), this.dimensionData.getWeatherPower());
        }
        this.worldType = this.dimensionData.getWorldType();
        this.savedDataStorage = new SavedDataStorage(this.saveHandler);
        this.dimension = dimension;
        this.chunkProvider = this.createChunkProvider();
        this.seasonManager = SeasonManager.fromConfig(this, this.worldType.getSeasonConfig());
        this.biomeProvider = this.worldType.createBiomeProvider(this);
        this.updateSkyBrightness();
        this.auroraProvider = new AuroraProvider(this, this.getRandomSeed());
        this.commandManager = new CommandManager(Global.isServer);
        this.commandManager.init();
        this.wireHandler = new WireHandler(this);
    }

    public World(LevelStorage saveHandler, String name, Dimension dimension, WorldType worldType, long seed) {
        this.saveHandler = saveHandler;
        this.levelData = new LevelData(seed, name);
        this.dimension = dimension;
        this.dimensionData = new DimensionData(worldType);
        this.worldType = worldType;
        this.savedDataStorage = new SavedDataStorage(saveHandler);
        this.chunkProvider = this.createChunkProvider();
        this.seasonManager = SeasonManager.fromConfig(this, this.worldType.getSeasonConfig());
        this.updateSkyBrightness();
        this.weatherManager = new WeatherManager(this);
        this.auroraProvider = new AuroraProvider(this, this.levelData.getRandomSeed());
        this.biomeProvider = this.worldType.createBiomeProvider(this);
        this.commandManager = new CommandManager(Global.isServer);
        this.commandManager.init();
        this.wireHandler = new WireHandler(this);
    }

    public World() {
        this.wireHandler = new WireHandler(this);
    }

    public <T> T getGameRuleValue(GameRule<T> gameRule) {
        return this.levelData.getGameRules().getValue(gameRule);
    }

    public SpawnerConfig getSpawnerConfig() {
        return this.levelData.getSpawnerConfig();
    }

    @Override
    public int getHeightBlocks() {
        return 256;
    }

    public BiomeProvider getBiomeProvider() {
        return this.biomeProvider;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    @NotNull
    public WireHandler getWireHandler() {
        return this.wireHandler;
    }

    protected IChunkProvider createChunkProvider() {
        IChunkLoader chunkLoader = this.saveHandler.getChunkLoader(this.dimension);
        return Global.accessor.createChunkProvider(this, chunkLoader);
    }

    protected void getInitialSpawnLocation() {
        this.findingSpawnPoint = true;
        this.getWorldType().getInitialSpawnLocation(this);
        this.findingSpawnPoint = false;
    }

    public void getRespawnLocation() {
        this.getWorldType().getRespawnLocation(this);
    }

    public int getTopBlock(int x, int z) {
        int y = this.levelData.getSpawnY() - 1;
        while (!this.isAirBlock(x, y + 1, z)) {
            ++y;
        }
        return this.getBlockId(x, y, z);
    }

    public void spawnPlayerWithLoadedChunks(Player player, boolean respawning) {
        try {
            PlayerIO playerIO;
            if (!respawning && (playerIO = this.saveHandler.getPlayerFileData()) != null) {
                playerIO.load(player);
            }
            int chunkX = MathHelper.floor_float((int)player.x) / 16;
            int chunkZ = MathHelper.floor_float((int)player.z) / 16;
            this.chunkProvider.setCurrentChunkOver(chunkX, chunkZ);
            this.entityJoinedWorld(player);
        }
        catch (Exception e) {
            LOGGER.error("Failed to spawn player with loaded chunks!", e);
        }
    }

    public void saveWorld(boolean saveImmediately, ProgressListener progressUpdate, boolean saveLevelData) {
        if (!this.chunkProvider.canSave()) {
            return;
        }
        if (saveLevelData) {
            if (progressUpdate != null) {
                progressUpdate.progressStart("Saving level data");
            }
            this.saveWorldData();
        }
        if (progressUpdate != null) {
            progressUpdate.progressStage("Saving chunks");
        }
        this.chunkProvider.saveChunks(saveImmediately, progressUpdate);
        if (progressUpdate != null) {
            progressUpdate.progressStop();
        }
    }

    private void saveWorldData() {
        this.checkSessionLock();
        this.saveHandler.saveLevelDataAndPlayerData(this.levelData, this.players);
        this.saveHandler.saveDimensionData(this.dimension.id, this.dimensionData);
        this.savedDataStorage.save();
    }

    public boolean pauseScreenSave(int i) {
        if (!this.chunkProvider.canSave()) {
            return true;
        }
        if (i == 0) {
            this.saveWorldData();
        }
        return this.chunkProvider.saveChunks(false, null);
    }

    @Nullable
    public Weather getCurrentWeather() {
        return this.weatherManager == null ? null : this.weatherManager.getCurrentWeather();
    }

    @Override
    public int getBlockId(@NotNull TilePosc tilePos) {
        if (!tilePos.inBounds(this)) {
            return 0;
        }
        return this.getChunk(tilePos).getBlockId(new ChunkTilePos(tilePos));
    }

    @Override
    @Nullable
    public Block<?> getBlock(@NotNull TilePosc tilePos) {
        return Blocks.getBlock(this.getBlockId(tilePos));
    }

    @Override
    public double getBlockTemperature(@NotNull TilePosc tilePos) {
        if (tilePos.x() < -32000000 || tilePos.z() < -32000000 || tilePos.x() > 32000000 || tilePos.z() > 32000000) {
            return 0.0;
        }
        int chunkX = Math.floorDiv(tilePos.x(), 16);
        int chunkZ = Math.floorDiv(tilePos.z(), 16);
        double temperature = Double.NEGATIVE_INFINITY;
        Chunk chunk = null;
        if (this.isChunkLoaded(chunkX, chunkZ)) {
            chunk = this.getChunkFromChunkCoords(chunkX, chunkZ);
            temperature = chunk.getBlockTemperature(tilePos.x() & 0xF, tilePos.z() & 0xF);
        }
        if (temperature == Double.NEGATIVE_INFINITY) {
            temperature = this.getBiomeProvider().getTemperature(tilePos.x(), tilePos.z());
            if (chunk != null) {
                chunk.setBlockTemperature(tilePos.x() & 0xF, tilePos.z() & 0xF, temperature);
            }
        }
        return temperature;
    }

    @Override
    public double getBlockHumidity(@NotNull TilePosc tilePos) {
        if (tilePos.x() < -32000000 || tilePos.z() < -32000000 || tilePos.x() > 32000000 || tilePos.z() > 32000000) {
            return 0.0;
        }
        int chunkX = Math.floorDiv(tilePos.x(), 16);
        int chunkZ = Math.floorDiv(tilePos.z(), 16);
        double humidity = Double.NEGATIVE_INFINITY;
        Chunk chunk = null;
        if (this.isChunkLoaded(chunkX, chunkZ)) {
            chunk = this.getChunkFromChunkCoords(chunkX, chunkZ);
            humidity = chunk.getBlockHumidity(tilePos.x() & 0xF, tilePos.z() & 0xF);
        }
        if (humidity == Double.NEGATIVE_INFINITY) {
            humidity = this.getBiomeProvider().getHumidity(tilePos.x(), tilePos.z());
            if (chunk != null) {
                chunk.setBlockHumidity(tilePos.x() & 0xF, tilePos.z() & 0xF, humidity);
            }
        }
        return humidity;
    }

    @Override
    @NotNull
    public SeasonManager getSeasonManager() {
        return this.seasonManager;
    }

    @Override
    public double getBlockVariety(@NotNull TilePosc tilePos) {
        if (tilePos.x() < -32000000 || tilePos.z() < -32000000 || tilePos.x() > 32000000 || tilePos.z() > 32000000) {
            return 0.0;
        }
        int chunkX = Math.floorDiv(tilePos.x(), 16);
        int chunkZ = Math.floorDiv(tilePos.z(), 16);
        double variety = Double.NEGATIVE_INFINITY;
        Chunk chunk = null;
        if (this.isChunkLoaded(chunkX, chunkZ)) {
            chunk = this.getChunkFromChunkCoords(chunkX, chunkZ);
            variety = chunk.getBlockVariety(tilePos.x() & 0xF, tilePos.z() & 0xF);
        }
        if (variety == Double.NEGATIVE_INFINITY) {
            variety = this.getBiomeProvider().getVariety(tilePos.x(), tilePos.z());
            if (chunk != null) {
                chunk.setBlockVariety(tilePos.x() & 0xF, tilePos.z() & 0xF, variety);
            }
        }
        return variety;
    }

    @Override
    @NotNull
    public Biome getBlockBiome(@NotNull TilePosc tilePos) {
        if (!tilePos.inBounds(this)) {
            return Biomes.OVERWORLD_PLAINS;
        }
        int chunkX = Math.floorDiv(tilePos.x(), 16);
        int chunkZ = Math.floorDiv(tilePos.z(), 16);
        Biome biome = null;
        Chunk chunk = null;
        if (this.isChunkLoaded(chunkX, chunkZ)) {
            chunk = this.getChunkFromChunkCoords(chunkX, chunkZ);
            biome = chunk.getBlockBiome(tilePos.x() & 0xF, tilePos.y(), tilePos.z() & 0xF);
        }
        if (biome == null) {
            biome = this.getBiomeProvider().getBiome(tilePos.x(), tilePos.y(), tilePos.z());
            if (chunk != null) {
                chunk.setBlockBiome(tilePos.x() & 0xF, tilePos.y(), tilePos.z() & 0xF, biome);
            }
        }
        assert (biome != null) : "Biome should never be null!";
        return biome;
    }

    public boolean getBlockLitInteriorSurface(@NotNull TilePosc tilePos) {
        if (!tilePos.inBounds(this)) {
            return true;
        }
        return Block.getIsLitInteriorSurface(this, tilePos);
    }

    @Deprecated
    public final boolean getBlockLitInteriorSurface(int x, int y, int z) {
        return this.getBlockLitInteriorSurface(new TilePos(x, y, z));
    }

    public boolean isAirBlock(@NotNull TilePosc tilePos) {
        return this.getBlockId(tilePos) == 0;
    }

    @Deprecated
    public final boolean isAirBlock(int x, int y, int z) {
        return this.isAirBlock(new TilePos(x, y, z));
    }

    public boolean isBlockLoaded(@NotNull TilePosc tilePos) {
        if (!tilePos.inBounds(this)) {
            return false;
        }
        return this.isChunkLoaded(new ChunkPos(tilePos));
    }

    @Deprecated
    public final boolean isBlockLoaded(int x, int y, int z) {
        return this.isBlockLoaded(new TilePos(x, y, z));
    }

    public boolean areBlocksLoaded(@NotNull TilePosc tilePos, int range) {
        return this.areBlocksLoaded((TilePosc)tilePos.sub(range, range, range, new TilePos()), tilePos.add(range, range, range, new TilePos()));
    }

    @Deprecated
    public final boolean areBlocksLoaded(int x, int y, int z, int range) {
        return this.areBlocksLoaded((TilePosc)new TilePos(x, y, z), range);
    }

    public boolean areBlocksLoaded(@NotNull TilePosc min, @NotNull TilePosc max) {
        int minX = Math.min(min.x(), max.x());
        int minZ = Math.min(min.z(), max.z());
        int maxX = Math.max(min.x(), max.x());
        int maxZ = Math.max(min.z(), max.z());
        maxX >>= 4;
        maxZ >>= 4;
        @NotNull ChunkPos chunkPos = new ChunkPos(minX >>= 4, minZ >>= 4);
        while (chunkPos.x <= maxX) {
            while (chunkPos.z <= maxZ) {
                if (!this.isChunkLoaded(chunkPos)) {
                    return false;
                }
                ++chunkPos.z;
            }
            ++chunkPos.x;
        }
        return true;
    }

    @Deprecated
    public final boolean areBlocksLoaded(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return this.areBlocksLoaded((TilePosc)new TilePos(minX, minY, minZ), new TilePos(maxX, maxY, maxZ));
    }

    public boolean isChunkLoaded(@NotNull ChunkPos chunkPos) {
        return this.chunkProvider.isChunkLoaded(chunkPos);
    }

    @Deprecated
    public final boolean isChunkLoaded(int x, int z) {
        return this.isChunkLoaded(new ChunkPos(x, z));
    }

    @NotNull
    public Chunk getChunk(@NotNull TilePosc tilePos) {
        return this.getChunk(new ChunkPos(tilePos));
    }

    @Deprecated
    @NotNull
    public final Chunk getChunkFromBlockCoords(int x, int z) {
        return this.getChunk(new TilePos(x, 0, z));
    }

    @NotNull
    public Chunk getChunk(@NotNull ChunkPos chunkPos) {
        return this.chunkProvider.provideChunk(chunkPos, true);
    }

    @NotNull
    public Chunk getChunk(@NotNull ChunkPos chunkPos, boolean priority) {
        return this.chunkProvider.provideChunk(chunkPos, priority);
    }

    @Deprecated
    @NotNull
    public final Chunk getChunkFromChunkCoords(int x, int z) {
        return this.getChunk(new ChunkPos(x, z));
    }

    @Override
    public boolean setBlockIdData(@NotNull TilePosc tilePos, int id, int data) {
        if (!tilePos.inBounds(this)) {
            return false;
        }
        return this.getChunk(tilePos).setBlockIdData(new ChunkTilePos(tilePos), id, data);
    }

    public boolean setBlockIdRaw(@NotNull TilePosc tilePos, int id) {
        return this.setBlockIdDataRaw(tilePos, id, this.getBlockData(tilePos));
    }

    @Deprecated
    public final boolean setBlockRaw(int x, int y, int z, int id) {
        return this.setBlockIdRaw(new TilePos(x, y, z), id);
    }

    public boolean setBlockIdDataRaw(@NotNull TilePosc tilePos, int id, int data) {
        if (!tilePos.inBounds(this)) {
            return false;
        }
        return this.getChunk(tilePos).setBlockIdDataRaw(new ChunkTilePos(tilePos), id, data);
    }

    @Deprecated
    public final boolean setBlockAndMetadataRaw(int x, int y, int z, int id, int metadata) {
        return this.setBlockIdDataRaw(new TilePos(x, y, z), id, metadata);
    }

    @Override
    public boolean setBlockId(@NotNull TilePosc tilePos, int id) {
        if (!tilePos.inBounds(this)) {
            return false;
        }
        return this.getChunk(tilePos).setBlockId(new ChunkTilePos(tilePos), id);
    }

    @Override
    @NotNull
    public Material getBlockMaterial(@NotNull TilePosc tilePos) {
        @Nullable Block<?> block = this.getBlock(tilePos);
        if (block == null) {
            return Materials.AIR;
        }
        return block.getMaterial();
    }

    @Override
    public int getBlockData(@NotNull TilePosc tilePos) {
        if (!tilePos.inBounds(this)) {
            return 0;
        }
        return this.getChunk(tilePos).getBlockData(new ChunkTilePos(tilePos));
    }

    public boolean setBlockDataNotify(@NotNull TilePosc tilePos, int data) {
        if (this.setBlockData(tilePos, data)) {
            this.markBlockNeedsUpdate(tilePos);
            int id = this.getBlockId(tilePos);
            if (Blocks.neighborNotifyOnMetadataChangeDisabled[id & 0x3FFF]) {
                this.notifyBlocksOfNeighborChange(tilePos, id);
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public final void setBlockMetadataWithNotify(int x, int y, int z, int data) {
        this.setBlockDataNotify(new TilePos(x, y, z), data);
    }

    @Override
    public boolean setBlockData(@NotNull TilePosc tilePos, int data) {
        if (!tilePos.inBounds(this)) {
            return false;
        }
        this.getChunk(tilePos).setBlockData(new ChunkTilePos(tilePos), data);
        return true;
    }

    public boolean setBlockIdNotify(@NotNull TilePosc tilePos, int id) {
        if (this.setBlockId(tilePos, id)) {
            this.notifyBlockChange(tilePos, id);
            return true;
        }
        return false;
    }

    @Deprecated
    public final boolean setBlockWithNotify(int x, int y, int z, int id) {
        return this.setBlockIdNotify(new TilePos(x, y, z), id);
    }

    public boolean setBlockIdDataNotify(@NotNull TilePosc tilePos, int id, int data) {
        if (this.setBlockIdData(tilePos, id, data)) {
            this.notifyBlockChange(tilePos, id);
            return true;
        }
        return false;
    }

    @Deprecated
    public final boolean setBlockAndMetadataWithNotify(int x, int y, int z, int id, int data) {
        return this.setBlockIdDataNotify(new TilePos(x, y, z), id, data);
    }

    public void markBlockNeedsUpdate(@NotNull TilePosc tilePos) {
        for (LevelListener listener : this.listeners) {
            listener.blockChanged(tilePos.x(), tilePos.y(), tilePos.z());
        }
    }

    @Deprecated
    public final void markBlockNeedsUpdate(int x, int y, int z) {
        this.markBlockNeedsUpdate(new TilePos(x, y, z));
    }

    public void notifyBlockChange(@NotNull TilePosc tilePos, int id) {
        this.markBlockNeedsUpdate(tilePos);
        this.notifyBlocksOfNeighborChange(tilePos, id);
    }

    @Deprecated
    public final void notifyBlockChange(int x, int y, int z, int id) {
        this.notifyBlockChange(new TilePos(x, y, z), id);
    }

    public void markBlocksDirtyVertical(int x, int z, int y0, int y1) {
        this.markBlocksDirty(new TilePos(x, Math.min(y0, y1), z), new TilePos(x, Math.max(y0, y1), z));
    }

    public void markBlockDirty(@NotNull TilePosc tilePos) {
        for (LevelListener listener : this.listeners) {
            listener.setBlocksDirty(tilePos.x(), tilePos.y(), tilePos.z(), tilePos.x(), tilePos.y(), tilePos.z());
        }
    }

    @Deprecated
    public final void markBlockDirty(int x, int y, int z) {
        this.markBlockDirty(new TilePos(x, y, z));
    }

    public void markBlocksDirty(@NotNull TilePosc min, @NotNull TilePosc max) {
        for (LevelListener listener : this.listeners) {
            listener.setBlocksDirty(Math.min(min.x(), max.x()), Math.min(min.y(), max.y()), Math.min(min.z(), max.z()), Math.max(min.x(), max.x()), Math.max(min.y(), max.y()), Math.max(min.z(), max.z()));
        }
    }

    @Deprecated
    public final void markBlocksDirty(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.markBlocksDirty(new TilePos(minX, minY, minZ), new TilePos(maxX, maxY, maxZ));
    }

    public void notifyBlocksOfNeighborChange(@NotNull TilePosc tilePos, int id) {
        TilePos queryPos = new TilePos();
        this.notifyBlockOfNeighborChange(tilePos.add(Direction.WEST, queryPos), id);
        this.notifyBlockOfNeighborChange(tilePos.add(Direction.EAST, queryPos), id);
        this.notifyBlockOfNeighborChange(tilePos.add(Direction.DOWN, queryPos), id);
        this.notifyBlockOfNeighborChange(tilePos.add(Direction.UP, queryPos), id);
        this.notifyBlockOfNeighborChange(tilePos.add(Direction.NORTH, queryPos), id);
        this.notifyBlockOfNeighborChange(tilePos.add(Direction.SOUTH, queryPos), id);
    }

    @Deprecated
    public final void notifyBlocksOfNeighborChange(int x, int y, int z, int id) {
        this.notifyBlocksOfNeighborChange(new TilePos(x, y, z), id);
    }

    private void notifyBlockOfNeighborChange(@NotNull TilePosc tilePos, int id) {
        if (this.noNeighborUpdate || this.isClientSide) {
            return;
        }
        @Nullable Block<?> block = this.getBlock(tilePos);
        if (block != null) {
            block.onNeighborChanged(this, tilePos, id);
        }
    }

    public boolean canBlockSeeSky(@NotNull TilePosc tilePos) {
        return this.getChunk(tilePos).canBlockSeeSky(new ChunkTilePos(tilePos));
    }

    @Deprecated
    public final boolean canBlockSeeTheSky(int x, int y, int z) {
        return this.canBlockSeeSky(new TilePos(x, y, z));
    }

    public int getFullBlockLightValue(@NotNull TilePosc tilePos) {
        if (tilePos.y() < 0) {
            return 0;
        }
        return this.getChunk(tilePos).getRawBrightness(new ChunkTilePos(new TilePos(tilePos.x(), Math.min(tilePos.y(), this.getHeightBlocks() - 1), tilePos.z())), 0);
    }

    @Deprecated
    public final int getFullBlockLightValue(int x, int y, int z) {
        return this.getFullBlockLightValue(new TilePos(x, y, z));
    }

    public int getBlockLightValue(@NotNull TilePosc tilePos) {
        return this.getBlockLightValue_do(tilePos, true);
    }

    @Deprecated
    public final int getBlockLightValue(int x, int y, int z) {
        return this.getBlockLightValue(new TilePos(x, y, z));
    }

    private int getBlockLightValue_do(@NotNull TilePosc tilePos, boolean first) {
        if (!tilePos.inBounds(this)) {
            return 15;
        }
        if (first && this.getBlockLitInteriorSurface(tilePos)) {
            TilePos queryPos = new TilePos();
            int lightUp = this.getBlockLightValue_do(tilePos.add(Direction.UP, queryPos), false);
            int lightEast = this.getBlockLightValue_do(tilePos.add(Direction.EAST, queryPos), false);
            int lightWest = this.getBlockLightValue_do(tilePos.add(Direction.WEST, queryPos), false);
            int lightSouth = this.getBlockLightValue_do(tilePos.add(Direction.SOUTH, queryPos), false);
            int lightNorth = this.getBlockLightValue_do(tilePos.add(Direction.NORTH, queryPos), false);
            return Math.max(lightUp, Math.max(lightEast, Math.max(lightWest, Math.max(lightSouth, lightNorth))));
        }
        if (tilePos.y() < 0) {
            return 0;
        }
        return this.getChunk(tilePos).getRawBrightness(new ChunkTilePos(tilePos.x(), Math.min(tilePos.y(), this.getHeightBlocks() - 1), tilePos.z()), this.skyDarken);
    }

    public boolean canLoadedBlockSeeSky(@NotNull TilePosc tilePos) {
        if (tilePos.y() >= this.getHeightBlocks()) {
            return true;
        }
        if (!tilePos.inBounds(this)) {
            return false;
        }
        if (!this.isBlockLoaded(tilePos)) {
            return false;
        }
        return this.getChunk(tilePos).canBlockSeeSky(new ChunkTilePos(tilePos));
    }

    @Deprecated
    public final boolean canExistingBlockSeeTheSky(int x, int y, int z) {
        return this.canLoadedBlockSeeSky(new TilePos(x, y, z));
    }

    public int getHeightValue(int x, int z) {
        if (x < -32000000 || z < -32000000 || x > 32000000 || z > 32000000) {
            return 0;
        }
        @NotNull TilePos tilePos = new TilePos(x, 0, z);
        if (!this.isBlockLoaded(tilePos)) {
            return 0;
        }
        return this.getChunk(tilePos).getHeightValue(x & 0xF, z & 0xF);
    }

    @Override
    public int getSavedLightValue(@NotNull LightLayer lightLayer, @NotNull TilePosc tilePos) {
        if (!tilePos.inBounds(this)) {
            return lightLayer.defaultLightLevel;
        }
        if (!this.isBlockLoaded(tilePos)) {
            return 0;
        }
        return this.getChunk(tilePos).getBrightness(lightLayer, new ChunkTilePos(tilePos));
    }

    @Override
    public boolean isRetro() {
        return this.worldType.isRetro();
    }

    @Override
    public void setLightValue(@NotNull LightLayer lightLayer, @NotNull TilePosc tilePos, int value) {
        if (tilePos.inBounds(this) && this.isBlockLoaded(tilePos)) {
            this.getChunk(tilePos).setBrightness(lightLayer, new ChunkTilePos(tilePos), value);
            for (LevelListener listener : this.listeners) {
                listener.blockChanged(tilePos.x(), tilePos.y(), tilePos.z());
            }
        }
    }

    @Override
    public float getBrightness(@NotNull TilePosc tilePos, int lightEmission) {
        int lightValue = this.getBlockLightValue(tilePos);
        return this.worldType.getBrightnessRamp()[Math.max(lightValue, lightEmission)];
    }

    @Override
    public int getLightmapCoord(@NotNull TilePosc tilePos, int lightEmission) {
        int skyLight = this.getSavedLightValue(LightLayer.Sky, tilePos);
        int blockLight = Math.max(this.getSavedLightValue(LightLayer.Block, tilePos), lightEmission);
        if (this.getBlockLitInteriorSurface(tilePos)) {
            TilePos queryPos = new TilePos();
            skyLight = Math.max(skyLight, this.getSavedLightValue(LightLayer.Sky, tilePos.add(Direction.UP, queryPos)));
            skyLight = Math.max(skyLight, this.getSavedLightValue(LightLayer.Sky, tilePos.add(Direction.DOWN, queryPos)));
            skyLight = Math.max(skyLight, this.getSavedLightValue(LightLayer.Sky, tilePos.add(Direction.EAST, queryPos)));
            skyLight = Math.max(skyLight, this.getSavedLightValue(LightLayer.Sky, tilePos.add(Direction.WEST, queryPos)));
            skyLight = Math.max(skyLight, this.getSavedLightValue(LightLayer.Sky, tilePos.add(Direction.SOUTH, queryPos)));
            skyLight = Math.max(skyLight, this.getSavedLightValue(LightLayer.Sky, tilePos.add(Direction.NORTH, queryPos)));
            blockLight = Math.max(blockLight, this.getSavedLightValue(LightLayer.Block, tilePos.add(Direction.UP, queryPos)));
            blockLight = Math.max(blockLight, this.getSavedLightValue(LightLayer.Block, tilePos.add(Direction.DOWN, queryPos)));
            blockLight = Math.max(blockLight, this.getSavedLightValue(LightLayer.Block, tilePos.add(Direction.EAST, queryPos)));
            blockLight = Math.max(blockLight, this.getSavedLightValue(LightLayer.Block, tilePos.add(Direction.WEST, queryPos)));
            blockLight = Math.max(blockLight, this.getSavedLightValue(LightLayer.Block, tilePos.add(Direction.SOUTH, queryPos)));
            blockLight = Math.max(blockLight, this.getSavedLightValue(LightLayer.Block, tilePos.add(Direction.NORTH, queryPos)));
        }
        return this.getLightmapCoord(skyLight, blockLight);
    }

    @Override
    public int getLightmapCoord(int skyLight, int blockLight) {
        return 0;
    }

    @Override
    public float getLightBrightness(@NotNull TilePosc tilePos) {
        return this.worldType.getBrightnessRamp()[this.getBlockLightValue(tilePos)];
    }

    public boolean isDaytime() {
        return this.skyDarken < 4;
    }

    @Nullable
    public HitResult checkBlockCollisionBetweenPoints(@NotNull Vector3dc start, @NotNull Vector3dc end) {
        return this.checkBlockCollisionBetweenPoints(start, end, false, false, false);
    }

    @Nullable
    public HitResult checkBlockCollisionBetweenPoints(@NotNull Vector3dc start, @NotNull Vector3dc end, boolean shouldCollideWithFluids) {
        return this.checkBlockCollisionBetweenPoints(start, end, shouldCollideWithFluids, false, false);
    }

    @Nullable
    public HitResult checkBlockCollisionBetweenPoints(@NotNull Vector3dc start, @NotNull Vector3dc end, boolean shouldCollideWithFluids, boolean ignoreNonColliderBlocks, boolean useSelectorBoxes) {
        HitResult hitResult;
        if (!start.isFinite()) {
            return null;
        }
        if (!end.isFinite()) {
            return null;
        }
        Vector3d start2 = new Vector3d(start);
        Vector3d end2 = new Vector3d(end);
        TilePos blockEnd = new TilePos(end2);
        TilePos blockStart = new TilePos(start2);
        int id = this.getBlockId(blockStart);
        int meta = this.getBlockData(blockStart);
        Block<?> block = Blocks.blocksList[id];
        if ((!ignoreNonColliderBlocks || block == null || (useSelectorBoxes ? block.getSelectionAABB(this, blockStart) : block.getCollisionAABB(this, blockStart)) != null) && id > 0 && block != null && block.canCollideCheck(meta, shouldCollideWithFluids) && (hitResult = block.collisionRayTrace(this, blockStart, start2, end2, useSelectorBoxes)) != null) {
            return hitResult;
        }
        int l1 = 200;
        while (l1-- >= 0) {
            HitResult hitResult2;
            if (!start2.isFinite()) {
                return null;
            }
            if (blockStart.equals(blockEnd)) {
                return null;
            }
            boolean flag2 = true;
            boolean flag3 = true;
            boolean flag4 = true;
            double d = 999.0;
            double d1 = 999.0;
            double d2 = 999.0;
            if (blockEnd.x > blockStart.x) {
                d = (double)blockStart.x + 1.0;
            } else if (blockEnd.x < blockStart.x) {
                d = (double)blockStart.x + 0.0;
            } else {
                flag2 = false;
            }
            if (blockEnd.y > blockStart.y) {
                d1 = (double)blockStart.y + 1.0;
            } else if (blockEnd.y < blockStart.y) {
                d1 = (double)blockStart.y + 0.0;
            } else {
                flag3 = false;
            }
            if (blockEnd.z > blockStart.z) {
                d2 = (double)blockStart.z + 1.0;
            } else if (blockEnd.z < blockStart.z) {
                d2 = (double)blockStart.z + 0.0;
            } else {
                flag4 = false;
            }
            double d3 = 999.0;
            double d4 = 999.0;
            double d5 = 999.0;
            double d6 = end2.x - start2.x;
            double d7 = end2.y - start2.y;
            double d8 = end2.z - start2.z;
            if (flag2) {
                d3 = (d - start2.x) / d6;
            }
            if (flag3) {
                d4 = (d1 - start2.y) / d7;
            }
            if (flag4) {
                d5 = (d2 - start2.z) / d8;
            }
            int byte0 = 0;
            if (d3 < d4 && d3 < d5) {
                byte0 = blockEnd.x > blockStart.x ? 4 : 5;
                start2.x = d;
                start2.y += d7 * d3;
                start2.z += d8 * d3;
            } else if (d4 < d5) {
                byte0 = blockEnd.y > blockStart.y ? 0 : 1;
                start2.x += d6 * d4;
                start2.y = d1;
                start2.z += d8 * d4;
            } else {
                byte0 = blockEnd.z > blockStart.z ? 2 : 3;
                start2.x += d6 * d5;
                start2.y += d7 * d5;
                start2.z = d2;
            }
            Vector3d startCopy = new Vector3d(start2);
            startCopy.x = MathHelper.floor(start2.x());
            blockStart.x = (int)startCopy.x;
            if (byte0 == 5) {
                --blockStart.x;
                startCopy.x += 1.0;
            }
            startCopy.y = MathHelper.floor(start2.y());
            blockStart.y = (int)startCopy.y;
            if (byte0 == 1) {
                --blockStart.y;
                startCopy.y += 1.0;
            }
            startCopy.z = MathHelper.floor(start2.z());
            blockStart.z = (int)startCopy.z;
            if (byte0 == 3) {
                --blockStart.z;
                startCopy.z += 1.0;
            }
            Block<?> block1 = this.getBlock(blockStart);
            int metadata1 = this.getBlockData(blockStart);
            if (ignoreNonColliderBlocks && block1 != null && (useSelectorBoxes ? block1.getSelectionAABB(this, blockStart) : block1.getCollisionAABB(this, blockStart)) == null || block1 == null || !block1.canCollideCheck(metadata1, shouldCollideWithFluids) || (hitResult2 = block1.collisionRayTrace(this, blockStart, start2, end2, useSelectorBoxes)) == null) continue;
            return hitResult2;
        }
        return null;
    }

    public void playSoundAtEntity(@Nullable Entity player, @NotNull Entity entity, String soundPath, float volume, float pitch) {
        for (LevelListener listener : this.listeners) {
            listener.playSound(player, soundPath, SoundCategory.ENTITY_SOUNDS, entity.x, entity.y - (double)entity.heightOffset, entity.z, volume, pitch);
        }
    }

    public void playSoundEffect(@Nullable Entity player, SoundCategory category, double x, double y, double z, String soundPath, float volume, float pitch) {
        for (LevelListener listener : this.listeners) {
            listener.playSound(player, soundPath, category, x, y, z, volume, pitch);
        }
    }

    public void playBlockSoundEffect(@Nullable Entity player, double x, double y, double z, Block<?> block, EnumBlockSoundEffectType soundType) {
        if (block == null) {
            return;
        }
        BlockSound sound = block.getSound();
        if (sound == null) {
            return;
        }
        String name = soundType == EnumBlockSoundEffectType.MINE ? sound.getBreakSoundName() : sound.getStepSoundName();
        this.playSoundEffect(player, SoundCategory.WORLD_SOUNDS, x, y, z, name, soundType.modifyVolume(sound.getVolume()), soundType.modifyPitch(sound.getPitch()));
    }

    public void playRecord(@Nullable String soundPath, @Nullable String author, @NotNull TilePos tilePos) {
        for (LevelListener listener : this.listeners) {
            listener.playStreamingMusic(soundPath, author, tilePos.x, tilePos.y, tilePos.z);
        }
    }

    @Deprecated
    public final void playRecord(@Nullable String soundPath, @Nullable String author, int x, int y, int z) {
        this.playRecord(soundPath, author, new TilePos(x, y, z));
    }

    public void spawnParticle(@NotNull String particleKey, double x, double y, double z, double motionX, double motionY, double motionZ, int data, double maxDistance) {
        for (LevelListener listener : this.listeners) {
            listener.addParticle(particleKey, x, y, z, motionX, motionY, motionZ, data, maxDistance);
        }
    }

    public void spawnParticle(@NotNull String particleKey, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
        for (LevelListener listener : this.listeners) {
            listener.addParticle(particleKey, x, y, z, motionX, motionY, motionZ, data);
        }
    }

    public boolean addWeatherEffect(@NotNull Entity entity) {
        this.weatherEffects.add(entity);
        return true;
    }

    public void addRainbow(int rainbowTicks) {
        this.rainbowTicks = this.startingRainbowTicks = rainbowTicks;
    }

    public boolean entityJoinedWorld(Entity entity) {
        int i = MathHelper.floor(entity.x / 16.0);
        int j = MathHelper.floor(entity.z / 16.0);
        boolean flag = entity instanceof Player;
        if (flag || this.isChunkLoaded(i, j)) {
            if (entity instanceof Player) {
                Player entityplayer = (Player)entity;
                this.players.add(entityplayer);
                this.updateEnoughPlayersSleepingFlag(null);
            }
            this.getChunkFromChunkCoords(i, j).addEntity(entity);
            this.entities.add(entity);
            this.obtainEntitySkin(entity);
            return true;
        }
        return false;
    }

    protected void obtainEntitySkin(Entity entity) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).entityAdded(entity);
        }
    }

    protected void releaseEntitySkin(Entity entity) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).entityRemoved(entity);
        }
    }

    public void setEntityDead(Entity entity) {
        if (entity.passenger != null) {
            entity.passenger.startRiding(null);
        }
        if (entity.vehicle != null) {
            entity.startRiding(null);
        }
        entity.remove();
        if (entity instanceof Player) {
            this.players.remove((Player)entity);
            this.updateEnoughPlayersSleepingFlag(null);
        }
    }

    public void removePlayer(Entity entity) {
        entity.remove();
        if (entity instanceof Player) {
            this.players.remove((Player)entity);
            this.updateEnoughPlayersSleepingFlag(null);
        }
        int i = entity.chunkCoordX;
        int j = entity.chunkCoordZ;
        if (entity.addedToChunk && this.isChunkLoaded(i, j)) {
            this.getChunkFromChunkCoords(i, j).removeEntity(entity);
        }
        this.entities.remove(entity);
        this.releaseEntitySkin(entity);
    }

    public void addListener(@NotNull LevelListener levelListener) {
        this.listeners.add(levelListener);
    }

    public void removeListener(@NotNull LevelListener levelListener) {
        this.listeners.remove(levelListener);
    }

    @NotNull
    public @NotNull List<@NotNull AABBdc> getCubes(@NotNull Entity entity, @NotNull AABBdc aabb) {
        TilePos d = new TilePos(entity);
        this.collidingBoundingBoxes.clear();
        if (!d.inBounds(this)) {
            return this.collidingBoundingBoxes;
        }
        int minX = MathHelper.floor(aabb.minX());
        int maxX = MathHelper.floor(aabb.maxX() + 1.0);
        int minY = MathHelper.floor(aabb.minY());
        int maxY = MathHelper.floor(aabb.maxY() + 1.0);
        int minZ = MathHelper.floor(aabb.minZ());
        int maxZ = MathHelper.floor(aabb.maxZ() + 1.0);
        ChunkPos p = new ChunkPos(0, 0);
        int cMinX = minX >> 4;
        int cMaxX = maxX >> 4;
        int cMinZ = minZ >> 4;
        int cMaxZ = maxZ >> 4;
        p.x = cMinX;
        while (p.x <= cMaxX) {
            p.z = cMinZ;
            while (p.z <= cMaxZ) {
                if (!this.chunkProvider.isChunkLoaded(p)) {
                    return this.collidingBoundingBoxes;
                }
                ++p.z;
            }
            ++p.x;
        }
        d.x = minX - 1;
        while (d.x <= maxX) {
            d.z = minZ - 1;
            while (d.z <= maxZ) {
                d.y = minY - 1;
                while (d.y <= maxY) {
                    Block<?> block = this.getBlock(d);
                    if (block != null) {
                        int metadata = this.getBlockData(d);
                        if (block.collidesWithEntity(entity, this, d) && entity.collidesWithBlock(block, metadata)) {
                            block.getCollisionAABBs(this, d, aabb, this.collidingBoundingBoxes);
                        }
                    }
                    ++d.y;
                }
                ++d.z;
            }
            ++d.x;
        }
        double radius = 0.25;
        List<Entity> entities = this.getEntitiesWithinAABBExcludingEntity(entity, MathHelper.aabbGrow(aabb, radius, radius, radius, new AABBd()));
        for (Entity e : entities) {
            AABBdc entityBB = e.getCollisionAABB();
            if (entityBB == null || !entityBB.intersectsAABB((AABBd)aabb)) continue;
            this.collidingBoundingBoxes.add(entityBB);
        }
        return this.collidingBoundingBoxes;
    }

    @NotNull
    public @NotNull List<@NotNull AABBdc> getCollidingSolidBlockBoundingBoxes(@Nullable Entity entity, @NotNull AABBdc aabb) {
        this.collidingBoundingBoxes.clear();
        int minX = MathHelper.floor(aabb.minX());
        int maxX = MathHelper.floor(aabb.maxX() + 1.0);
        int minY = MathHelper.floor(aabb.minY());
        int maxY = MathHelper.floor(aabb.maxY() + 1.0);
        int minZ = MathHelper.floor(aabb.minZ());
        int maxZ = MathHelper.floor(aabb.maxZ() + 1.0);
        TilePos tilePos = new TilePos(0, 0, 0);
        tilePos.x = minX - 1;
        while (tilePos.x <= maxX) {
            tilePos.z = minZ - 1;
            while (tilePos.z <= maxZ) {
                if (this.isBlockLoaded(tilePos.x, 64, tilePos.z)) {
                    tilePos.y = minY - 1;
                    while (tilePos.y <= maxY) {
                        Block<?> block = this.getBlock(tilePos);
                        if (block != null && block.isSolidRender() && (!(entity instanceof EntityItem) || block.id() != Blocks.MESH.id() && block.id() != Blocks.SPIKES.id() && block.id() != Blocks.MOBSPAWNER.id())) {
                            block.getCollisionAABBs(this, tilePos, aabb, this.collidingBoundingBoxes);
                        }
                        ++tilePos.y;
                    }
                }
                ++tilePos.z;
            }
            ++tilePos.x;
        }
        double d = 0.25;
        List<Entity> list = this.getEntitiesWithinAABBExcludingEntity(entity, MathHelper.aabbGrow(aabb, d, d, d, new AABBd()));
        for (int j2 = 0; j2 < list.size(); ++j2) {
            AABBdc collisionBB = list.get(j2).getCollisionAABB();
            if (collisionBB == null || !collisionBB.intersectsAABB((AABBd)aabb)) continue;
            this.collidingBoundingBoxes.add(collisionBB);
        }
        return this.collidingBoundingBoxes;
    }

    public float getAmbientBrightness(float partialTicks) {
        float angle = this.getCelestialAngle(partialTicks);
        float bright = 1.0f - (MathHelper.cos(angle * (float)Math.PI * 2.0f) * 2.0f + 0.2f);
        bright = 1.0f - MathHelper.clamp(bright, 0.0f, 1.0f);
        Weather weather = this.weatherManager.getCurrentWeather();
        if (weather != null) {
            float power;
            if (weather == Weathers.OVERWORLD_RAIN) {
                power = this.weatherManager.getWeatherIntensity() * this.weatherManager.getWeatherPower();
                bright = (float)((double)bright * (1.0 - (double)(power * 5.0f) / 16.0));
            }
            if (weather == Weathers.OVERWORLD_STORM) {
                power = this.weatherManager.getWeatherIntensity() * this.weatherManager.getWeatherPower();
                bright = (float)((double)bright * (1.0 - (double)(power * 5.0f) / 16.0));
                bright = (float)((double)bright * (1.0 - (double)(power * 5.0f) / 16.0));
            }
        }
        return bright * 0.8f + 0.2f;
    }

    public float getCelestialAngle(float partialTick) {
        if (!this.getGameRuleValue(GameRules.DO_DAY_CYCLE).booleanValue()) {
            partialTick = 1.0f;
        }
        return this.worldType.getCelestialAngle(this, this.levelData.getWorldTime(), partialTick);
    }

    public int findTopSolidBlock(int x, int z) {
        Chunk chunk = this.getChunkFromBlockCoords(x, z);
        x &= 0xF;
        z &= 0xF;
        for (int y = this.getHeightBlocks() - 1; y > 0; --y) {
            Material material;
            int id = chunk.getBlockID(x, y, z);
            Material material2 = material = id != 0 ? Blocks.blocksList[id].getMaterial() : Materials.AIR;
            if (!material.blocksMotion() && !material.isLiquid()) {
                continue;
            }
            return y + 1;
        }
        return -1;
    }

    public int findTopSolidNonLiquidBlock(int x, int z) {
        Chunk chunk = this.getChunkFromBlockCoords(x, z);
        x &= 0xF;
        z &= 0xF;
        for (int y = this.getHeightBlocks() - 1; y > 0; --y) {
            Material material;
            Block<?> block = Blocks.getBlock(chunk.getBlockID(x, y, z));
            Material material2 = material = block != null ? block.getMaterial() : Materials.AIR;
            if (!material.blocksMotion()) {
                continue;
            }
            return y + 1;
        }
        return -1;
    }

    public float getStarBrightness(float partialTick) {
        float f1 = this.getCelestialAngle(partialTick);
        float f2 = 1.0f - (MathHelper.cos(f1 * (float)Math.PI * 2.0f) * 2.0f + 0.75f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return f2 * f2;
    }

    @Deprecated
    public final void scheduleBlockUpdate(int x, int y, int z, int id, long delay) {
        this.scheduleBlockUpdate(new TilePos(x, y, z), id, delay);
    }

    public void scheduleBlockUpdate(@NotNull TilePosc tilePos, int id, long delay) {
        NextTickListEntry entry = new NextTickListEntry(tilePos, id);
        int radius = 8;
        if (this.scheduledUpdatesAreImmediate && !this.immediatelyUpdatedPositions.contains(entry)) {
            Block<?> block;
            if (this.areBlocksLoaded(entry.tilePos.x - 8, entry.tilePos.y - 8, entry.tilePos.z - 8, entry.tilePos.x() + 8, entry.tilePos.y() + 8, entry.tilePos.z() + 8) && (block = this.getBlock(entry.tilePos)) != null && block.id() == entry.blockId) {
                this.immediatelyUpdatedPositions.add(entry);
                block.updateTick(this, entry.tilePos, this.rand, false);
            }
            return;
        }
        if (this.areBlocksLoaded(tilePos, 8)) {
            if (id > 0) {
                entry.setDelay(delay + this.runtime);
            }
            if (!this.tickNextTickSet.contains(entry)) {
                this.tickNextTickSet.add(entry);
                this.tickNextTickList.add(entry);
            }
        }
    }

    public void updateEntities() {
        int i;
        for (i = 0; i < this.weatherEffects.size(); ++i) {
            Entity entity = this.weatherEffects.get(i);
            entity.tick();
            if (!entity.removed) continue;
            this.weatherEffects.remove(i--);
        }
        this.entities.removeAll(this.entitiesToRemove);
        for (int j = 0; j < this.entitiesToRemove.size(); ++j) {
            Entity entity1 = this.entitiesToRemove.get(j);
            int i1 = entity1.chunkCoordX;
            int k1 = entity1.chunkCoordZ;
            if (!entity1.addedToChunk || !this.isChunkLoaded(i1, k1)) continue;
            this.getChunkFromChunkCoords(i1, k1).removeEntity(entity1);
        }
        for (int k = 0; k < this.entitiesToRemove.size(); ++k) {
            this.releaseEntitySkin(this.entitiesToRemove.get(k));
        }
        this.entitiesToRemove.clear();
        for (int l = 0; l < this.entities.size(); ++l) {
            Entity entity2 = this.entities.get(l);
            if (entity2.vehicle != null) {
                if (!entity2.vehicle.isRemoved() && entity2.vehicle.getPassenger() == entity2) continue;
                entity2.vehicle.setPassenger(null);
                entity2.vehicle = null;
            }
            if (!entity2.removed) {
                this.updateEntity(entity2);
            }
            if (!entity2.removed) continue;
            int j1 = entity2.chunkCoordX;
            int l1 = entity2.chunkCoordZ;
            if (entity2.addedToChunk && this.isChunkLoaded(j1, l1)) {
                this.getChunkFromChunkCoords(j1, l1).removeEntity(entity2);
            }
            this.entities.remove(l--);
            this.releaseEntitySkin(entity2);
        }
        this.updatingTileEntities = true;
        for (i = this.tileEntityList.size() - 1; i >= 0; --i) {
            TileEntity tileEntity = this.tileEntityList.get(i);
            if (!tileEntity.isInvalid() && this.isBlockLoaded(tileEntity.x, tileEntity.y, tileEntity.z)) {
                tileEntity.tick();
            }
            if (!tileEntity.isInvalid()) continue;
            this.tileEntityList.remove(i);
            Chunk chunk = this.getChunkFromChunkCoords(Math.floorDiv(tileEntity.x, 16), Math.floorDiv(tileEntity.z, 16));
            if (chunk == null) continue;
            chunk.removeTileEntity(tileEntity);
        }
        this.updatingTileEntities = false;
    }

    public void addAllBlockEntities(Collection<TileEntity> blockEntities) {
        this.tileEntityList.addAll(blockEntities);
    }

    public void updateEntity(Entity entity) {
        this.updateEntityWithOptionalForce(entity, true);
    }

    public void updateEntityWithOptionalForce(Entity entity, boolean flag) {
        int i = MathHelper.floor(entity.x);
        int j = MathHelper.floor(entity.z);
        int byte0 = 32;
        if (flag && !this.areBlocksLoaded(i - byte0, 0, j - byte0, i + byte0, this.getHeightBlocks() - 1, j + byte0)) {
            if (entity instanceof Mob) {
                ((Mob)entity).tryToDespawn();
            }
            return;
        }
        entity.xo = entity.x;
        entity.yo = entity.y;
        entity.zo = entity.z;
        entity.yRotO = entity.yRot;
        entity.xRotO = entity.xRot;
        if (flag && entity.addedToChunk) {
            if (entity.vehicle != null) {
                entity.rideTick();
            } else {
                entity.tick();
            }
        }
        if (Double.isNaN(entity.x) || Double.isInfinite(entity.x)) {
            entity.x = entity.xo;
        }
        if (Double.isNaN(entity.y) || Double.isInfinite(entity.y)) {
            entity.y = entity.yo;
        }
        if (Double.isNaN(entity.z) || Double.isInfinite(entity.z)) {
            entity.z = entity.zo;
        }
        if (Double.isNaN(entity.xRot) || Double.isInfinite(entity.xRot)) {
            entity.xRot = entity.xRotO;
        }
        if (Double.isNaN(entity.yRot) || Double.isInfinite(entity.yRot)) {
            entity.yRot = entity.yRotO;
        }
        int k = MathHelper.floor(entity.x / 16.0);
        int l = MathHelper.floor(entity.y / 16.0);
        int i1 = MathHelper.floor(entity.z / 16.0);
        if (!entity.addedToChunk || entity.chunkCoordX != k || entity.chunkCoordY != l || entity.chunkCoordZ != i1) {
            if (entity.addedToChunk && this.isChunkLoaded(entity.chunkCoordX, entity.chunkCoordZ)) {
                this.getChunkFromChunkCoords(entity.chunkCoordX, entity.chunkCoordZ).removeEntityAtIndex(entity, entity.chunkCoordY);
            }
            if (this.isChunkLoaded(k, i1)) {
                entity.addedToChunk = true;
                this.getChunkFromChunkCoords(k, i1).addEntity(entity);
            } else {
                entity.addedToChunk = false;
            }
        }
        if (flag && entity.addedToChunk && entity.passenger != null) {
            if (entity.passenger.removed || entity.passenger.vehicle != entity) {
                entity.passenger.vehicle = null;
                entity.passenger = null;
            } else {
                this.updateEntity(entity.passenger);
            }
        }
    }

    public boolean checkIfAABBIsClear(@NotNull AABBdc aabb) {
        List<Entity> list = this.getEntitiesWithinAABBExcludingEntity(null, aabb);
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = list.get(i);
            if (entity instanceof MobFireflyCluster || entity.removed || !entity.blocksBuilding) continue;
            return false;
        }
        return true;
    }

    public boolean getIsAnySolidGround(@NotNull AABBdc aabb) {
        int minX = MathHelper.floor(aabb.minX());
        int maxX = MathHelper.floor(aabb.maxX());
        int minY = MathHelper.floor(aabb.minY());
        int maxY = MathHelper.floor(aabb.maxY());
        int minZ = MathHelper.floor(aabb.minZ());
        int maxZ = MathHelper.floor(aabb.maxZ());
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    Block<?> block = Blocks.blocksList[this.getBlockId(x, y, z)];
                    if (block == null) continue;
                    return true;
                }
            }
        }
        List<Entity> entities = this.getEntitiesWithinAABBExcludingEntity(null, aabb);
        for (Entity entity : entities) {
            AABBdc collisionAABB = entity.getCollisionAABB();
            if (collisionAABB == null || !collisionAABB.intersectsAABB((AABBd)aabb)) continue;
            this.collidingBoundingBoxes.add(collisionAABB);
        }
        return false;
    }

    public boolean getIsAnyLiquid(@NotNull AABBdc aabb) {
        int minX = MathHelper.floor(aabb.minX());
        int maxX = MathHelper.floor(aabb.maxX());
        int minY = MathHelper.floor(aabb.minY());
        int maxY = MathHelper.floor(aabb.maxY());
        int minZ = MathHelper.floor(aabb.minZ());
        int maxZ = MathHelper.floor(aabb.maxZ());
        TilePos tilePos = new TilePos(0, 0, 0);
        tilePos.x = minX;
        while (tilePos.x <= maxX) {
            tilePos.y = minY;
            while (tilePos.y <= maxY) {
                tilePos.z = minZ;
                while (tilePos.z <= maxZ) {
                    Block<?> block = this.getBlock(tilePos);
                    if (block != null && block.getMaterial().isLiquid()) {
                        return true;
                    }
                    ++tilePos.z;
                }
                ++tilePos.y;
            }
            ++tilePos.x;
        }
        return false;
    }

    public boolean isBoundingBoxBurning(@NotNull AABBdc aabb) {
        return this.isMaterialInBB(aabb, Materials.FIRE, Materials.LAVA);
    }

    public boolean handleMaterialAcceleration(@NotNull AABBdc aabb, @NotNull Material material, @NotNull Entity entity, boolean addVelocity) {
        int maxZ;
        int minX = MathHelper.floor(aabb.minX());
        int maxX = MathHelper.floor(aabb.maxX() + 1.0);
        int minY = MathHelper.floor(aabb.minY());
        int maxY = MathHelper.floor(aabb.maxY() + 1.0);
        int minZ = MathHelper.floor(aabb.minZ());
        if (!this.areBlocksLoaded(minX, minY, minZ, maxX, maxY, maxZ = MathHelper.floor(aabb.maxZ() + 1.0))) {
            return false;
        }
        boolean flag = false;
        TilePos tilePos = new TilePos(0, 0, 0);
        Vector3d velDir = new Vector3d();
        tilePos.x = minX;
        while (tilePos.x < maxX) {
            tilePos.y = minY;
            while (tilePos.y < maxY) {
                tilePos.z = minZ;
                while (tilePos.z < maxZ) {
                    Block<?> block = this.getBlock(tilePos);
                    if (block != null && this.isMaterialInBB(aabb, material)) {
                        flag = true;
                        block.onEntityInside(this, tilePos, entity, velDir);
                    }
                    ++tilePos.z;
                }
                ++tilePos.y;
            }
            ++tilePos.x;
        }
        if (velDir.length() > 0.0 && addVelocity) {
            velDir.normalize();
            double d = 0.014;
            entity.xd += velDir.x * d;
            entity.yd += velDir.y * d;
            entity.zd += velDir.z * d;
        }
        return flag;
    }

    public boolean isMaterialInBB(@NotNull AABBdc aabb, Material ... materials) {
        int minX_i = MathHelper.floor(aabb.minX());
        int maxX_i = MathHelper.floor(aabb.maxX() + 1.0);
        int minY_i = MathHelper.floor(aabb.minY());
        int maxY_i = MathHelper.floor(aabb.maxY() + 1.0);
        int minZ_i = MathHelper.floor(aabb.minZ());
        int maxZ_i = MathHelper.floor(aabb.maxZ() + 1.0);
        TilePos tilePos = new TilePos(0, 0, 0);
        tilePos.x = minX_i;
        while (tilePos.x < maxX_i) {
            tilePos.y = minY_i;
            while (tilePos.y < maxY_i) {
                tilePos.z = minZ_i;
                while (tilePos.z < maxZ_i) {
                    Block<?> block = this.getBlock(tilePos);
                    if (block != null) {
                        boolean isMaterial = false;
                        for (Material m : materials) {
                            if (block.getMaterial() != m) continue;
                            isMaterial = true;
                            break;
                        }
                        if (isMaterial && aabb.intersectsAABB(block.getBoundsFromState(this, tilePos).translate(tilePos.x, tilePos.y, tilePos.z, new AABBd()))) {
                            return true;
                        }
                    }
                    ++tilePos.z;
                }
                ++tilePos.y;
            }
            ++tilePos.x;
        }
        return false;
    }

    public boolean isMaterialInBB(@NotNull AABBdc aabb, @NotNull Material material) {
        int minX_i = MathHelper.floor(aabb.minX());
        int maxX_i = MathHelper.floor(aabb.maxX() + 1.0);
        int minY_i = MathHelper.floor(aabb.minY());
        int maxY_i = MathHelper.floor(aabb.maxY() + 1.0);
        int minZ_i = MathHelper.floor(aabb.minZ());
        int maxZ_i = MathHelper.floor(aabb.maxZ() + 1.0);
        TilePos tilePos = new TilePos(0, 0, 0);
        tilePos.x = minX_i;
        while (tilePos.x < maxX_i) {
            tilePos.y = minY_i;
            while (tilePos.y < maxY_i) {
                tilePos.z = minZ_i;
                while (tilePos.z < maxZ_i) {
                    Block<?> block = this.getBlock(tilePos);
                    if (block != null && block.getMaterial() == material && aabb.intersectsAABB(block.getBoundsFromState(this, tilePos).translate(tilePos.x, tilePos.y, tilePos.z, new AABBd()))) {
                        return true;
                    }
                    ++tilePos.z;
                }
                ++tilePos.y;
            }
            ++tilePos.x;
        }
        return false;
    }

    public boolean isAABBInMaterial(@NotNull AABBdc aabb, @NotNull Material material) {
        int minX = MathHelper.floor(aabb.minX());
        int maxX = MathHelper.floor(aabb.maxX() + 1.0);
        int minY = MathHelper.floor(aabb.minY());
        int maxY = MathHelper.floor(aabb.maxY() + 1.0);
        int minZ = MathHelper.floor(aabb.minZ());
        int maxZ = MathHelper.floor(aabb.maxZ() + 1.0);
        TilePos tilePos = new TilePos(0, 0, 0);
        tilePos.x = minX;
        while (tilePos.x < maxX) {
            tilePos.y = minY;
            while (tilePos.y < maxY) {
                tilePos.z = minZ;
                while (tilePos.z < maxZ) {
                    Block<?> block = this.getBlock(tilePos);
                    if (block != null && block.getMaterial() == material) {
                        int j2 = this.getBlockData(tilePos);
                        double d = tilePos.y + 1;
                        if (j2 < 8) {
                            d = (double)(tilePos.y + 1) - (double)j2 / 8.0;
                        }
                        if (d >= aabb.minY()) {
                            return true;
                        }
                    }
                    ++tilePos.z;
                }
                ++tilePos.y;
            }
            ++tilePos.x;
        }
        return false;
    }

    public Explosion createExplosion(Entity entity, double x, double y, double z, float explosionSize) {
        return this.createExplosion(entity, x, y, z, explosionSize, false, false);
    }

    public Explosion createExplosion(Entity entity, double x, double y, double z, float explosionSize, boolean flaming, boolean isCannonBall) {
        Explosion explosion = !isCannonBall ? new Explosion(this, entity, x, y, z, explosionSize) : new ExplosionCannonball(this, entity, x, y, z, explosionSize);
        explosion.isFlaming = flaming;
        explosion.explode();
        explosion.addEffects(true);
        return explosion;
    }

    public float getSeenPercent(@NotNull Vector3dc eyePos, @NotNull AABBdc aabb) {
        double d = 1.0 / ((aabb.maxX() - aabb.minX()) * 2.0 + 1.0);
        double d1 = 1.0 / ((aabb.maxY() - aabb.minY()) * 2.0 + 1.0);
        double d2 = 1.0 / ((aabb.maxZ() - aabb.minZ()) * 2.0 + 1.0);
        int i = 0;
        int j = 0;
        Vector3d entCheckPos = new Vector3d();
        float f = 0.0f;
        while (f <= 1.0f) {
            float f1 = 0.0f;
            while (f1 <= 1.0f) {
                float f2 = 0.0f;
                while (f2 <= 1.0f) {
                    double z;
                    double y;
                    double x = aabb.minX() + (aabb.maxX() - aabb.minX()) * (double)f;
                    if (this.checkBlockCollisionBetweenPoints(eyePos, entCheckPos.set(x, y = aabb.minY() + (aabb.maxY() - aabb.minY()) * (double)f1, z = aabb.minZ() + (aabb.maxZ() - aabb.minZ()) * (double)f2)) == null) {
                        ++i;
                    }
                    ++j;
                    f2 = (float)((double)f2 + d2);
                }
                f1 = (float)((double)f1 + d1);
            }
            f = (float)((double)f + d);
        }
        return (float)i / (float)j;
    }

    public void onBlockHit(@NotNull Player player, @NotNull TilePos tilePos, @NotNull Side side) {
        @NotNull TilePos offsetPos = tilePos.add(side.getDirection(), new TilePos());
        @Nullable Block<?> block = this.getBlock(offsetPos);
        if (block == Blocks.FIRE || block == Blocks.FIRE_COLD) {
            this.playBlockEvent(player, offsetPos, 1004, 0);
            this.setBlockIdNotify(tilePos, 0);
        }
    }

    @Deprecated
    public final void onBlockHit(@NotNull Player player, int x, int y, int z, @NotNull Side side) {
        this.onBlockHit(player, new TilePos(x, y, z), side);
    }

    @Nullable
    public Entity getEntityByID(int id) {
        for (int i = 0; i < this.entities.size(); ++i) {
            Entity entity = this.entities.get(i);
            if (entity.id != id) continue;
            return entity;
        }
        return null;
    }

    public String getNumLoadedEntitiesString() {
        return "All: " + this.entities.size();
    }

    public String getChunkProviderInfoString() {
        return this.chunkProvider.getInfoString();
    }

    @Override
    @Nullable
    public TileEntity getTileEntity(@NotNull TilePosc tilePos) {
        @NotNull Chunk chunk = this.getChunk(tilePos);
        return chunk.getTileEntity(new ChunkTilePos(tilePos));
    }

    @Override
    public void setTileEntity(@NotNull TilePosc tilePos, @NotNull TileEntity tileEntity) {
        if (!tileEntity.isInvalid() && this.getChunk(tilePos).setTileEntity(new ChunkTilePos(tilePos), tileEntity) && !this.tileEntityList.contains(tileEntity)) {
            this.tileEntityList.add(tileEntity);
        }
    }

    @Override
    public void removeTileEntity(@NotNull TilePosc tilePos) {
        @Nullable TileEntity tileEntity = this.getTileEntity(tilePos);
        if (tileEntity != null && this.updatingTileEntities) {
            tileEntity.invalidate();
        } else {
            if (tileEntity != null) {
                this.tileEntityList.remove(tileEntity);
            }
            this.getChunk(tilePos).removeTileEntity(tileEntity);
        }
    }

    @Override
    public boolean isBlockOpaqueCube(@NotNull TilePosc tilePos) {
        @Nullable Block<?> block = this.getBlock(tilePos);
        return block != null && block.isSolidRender();
    }

    public boolean canPlaceOnSurfaceOfBlock(@NotNull TilePos tilePos) {
        @Nullable Block<?> block = this.getBlock(tilePos);
        return block != null && block.canPlaceOnSurfaceOnCondition(this, tilePos.x, tilePos.y, tilePos.z);
    }

    @Deprecated
    public final boolean canPlaceOnSurfaceOfBlock(int x, int y, int z) {
        return this.canPlaceOnSurfaceOfBlock(new TilePos(x, y, z));
    }

    @NotNull
    public ISupport getSupport(@NotNull TilePos tilePos, @NotNull Side side) {
        @Nullable Block<?> block = this.getBlock(tilePos);
        if (block == null) {
            return PartialSupport.INSTANCE;
        }
        return block.getSupport(this, tilePos.x, tilePos.y, tilePos.z, side);
    }

    @Deprecated
    @NotNull
    public final ISupport getSupport(int x, int y, int z, @NotNull Side side) {
        return this.getSupport(new TilePos(x, y, z), side);
    }

    @Override
    public boolean isBlockNormalCube(@NotNull TilePosc tilePos) {
        @Nullable Block<?> block = this.getBlock(tilePos);
        return block != null && block.getMaterial().isSolidBlocking() && block.renderAsNormalBlockOnCondition(this, tilePos);
    }

    public boolean canPlaceInsideBlock(@NotNull TilePosc tilePos) {
        @Nullable Block<?> block = this.getBlock(tilePos);
        return block == null || block.hasTag(BlockTags.PLACE_OVERWRITES);
    }

    @Deprecated
    public final boolean canPlaceInsideBlock(int x, int y, int z) {
        return this.canPlaceInsideBlock(new TilePos(x, y, z));
    }

    public void onUnload() {
        try {
            this.updateEntities();
        }
        catch (Throwable t) {
            LOGGER.error("Unhandled exception while unloading all entities!", t);
            throw t;
        }
        finally {
            this.entities.clear();
            this.entitiesToRemove.clear();
        }
    }

    public void close() {
        this.chunkProvider.close();
    }

    public void saveWorldIndirectly(ProgressListener iprogressupdate) {
        this.saveWorld(true, iprogressupdate, true);
    }

    public boolean updatingLighting() {
        return this.lightingEngine.updatingLighting();
    }

    public void scheduleLightingUpdate(@NotNull LightLayer lightLayer, @NotNull TilePos tilePos) {
        this.scheduleLightingUpdate(lightLayer, tilePos, tilePos);
    }

    public void scheduleLightingUpdate(@NotNull LightLayer lightLayer, @NotNull TilePos min, @NotNull TilePos max) {
        this.lightingEngine.scheduleLightingUpdate(lightLayer, Math.min(min.x, max.x), Math.min(min.y, max.y), Math.min(min.z, max.z), Math.max(min.x, max.x), Math.max(min.y, max.y), Math.max(min.z, max.z));
    }

    public LightingEngine getLightingEngine() {
        return this.lightingEngine;
    }

    @Deprecated
    public final void scheduleLightingUpdate(@NotNull LightLayer lightLayer, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.scheduleLightingUpdate(lightLayer, new TilePos(minX, minY, minZ), new TilePos(maxX, maxY, maxZ));
    }

    public void updateSkyBrightness() {
        int i = this.worldType.getSkyDarken(this, this.getWorldTime(), 1.0f);
        if (i != this.skyDarken) {
            this.skyDarken = i;
        }
    }

    public void allChanged(boolean lightChanged, boolean seasonChanged) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).allChanged(lightChanged, seasonChanged);
        }
    }

    protected void updateSleepingPlayers() {
        if (this.areEnoughPlayersFullyAsleep()) {
            boolean wasInterrupted = false;
            if (this.getSpawnerConfig().canHostileSpawn(this) && this.getPlayersRequiredToSkipNight() <= 1) {
                wasInterrupted = SpawnerMobs.performSleepSpawning(this, this.players);
            }
            if (!wasInterrupted) {
                long timePlusOneDay = this.levelData.getWorldTime() + 24000L;
                this.levelData.setWorldTime(timePlusOneDay - timePlusOneDay % 24000L + (long)this.worldType.getSunriseTick(this) + 1000L);
                this.wakeUpAllPlayers();
            }
        }
    }

    public void tick() {
        Debug.push("misc");
        this.immediatelyUpdatedPositions.clear();
        Debug.change("weather");
        this.weatherManager.tick();
        Debug.change("misc");
        this.updateSleepingPlayers();
        Debug.change("spawning");
        SpawnerMobs.performSpawning(this, this.getSpawnerConfig());
        Debug.change("chunk");
        this.chunkProvider.tick();
        Debug.change("autosave");
        int autosaveTimeInSeconds = Global.accessor.getAutosaveTimer();
        int autosaveTimeInTicks = autosaveTimeInSeconds * 20;
        boolean bl = AUTOSAVE = autosaveTimeInTicks != 0;
        if (AUTOSAVE && this.runtime % (long)autosaveTimeInTicks == 0L) {
            this.saveWorld(false, null, true);
        }
        Debug.change("misc");
        if (this.getGameRuleValue(GameRules.DO_DAY_CYCLE).booleanValue()) {
            this.levelData.setWorldTime(this.levelData.getWorldTime() + 1L);
        }
        ++this.runtime;
        this.tickPendingTicks(false);
        Debug.change("blocks&cavesSounds");
        this.updateBlocksAndPlayCaveSounds();
        Debug.change("season&light");
        this.updateSeasonAndLight();
        if (this.rainbowTicks > 0) {
            --this.rainbowTicks;
        }
        Debug.pop();
    }

    public void updateSeasonAndLight() {
        int currentSkyDarken;
        boolean seasonChanged = false;
        boolean lightChanged = false;
        int currentDayCount = (int)(this.levelData.getWorldTime() / 24000L);
        if (currentDayCount != this.dayCountLastTick) {
            this.dayCountLastTick = currentDayCount;
            this.dayCanHaveRainbow = !this.isClientSide ? this.rand.nextInt(3) == 0 : true;
            seasonChanged = true;
        }
        if ((currentSkyDarken = this.worldType.getSkyDarken(this, this.getWorldTime(), 1.0f)) != this.skyDarken) {
            this.skyDarken = currentSkyDarken;
            lightChanged = true;
        }
        if (seasonChanged || lightChanged) {
            this.allChanged(lightChanged, seasonChanged);
        }
    }

    protected void updateBlocksAndPlayCaveSounds() {
        this.positionsToUpdate.clear();
        for (int i = 0; i < this.players.size(); ++i) {
            Player entityplayer = this.players.get(i);
            int playerChunkX = MathHelper.floor(entityplayer.x / 16.0);
            int playerChunkZ = MathHelper.floor(entityplayer.z / 16.0);
            int radius = 9;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    this.positionsToUpdate.add(new ChunkCoordinate(x + playerChunkX, z + playerChunkZ));
                }
            }
        }
        if (this.caveSoundCounter > 0) {
            --this.caveSoundCounter;
        }
        int randomTicks = this.getGameRuleValue(GameRules.RANDOM_TICK_SPEED);
        for (ChunkCoordinate coordinate : this.positionsToUpdate) {
            Player closestPlayer;
            int blockY;
            int id;
            int chunkBlockX = coordinate.x * 16;
            int chunkBlockZ = coordinate.z * 16;
            if (!this.isChunkLoaded(coordinate.x, coordinate.z)) continue;
            Chunk chunk = this.getChunkFromChunkCoords(coordinate.x, coordinate.z);
            this.updateLCG = this.updateLCG * 3 + 1013904223;
            int randVal = this.updateLCG >> 2;
            int blockX = randVal & 0xF;
            int blockZ = randVal / 256 & 0xF;
            if (this.caveSoundCounter == 0 && (id = chunk.getBlockID(blockX, blockY = randVal / 65536 & 0xFF, blockZ)) == 0 && this.getFullBlockLightValue(blockX += chunkBlockX, blockY, blockZ += chunkBlockZ) <= this.rand.nextInt(8) && this.getSavedLightValue(LightLayer.Sky, blockX, blockY, blockZ) <= 0 && (closestPlayer = this.getClosestPlayer((double)blockX + 0.5, (double)blockY + 0.5, (double)blockZ + 0.5, 8.0)) != null && closestPlayer.distanceToSqr((double)blockX + 0.5, (double)blockY + 0.5, (double)blockZ + 0.5) > 4.0) {
                this.playSoundEffect(null, SoundCategory.CAVE_SOUNDS, (double)blockX + 0.5, (double)blockY + 0.5, (double)blockZ + 0.5, "ambient.cave.cave", 0.7f, 0.8f + this.rand.nextFloat() * 0.2f);
                this.caveSoundCounter = this.rand.nextInt(12000) + 6000;
            }
            if (this.getCurrentWeather() != null) {
                this.updateLCG = this.updateLCG * 3 + 1013904223;
                randVal = this.updateLCG >> 2;
                int weatherBlockX = randVal & 0xF;
                int weatherBlockZ = randVal / 256 & 0xF;
                this.getCurrentWeather().doEnvironmentUpdate(this, this.rand, chunkBlockX + weatherBlockX, chunkBlockZ + weatherBlockZ);
            }
            for (int s = 0; s < 16; ++s) {
                for (int i = 0; i < randomTicks; ++i) {
                    this.updateLCG = this.updateLCG * 3 + 1013904223;
                    int iRandVal = this.updateLCG >> 2;
                    int iBlockX = iRandVal & 0xF;
                    int iBlockY = iRandVal / 4096 & 15 + s * 16;
                    int iBlockZ = iRandVal / 256 & 0xF;
                    int id2 = chunk.getBlockID(iBlockX, iBlockY, iBlockZ);
                    if (!Blocks.shouldTick[id2]) continue;
                    Blocks.blocksList[id2].updateTick(this, iBlockX + chunkBlockX, iBlockY, iBlockZ + chunkBlockZ, this.rand, true);
                }
            }
        }
    }

    public boolean tickPendingTicks(boolean all) {
        int count = this.tickNextTickList.size();
        if (count != this.tickNextTickSet.size()) {
            throw new IllegalStateException("TickNextTick lists out of sync");
        }
        if (count > 1000) {
            count = 1000;
        }
        for (int i = 0; i < count; ++i) {
            Block<?> block;
            @NotNull NextTickListEntry entry = this.tickNextTickList.first();
            if (!all && entry.delay > this.runtime) break;
            this.tickNextTickList.remove(entry);
            this.tickNextTickSet.remove(entry);
            int radius = 8;
            if (!this.areBlocksLoaded(entry.tilePos.x - 8, entry.tilePos.y - 8, entry.tilePos.z - 8, entry.tilePos.x + 8, entry.tilePos.y + 8, entry.tilePos.z + 8) || (block = this.getBlock(entry.tilePos)) == null || block.id() != entry.blockId) continue;
            block.updateTick(this, entry.tilePos, this.rand, false);
        }
        return !this.tickNextTickList.isEmpty();
    }

    public void randomDisplayUpdates(@NotNull TilePos tilePos) {
        int radius = 16;
        @NotNull Random random = new Random();
        TilePos randomPos = new TilePos();
        for (int i = 0; i < 1000; ++i) {
            tilePos.add(this.rand.nextInt(16) - this.rand.nextInt(16), this.rand.nextInt(16) - this.rand.nextInt(16), this.rand.nextInt(16) - this.rand.nextInt(16), randomPos);
            @Nullable Block<?> block = this.getBlock(randomPos);
            if (block == null) continue;
            block.animationTick(this, randomPos, random);
        }
    }

    @Deprecated
    public final void randomDisplayUpdates(int x, int y, int z) {
        this.randomDisplayUpdates(new TilePos(x, y, z));
    }

    @NotNull
    public @NotNull List<@NotNull Entity> getEntitiesWithinAABBExcludingEntity(@Nullable Entity entity, @NotNull AABBdc aabb) {
        this.entityBuffer.clear();
        int minX = MathHelper.floor((aabb.minX() - 2.0) / 16.0);
        int maxX = MathHelper.floor((aabb.maxX() + 2.0) / 16.0);
        int minZ = MathHelper.floor((aabb.minZ() - 2.0) / 16.0);
        int maxZ = MathHelper.floor((aabb.maxZ() + 2.0) / 16.0);
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                if (!this.isChunkLoaded(x, z)) continue;
                this.getChunkFromChunkCoords(x, z).getEntitiesWithin(entity, aabb, this.entityBuffer);
            }
        }
        return this.entityBuffer;
    }

    @NotNull
    public <T extends Entity> @NotNull List<@NotNull T> getEntitiesWithinAABB(@NotNull Class<T> ofClass, @NotNull AABBdc aabb) {
        int minX = MathHelper.floor((aabb.minX() - 2.0) / 16.0);
        int maxX = MathHelper.floor((aabb.maxX() + 2.0) / 16.0);
        int minZ = MathHelper.floor((aabb.minZ() - 2.0) / 16.0);
        int maxZ = MathHelper.floor((aabb.maxZ() + 2.0) / 16.0);
        ArrayList<@NotNull E> entities = new ArrayList();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                if (!this.isChunkLoaded(x, z)) continue;
                this.getChunkFromChunkCoords(x, z).getEntitiesWithin(ofClass, aabb, entities);
            }
        }
        return entities;
    }

    @NotNull
    public @NotNull List<@NotNull Entity> getLoadedEntityList() {
        return this.entities;
    }

    @NotNull
    public @NotNull List<@NotNull TileEntity> getLoadedTileEntityList() {
        return this.tileEntityList;
    }

    public void updateTileEntityChunkAndSendToPlayer(@NotNull TilePos tilePos, @NotNull TileEntity tileEntity) {
        if (this.isBlockLoaded(tilePos)) {
            this.getChunk(tilePos).setChunkModified();
        }
        for (LevelListener listener : this.listeners) {
            listener.tileEntityChanged(tilePos.x, tilePos.y, tilePos.z, tileEntity);
        }
    }

    @Deprecated
    public final void updateTileEntityChunkAndSendToPlayer(int x, int y, int z, @NotNull TileEntity tileEntity) {
        this.updateTileEntityChunkAndSendToPlayer(new TilePos(x, y, z), tileEntity);
    }

    public int countEntities(Class<?> clazz) {
        int i = 0;
        int entitiesSize = this.entities.size();
        for (int j = 0; j < entitiesSize; ++j) {
            Entity entity = this.entities.get(j);
            if (!clazz.isAssignableFrom(entity.getClass())) continue;
            ++i;
        }
        return i;
    }

    public void addLoadedEntities(List<Entity> list) {
        this.entities.addAll(list);
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            Entity entity = list.get(i);
            this.obtainEntitySkin(entity);
        }
    }

    public void unloadEntities(List<Entity> list) {
        this.entitiesToRemove.addAll(list);
    }

    public void dropOldChunks() {
        while (this.chunkProvider.tick()) {
        }
    }

    public boolean canBlockIdBePlacedAt(int id, @NotNull TilePosc tilePos, boolean ignoreCollision, @NotNull Side side) {
        if (tilePos.y() < 0 || tilePos.y() >= this.getHeightBlocks()) {
            return false;
        }
        @Nullable Block<?> currentBlock = this.getBlock(tilePos);
        Block<?> newBlock = Blocks.blocksList[id];
        if (newBlock == null) {
            return false;
        }
        AABBdc bb = ignoreCollision ? null : newBlock.getCollisionAABB(this, tilePos);
        if (bb != null && !this.checkIfAABBIsClear(bb)) {
            return false;
        }
        if (currentBlock == null || currentBlock.hasTag(BlockTags.PLACE_OVERWRITES)) {
            return newBlock.canPlaceOnSide(this, tilePos, side);
        }
        return false;
    }

    @Deprecated
    public final boolean canBlockBePlacedAt(int id, int x, int y, int z, boolean ignoreCollision, @NotNull Side side) {
        return this.canBlockIdBePlacedAt(id, new TilePos(x, y, z), ignoreCollision, side);
    }

    @Nullable
    public Path getPathToEntity(Entity entity, Entity entityToTravelTo, float distance) {
        int x1 = MathHelper.floor(entity.x);
        int y2 = MathHelper.floor(entity.y);
        int z1 = MathHelper.floor(entity.z);
        int radius = (int)(distance + 16.0f);
        int xMin = x1 - radius;
        int yMin = y2 - radius;
        int zMin = z1 - radius;
        int xMax = x1 + radius;
        int yMax = y2 + radius;
        int zMax = z1 + radius;
        ChunkCache chunkcache = new ChunkCache(this, xMin, yMin, zMin, xMax, yMax, zMax);
        return new PathFinder(chunkcache).findPath(entity, entityToTravelTo, distance);
    }

    @Nullable
    public Path getEntityPathToTilePos(@NotNull Entity entity, @NotNull TilePos tilePos, float distance) {
        TilePos cacheMax;
        @NotNull TilePos entityPos = new TilePos(entity);
        int cacheRadius = (int)(distance + 8.0f);
        @NotNull TilePos cacheMin = entityPos.sub(cacheRadius, cacheRadius, cacheRadius, new TilePos());
        @NotNull ChunkCache cache = new ChunkCache(this, cacheMin, cacheMax = entityPos.add(cacheRadius, cacheRadius, cacheRadius, new TilePos()), false);
        if (!cache.allLoaded()) {
            return null;
        }
        return new PathFinder(cache).findPath(entity, tilePos.x, tilePos.y, tilePos.z, distance);
    }

    @Deprecated
    @Nullable
    public final Path getEntityPathToXYZ(@NotNull Entity entity, int x, int y, int z, float distance) {
        return this.getEntityPathToTilePos(entity, new TilePos(x, y, z), distance);
    }

    public boolean hasDirectSignal(@NotNull TilePosc tilePos, @NotNull Side side) {
        @Nullable Block<?> block = this.getBlock(tilePos);
        return block != null && block.isEmittingDirectSignal(this, tilePos, side);
    }

    @Deprecated
    public final boolean getDirectSignal(int x, int y, int z, @NotNull Side side) {
        return this.hasDirectSignal(new TilePos(x, y, z), side);
    }

    public boolean hasDirectSignal(@NotNull TilePosc tilePos) {
        TilePos queryPos = new TilePos();
        for (Side side : Side.sides) {
            if (!this.hasDirectSignal(tilePos.add(side.getDirection(), queryPos), side)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public final boolean hasDirectSignal(int x, int y, int z) {
        return this.hasDirectSignal(new TilePos(x, y, z));
    }

    public boolean hasSignal(@NotNull TilePosc tilePos, @NotNull Side side) {
        @Nullable Block<?> block = this.getBlock(tilePos);
        if (this.isBlockNormalCube(tilePos) && block != Blocks.BLOCK_REDSTONE && block != Blocks.PUMPKIN_REDSTONE && block != Blocks.MATCHER_ACTIVE) {
            return this.hasDirectSignal(tilePos);
        }
        if (block == null) {
            return false;
        }
        if (block == Blocks.PUMPKIN_REDSTONE) {
            return this.pumpkinHasDirectSignal(tilePos) || block.isEmittingSignal(this, tilePos, side);
        }
        return block.isEmittingSignal(this, tilePos, side);
    }

    @Deprecated
    public final boolean getSignal(int x, int y, int z, @NotNull Side side) {
        return this.hasSignal(new TilePos(x, y, z), side);
    }

    private boolean pumpkinHasDirectSignal(@NotNull TilePosc tilePos) {
        for (Side side : Side.sides) {
            if (Side.getSideById(this.getBlockData(tilePos)) == side || !this.hasDirectSignal(tilePos.add(side.getDirection(), new TilePos()), side)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNeighborSignal(@NotNull TilePosc tilePos) {
        for (Side side : Side.sides) {
            if (!this.hasSignal(tilePos.add(side.getDirection(), new TilePos()), side)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public final boolean hasNeighborSignal(int x, int y, int z) {
        return this.hasNeighborSignal(new TilePos(x, y, z));
    }

    public Player getClosestPlayerToEntity(Entity entity, double radius) {
        return this.getClosestPlayer(entity.x, entity.y, entity.z, radius);
    }

    public Player getClosestPlayer(double x, double y, double z, double radius) {
        double closestDistance = Double.POSITIVE_INFINITY;
        Player entityplayer = null;
        if (radius < 0.0) {
            for (Player entityPlayer1 : this.players) {
                double currentDistance = entityPlayer1.distanceToSqr(x, y, z);
                if (!(currentDistance < closestDistance)) continue;
                closestDistance = currentDistance;
                entityplayer = entityPlayer1;
            }
        } else {
            double rSquared = radius * radius;
            for (Player entityPlayer1 : this.players) {
                double currentDistance = entityPlayer1.distanceToSqr(x, y, z);
                if (!(currentDistance < rSquared) || !(currentDistance < closestDistance)) continue;
                closestDistance = currentDistance;
                entityplayer = entityPlayer1;
            }
        }
        return entityplayer;
    }

    public Player getPlayerEntityByName(String s) {
        for (Player player : this.players) {
            if (!s.equals(player.username)) continue;
            return player;
        }
        return null;
    }

    public Player getPlayerEntityByUUID(@Nullable UUID uuid) {
        for (Player player : this.players) {
            if (!player.uuid.equals(uuid)) continue;
            return player;
        }
        return null;
    }

    public void setChunkData(int x, int y, int z, int width, int height, int length, byte[] data) {
        int minChunkX = Math.floorDiv(x, 16);
        int minChunkZ = Math.floorDiv(z, 16);
        int maxChunkX = Math.floorDiv(x + width - 1, 16);
        int maxChunkZ = Math.floorDiv(z + length - 1, 16);
        int startIndex = 0;
        int minY = y;
        int maxY = y + height;
        if (minY < 0) {
            minY = 0;
        }
        if (maxY > this.getHeightBlocks()) {
            maxY = this.getHeightBlocks();
        }
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            int minX = x - chunkX * 16;
            int maxX = x + width - chunkX * 16;
            if (minX < 0) {
                minX = 0;
            }
            if (maxX > 16) {
                maxX = 16;
            }
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                int minZ = z - chunkZ * 16;
                int maxZ = z + length - chunkZ * 16;
                if (minZ < 0) {
                    minZ = 0;
                }
                if (maxZ > 16) {
                    maxZ = 16;
                }
                startIndex = this.getChunkFromChunkCoords(chunkX, chunkZ).setChunkData(data, minX, minY, minZ, maxX, maxY, maxZ, startIndex);
                this.markBlocksDirty(chunkX * 16 + minX, minY, chunkZ * 16 + minZ, chunkX * 16 + maxX, maxY, chunkZ * 16 + maxZ);
            }
        }
    }

    public byte[] getChunkData(int x, int y, int z, int xSize, int ySize, int zSize) {
        byte[] data = new byte[xSize * ySize * zSize * 8];
        int minChunkX = Math.floorDiv(x, 16);
        int minChunkZ = Math.floorDiv(z, 16);
        int maxChunkX = Math.floorDiv(x + xSize - 1, 16);
        int maxChunkZ = Math.floorDiv(z + zSize - 1, 16);
        int startIndex = 0;
        int minY = y;
        int maxY = y + ySize;
        if (minY < 0) {
            minY = 0;
        }
        if (maxY > this.getHeightBlocks()) {
            maxY = this.getHeightBlocks();
        }
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            int minX = x - chunkX * 16;
            int maxX = x + xSize - chunkX * 16;
            if (minX < 0) {
                minX = 0;
            }
            if (maxX > 16) {
                maxX = 16;
            }
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                int minZ = z - chunkZ * 16;
                int maxZ = z + zSize - chunkZ * 16;
                if (minZ < 0) {
                    minZ = 0;
                }
                if (maxZ > 16) {
                    maxZ = 16;
                }
                startIndex = this.getChunkFromChunkCoords(chunkX, chunkZ).getChunkData(data, minX, minY, minZ, maxX, maxY, maxZ, startIndex);
            }
        }
        return data;
    }

    public void sendQuittingDisconnectingPacket() {
    }

    public void checkSessionLock() {
        this.saveHandler.checkSessionLock();
    }

    public void setWorldTime(long l) {
        this.levelData.setWorldTime(l);
    }

    public void setWorldTimeUpdateTicks(long ticks) {
        long delta = ticks - this.levelData.getWorldTime();
        for (NextTickListEntry entry : this.tickNextTickSet) {
            entry.delay += delta;
        }
        this.setWorldTime(ticks);
    }

    public long getRandomSeed() {
        return this.levelData.getRandomSeed();
    }

    public long getWorldTime() {
        return this.levelData.getWorldTime();
    }

    public Difficulty getDifficulty() {
        return this.levelData.getDifficulty();
    }

    public void setDifficulty(Difficulty difficulty, boolean overrideLock) {
        this.levelData.setDifficulty(difficulty, overrideLock);
    }

    public void setDifficulty(int difficulty, boolean overrideLock) {
        this.levelData.setDifficulty(difficulty, overrideLock);
    }

    @NotNull
    public TilePos getSpawnPoint() {
        return new TilePos(this.levelData.getSpawnX(), this.levelData.getSpawnY(), this.levelData.getSpawnZ());
    }

    public void setSpawnPoint(ChunkCoordinates chunkcoordinates) {
        this.levelData.setSpawn(chunkcoordinates.x, chunkcoordinates.y, chunkcoordinates.z);
    }

    public void joinEntityInSurroundings(Entity entity) {
        int i = MathHelper.floor(entity.x / 16.0);
        int j = MathHelper.floor(entity.z / 16.0);
        int byte0 = 2;
        for (int k = i - byte0; k <= i + byte0; ++k) {
            for (int l = j - byte0; l <= j + byte0; ++l) {
                this.getChunkFromChunkCoords(k, l);
            }
        }
        if (!this.entities.contains(entity)) {
            this.entities.add(entity);
        }
    }

    public boolean canMineBlock(@NotNull Player player, @NotNull TilePosc tilePos) {
        return true;
    }

    @Deprecated
    public final boolean canMineBlock(@NotNull Player player, int x, int y, int z) {
        return this.canMineBlock(player, new TilePos(x, y, z));
    }

    public void sendTrackedEntityStatusUpdatePacket(Entity entityId, byte entityStatus) {
    }

    public void sendTrackedEntityStatusUpdatePacket(Entity entityId, byte entityStatus, float attackedAtYaw) {
    }

    public void sendTrackedEntityDataPacket(Entity entity) {
    }

    public void updateEntityList() {
        int cZ;
        int cX;
        Entity entity;
        int i;
        this.entities.removeAll(this.entitiesToRemove);
        for (i = 0; i < this.entitiesToRemove.size(); ++i) {
            entity = this.entitiesToRemove.get(i);
            cX = entity.chunkCoordX;
            cZ = entity.chunkCoordZ;
            if (!entity.addedToChunk || !this.isChunkLoaded(cX, cZ)) continue;
            this.getChunkFromChunkCoords(cX, cZ).removeEntity(entity);
        }
        for (int j = 0; j < this.entitiesToRemove.size(); ++j) {
            this.releaseEntitySkin(this.entitiesToRemove.get(j));
        }
        this.entitiesToRemove.clear();
        for (i = 0; i < this.entities.size(); ++i) {
            entity = this.entities.get(i);
            if (entity.vehicle != null) {
                if (!entity.vehicle.isRemoved() && entity.vehicle.getPassenger() == entity) continue;
                entity.vehicle.setPassenger(null);
                entity.vehicle = null;
            }
            if (!entity.removed) continue;
            cX = entity.chunkCoordX;
            cZ = entity.chunkCoordZ;
            if (entity.addedToChunk && this.isChunkLoaded(cX, cZ)) {
                this.getChunkFromChunkCoords(cX, cZ).removeEntity(entity);
            }
            this.entities.remove(i--);
            this.releaseEntitySkin(entity);
        }
    }

    public IChunkProvider getChunkProvider() {
        return this.chunkProvider;
    }

    public void triggerEvent(@NotNull TilePosc tilePos, int index, int data) {
        @Nullable Block<?> block = this.getBlock(tilePos);
        if (block != null) {
            block.triggerEvent(this, tilePos.x(), tilePos.y(), tilePos.z(), index, data);
        }
    }

    @Deprecated
    public final void triggerEvent(int x, int y, int z, int index, int data) {
        this.triggerEvent(new TilePos(x, y, z), index, data);
    }

    public LevelStorage getSaveHandler() {
        return this.saveHandler;
    }

    public LevelData getLevelData() {
        return this.levelData;
    }

    public void updateEnoughPlayersSleepingFlag(Player player) {
        this.enoughPlayersSleeping = false;
        if (!this.players.isEmpty()) {
            int playersSleeping = 0;
            int req = this.getPlayersRequiredToSkipNight();
            for (Player p : this.players) {
                if (!p.isPlayerSleeping()) continue;
                ++playersSleeping;
            }
            if (playersSleeping >= req) {
                this.enoughPlayersSleeping = true;
            }
        }
    }

    public int getPlayersRequiredToSkipNight() {
        return (int)((double)this.players.size() * ((double)this.sleepPercent / 100.0));
    }

    protected void wakeUpAllPlayers() {
        this.enoughPlayersSleeping = false;
        for (Player entityplayer : this.players) {
            if (!entityplayer.isPlayerSleeping()) continue;
            entityplayer.wakeUpPlayer(false, false);
        }
        @Nullable Weather currentWeather = this.getCurrentWeather();
        if (currentWeather instanceof IPrecipitation && ((IPrecipitation)((Object)currentWeather)).spawnRainParticles()) {
            this.weatherManager.overrideWeather(this.worldType.getDefaultWeather());
        }
    }

    public boolean areEnoughPlayersFullyAsleep() {
        if (this.enoughPlayersSleeping && !this.isClientSide) {
            int fullyAsleep = 0;
            for (Player player : this.players) {
                if (!player.isPlayerFullyAsleep()) continue;
                ++fullyAsleep;
            }
            return fullyAsleep >= this.getPlayersRequiredToSkipNight() && fullyAsleep > 0;
        }
        return false;
    }

    public boolean isBlockBeingRainedOn(@NotNull TilePosc tilePos) {
        if (this.getCurrentWeather() == null || !(this.getCurrentWeather() instanceof IPrecipitation) || !this.canBlockSeeSky(tilePos) || this.getHeightValue(tilePos.x(), tilePos.z()) > tilePos.y()) {
            return false;
        }
        @NotNull Biome biome = this.getBlockBiome(tilePos);
        for (Weather weather : biome.blockedWeathers) {
            if (weather != this.getCurrentWeather()) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public final boolean canBlockBeRainedOn(int x, int y, int z) {
        return this.isBlockBeingRainedOn(new TilePos(x, y, z));
    }

    public void setSavedData(String id, SavedData savedData) {
        this.savedDataStorage.set(id, savedData);
    }

    public SavedData getSavedData(Class<? extends SavedData> saveDataClass, String id) {
        return this.savedDataStorage.load(saveDataClass, id);
    }

    public int getUniqueDataId(String s) {
        return this.savedDataStorage.getFreeMetadataFor(s);
    }

    public void playBlockEvent(@NotNull TilePosc tilePos, int id, int data) {
        this.playBlockEvent(null, tilePos, id, data);
    }

    @Deprecated
    public final void playBlockEvent(int id, int x, int y, int z, int data) {
        this.playBlockEvent(new TilePos(x, y, z), id, data);
    }

    public void playBlockEvent(@Nullable Player player, @NotNull TilePosc tilePos, int id, int data) {
        for (LevelListener listener : this.listeners) {
            listener.levelEvent(player, id, tilePos.x(), tilePos.y(), tilePos.z(), data);
        }
    }

    @Deprecated
    public final void playBlockEvent(@Nullable Player player, int id, int x, int y, int z, int data) {
        this.playBlockEvent(player, new TilePos(x, y, z), id, data);
    }

    @NotNull
    public WorldType getWorldType() {
        return this.worldType;
    }

    @NotNull
    public EntityItem dropItem(@NotNull TilePosc tilePos, @NotNull ItemStack itemStack) {
        float radius = 0.7f;
        double x = (double)(this.rand.nextFloat() * 0.7f) + (double)0.15f;
        double y = (double)(this.rand.nextFloat() * 0.7f) + (double)0.15f;
        double z = (double)(this.rand.nextFloat() * 0.7f) + (double)0.15f;
        @NotNull EntityItem item = new EntityItem(this, (double)tilePos.x() + x, (double)tilePos.y() + y, (double)tilePos.z() + z, itemStack);
        item.pickupDelay = 10;
        this.entityJoinedWorld(item);
        return item;
    }

    @Deprecated
    @NotNull
    public final EntityItem dropItem(int x, int y, int z, @NotNull ItemStack itemStack) {
        return this.dropItem(new TilePos(x, y, z), itemStack);
    }

    public void sendGlobalMessage(String message) {
        for (Player player : this.players) {
            player.sendMessage(message);
        }
    }

    public int renderDistance() {
        return 12;
    }
}

