/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.particle.ParticleFirefly;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.tessellator.TessellatorShader;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.world.WorldClient;
import net.minecraft.core.entity.animal.MobFireflyCluster;
import org.jetbrains.annotations.NotNull;

public class MobRendererFireflyCluster
extends EntityRenderer<MobFireflyCluster> {
    private final List<ParticleFirefly> fireflies = new ArrayList<ParticleFirefly>();
    private final Random rand = new Random(0L);
    private long lastTick;

    public MobRendererFireflyCluster() {
        for (int i = 0; i < 20; ++i) {
            ParticleFirefly fx = new ParticleFirefly(WorldClient.EMPTY_WORLD, this.rand.nextFloat() - 0.5f, this.rand.nextFloat() - 0.5f, 0.0, 0.0, 0.0, 0.0, 0);
            fx.noPhysics = true;
            fx.setAge(this.rand.nextInt(20));
            this.fireflies.add(fx);
        }
        this.lastTick = System.currentTimeMillis();
    }

    @Override
    public void render(@NotNull TessellatorGeneral tessellator, @NotNull MobFireflyCluster parent, double x, double y, double z, float yaw, float partialTick) {
    }

    @Override
    public void renderPreview(@NotNull TessellatorGeneral tessellator, @NotNull MobFireflyCluster entity, double x, double y, double z, float yaw, float partialTick) {
        int i;
        super.renderPreview(tessellator, entity, x, y, z, yaw, partialTick);
        long currentTick = System.currentTimeMillis();
        int storedTicks = (int)((float)(currentTick - this.lastTick) / 50.0f);
        GLRenderer.pushFrame();
        GLRenderer.modelM4f().translate(0.0f, 0.75f, 0.0f);
        GLRenderer.enableState(State.BLEND);
        Lighting.disable();
        TextureRegistry.worldAtlas.bind();
        TessellatorShader t = GLRenderer.getTessellator();
        t.startDrawingQuads();
        for (i = 0; i < this.fireflies.size(); ++i) {
            ParticleFirefly firefly = this.fireflies.get(i);
            firefly.renderParticleInGui(t, partialTick);
            for (int j = 0; j < storedTicks; ++j) {
                firefly.tickGui();
                this.lastTick = currentTick;
            }
            if (!firefly.removed) continue;
            this.fireflies.remove(i);
            --i;
        }
        t.draw();
        GLRenderer.enableState(State.CULL_FACE);
        GLRenderer.popFrame();
        if (this.fireflies.size() < 20) {
            for (i = this.fireflies.size(); i < 20; ++i) {
                if (this.rand.nextInt(4) == 0) continue;
                ParticleFirefly fx = new ParticleFirefly(WorldClient.EMPTY_WORLD, this.rand.nextFloat() - 0.5f, this.rand.nextFloat() - 0.5f, 0.0, 0.0, 0.0, 0.0, entity.getColor().getId());
                fx.noPhysics = true;
                fx.setAge(this.rand.nextInt(20));
                this.fireflies.add(fx);
            }
        }
    }
}

