/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.terrain;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.render.terrain.RenderRegion;

public class RegionBuffer {
    public final int regionSizeShift;
    private final Int2ObjectMap<RenderRegion> regionMap = new Int2ObjectOpenHashMap<RenderRegion>();
    private final List<RenderRegion> regionList = new ArrayList<RenderRegion>();
    private final List<RenderRegion> immutableRegionList = Collections.unmodifiableList(this.regionList);

    public RegionBuffer(int regionSizeShift) {
        this.regionSizeShift = regionSizeShift;
    }

    public RenderRegion getRegionAtBlockPos(int blockX, int blockZ) {
        int x = blockX >> this.regionSizeShift;
        int z = blockZ >> this.regionSizeShift;
        return this.getRegion(x, z);
    }

    public RenderRegion getRegion(int x, int z) {
        int index = this.getIndex(x, z);
        RenderRegion region = (RenderRegion)this.regionMap.get(index);
        if (region == null) {
            region = new RenderRegion(x, z);
            this.regionMap.put(index, region);
            this.regionList.add(region);
        } else if (region.posX != x || region.posZ != z) {
            throw new RuntimeException(String.valueOf(region) + " != " + String.valueOf(new RenderRegion(x, z)));
        }
        return region;
    }

    public void remove(RenderRegion region) {
        int index = this.getIndex(region.posX, region.posZ);
        RenderRegion existingRegion = (RenderRegion)this.regionMap.get(index);
        if (existingRegion != region) {
            throw new RuntimeException(String.valueOf(region) + " != " + String.valueOf(existingRegion));
        }
        this.regionMap.remove(index);
        this.regionList.remove(region);
    }

    public int getIndex(int x, int z) {
        return (x & 0xFFFF) << 16 | z & 0xFFFF;
    }

    public List<RenderRegion> getAllRegions() {
        return this.immutableRegionList;
    }

    public int size() {
        return this.regionMap.size();
    }
}

