/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.texturepack;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.TooltipElement;
import net.minecraft.client.gui.keyboard.KeyboardLayout;
import net.minecraft.client.render.EntityRendererDispatcher;
import net.minecraft.client.render.TileEntityRenderDispatcher;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.texturepack.TexturePack;
import net.minecraft.client.render.texturepack.TexturePackCustom;
import net.minecraft.client.render.texturepack.TexturePackDefault;
import net.minecraft.client.sound.SoundRepository;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.useless.dragonfly.data.entity.mojang.EntityGeometryMojangData;

public class TexturePackList {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String SEPERATOR = "<-=-=->";
    private List<TexturePack> availableTexturePacks = new ArrayList<TexturePack>();
    private final TexturePack defaultTexturePack = new TexturePackDefault();
    public List<TexturePack> selectedPacks = new ArrayList<TexturePack>();
    private final Map<String, TexturePack> texturePackIDs = new HashMap<String, TexturePack>();
    private final Minecraft mc;
    private final File texturePackDir;
    private boolean isDirty = false;

    public TexturePackList(Minecraft minecraft, File file) {
        this.mc = minecraft;
        this.texturePackDir = new File(file, "texturepacks");
        if (!this.texturePackDir.exists()) {
            this.texturePackDir.mkdirs();
        }
    }

    public void init() {
        this.updateAvailableTexturePacks();
    }

    public void shiftPack(TexturePack pack, int shiftAmount) {
        if (!this.selectedPacks.contains(pack)) {
            return;
        }
        if (shiftAmount == 0) {
            return;
        }
        int currentIndex = this.selectedPacks.indexOf(pack);
        int newIndex = currentIndex + shiftAmount;
        if (newIndex < 0) {
            newIndex = 0;
        }
        if (newIndex >= this.selectedPacks.size()) {
            newIndex = this.selectedPacks.size() - 1;
        }
        this.selectedPacks.remove(pack);
        this.selectedPacks.add(newIndex, pack);
        this.savePacksToSettings();
        this.isDirty = true;
    }

    public void setTexturePack(TexturePack newPack) {
        if (!this.selectedPacks.contains(newPack)) {
            this.selectedPacks.add(newPack);
            newPack.readZipFile();
            this.savePacksToSettings();
            this.isDirty = true;
        }
    }

    public void savePacksToSettings() {
        this.mc.gameSettings.skin.value = this.packSaveString();
        this.mc.gameSettings.saveOptions();
    }

    public String packSaveString() {
        StringBuilder builder = new StringBuilder();
        for (TexturePack pack : this.selectedPacks) {
            if (pack == this.defaultTexturePack) continue;
            builder.append(pack.fileName).append(SEPERATOR);
        }
        return builder.toString();
    }

    public void unsetTexturePack(TexturePack pack) {
        pack.closeTexturePackFile();
        this.selectedPacks.remove(pack);
        this.savePacksToSettings();
        this.isDirty = true;
    }

    public void refreshIfReady() {
        if (this.isDirty) {
            this.isDirty = false;
            this.refresh();
        }
    }

    public void refresh() {
        this.mc.textureManager.refreshTexturesAndDisplayErrors();
        this.mc.renderGlobal.allChanged();
        if (this.mc.currentScreen != null) {
            this.mc.currentScreen.updateFont();
        }
        this.mc.textureManager.updateDynamicTextures(false);
        SoundRepository.reload();
        BlockModelDispatcher.getInstance().reload();
        ItemModelDispatcher.getInstance().reload();
        EntityGeometryMojangData.Cache.reload(this);
        EntityRendererDispatcher.instance.reload();
        TileEntityRenderDispatcher.instance.reload();
        KeyboardLayout.defaultLayout = new KeyboardLayout();
        TooltipElement.reloadStyles(this);
    }

    public boolean updateAvailableTexturePacks() {
        String[] packStrings;
        File[] filesArr;
        ArrayList<TexturePack> currentTexturePacks = new ArrayList<TexturePack>();
        boolean update = false;
        if (this.texturePackDir.exists() && this.texturePackDir.isDirectory() && (filesArr = this.texturePackDir.listFiles()) != null) {
            Object resources;
            ArrayList<File> fileList = new ArrayList<File>(Arrays.asList(filesArr));
            if (((Boolean)this.mc.gameSettings.enableDevResourceLoading.value).booleanValue()) {
                resources = new File("./src/main/resources");
                fileList.add((File)resources);
                File devPacksPath = new File("./devPacks");
                File[] devPacks = devPacksPath.listFiles();
                if (devPacks != null) {
                    fileList.addAll(Arrays.asList(devPacks));
                }
            }
            resources = fileList.iterator();
            while (resources.hasNext()) {
                File file = (File)resources.next();
                if (!this.isTexturePack(file)) continue;
                String id = this.getTexturePackID(file);
                try {
                    TexturePack pack;
                    if (!this.texturePackIDs.containsKey(id)) {
                        pack = new TexturePackCustom(file);
                        ((TexturePackCustom)pack).packId = id;
                        ((TexturePackCustom)pack).readZipFile();
                        ((TexturePackCustom)pack).readTexturePackManifest();
                        this.texturePackIDs.put(id, pack);
                        ((TexturePackCustom)pack).closeTexturePackFile();
                        update = true;
                    }
                    pack = this.texturePackIDs.get(id);
                    currentTexturePacks.add(pack);
                }
                catch (IOException e) {
                    LOGGER.error("Failed to make texturepack for file '{}'!", (Object)file.getPath(), (Object)e);
                }
            }
        }
        List<TexturePack> previousTexturePacks = this.availableTexturePacks;
        previousTexturePacks.removeAll(currentTexturePacks);
        if (!previousTexturePacks.isEmpty()) {
            update = true;
        }
        for (TexturePack texturePack : previousTexturePacks) {
            texturePack.disposeOfTexturePack(this.mc);
            this.texturePackIDs.remove(texturePack.packId);
        }
        this.availableTexturePacks = currentTexturePacks;
        for (String string : packStrings = ((String)this.mc.gameSettings.skin.value).split(SEPERATOR)) {
            for (TexturePack pack : this.availableTexturePacks) {
                if (!string.equals(pack.fileName) || this.selectedPacks.contains(pack)) continue;
                pack.readZipFile();
                this.selectedPacks.add(pack);
            }
        }
        return update;
    }

    private String getTexturePackID(File file) {
        if (file.isFile()) {
            return file.getName() + ":" + file.length() + ":" + file.lastModified();
        }
        File manifestFile = new File(file, "manifest.json");
        File packPngFile = new File(file, "pack.png");
        return file.getName() + ":" + manifestFile.length() + ":" + manifestFile.lastModified() + ":" + packPngFile.length() + ":" + packPngFile.lastModified();
    }

    private boolean isTexturePack(File file) {
        if (file.isDirectory()) {
            return new File(file, "pack.txt").exists() || new File(file, "manifest.json").exists();
        }
        return file.getName().toLowerCase().endsWith(".zip");
    }

    public List<TexturePack> availableTexturePacks() {
        return new ArrayList<TexturePack>(this.availableTexturePacks);
    }

    public List<TexturePack> selectedTexturePacks() {
        return new ArrayList<TexturePack>(this.selectedPacks);
    }

    public TexturePack getDefaultTexturePack() {
        return this.defaultTexturePack;
    }

    public InputStream getResourceAsStream(String s) {
        return this.getResourceAsStream(s, true);
    }

    private InputStream getResourceAsStream(String s, boolean firstCall) {
        for (int i = this.selectedPacks.size() - 1; i >= 0; --i) {
            TexturePack pack = this.selectedPacks.get(i);
            InputStream stream = pack.getResourceAsStream(s);
            if (stream == null) continue;
            return stream;
        }
        return this.defaultTexturePack.getResourceAsStream(s);
    }

    public TexturePack getHighestPriorityPack() {
        if (this.selectedPacks.isEmpty()) {
            return this.defaultTexturePack;
        }
        return this.selectedPacks.get(this.selectedPacks.size() - 1);
    }

    public boolean anyHasFile(String path) {
        for (int i = 0; i < this.selectedPacks.size(); ++i) {
            if (!this.selectedPacks.get(i).hasFile(path)) continue;
            return true;
        }
        return this.defaultTexturePack.hasFile(path);
    }

    @Nullable
    public TexturePack getHighestPriorityTexturePackWithFile(String path) {
        return this.getHighestPriorityTexturePackWithFile(path, true);
    }

    @Nullable
    private TexturePack getHighestPriorityTexturePackWithFile(String path, boolean firstCall) {
        for (int i = this.selectedPacks.size() - 1; i >= 0; --i) {
            TexturePack texturePack = this.selectedPacks.get(i);
            if (!texturePack.hasFile(path)) continue;
            return texturePack;
        }
        if (this.defaultTexturePack.hasFile(path)) {
            return this.defaultTexturePack;
        }
        return null;
    }
}

