/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PacketSetMobSpawner;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.joml.primitives.AABBd;
import org.slf4j.Logger;

public class TileEntityMobSpawner
extends TileEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    public int delay = 20;
    private String mobId = "minecraft:pig";
    public double yaw;
    public double yaw2 = 0.0;
    private int nearby;

    public String getMobId() {
        return this.mobId;
    }

    public void setMobId(String mobId) {
        this.mobId = mobId != null && mobId.equalsIgnoreCase("none") ? null : mobId;
        try {
            if (EntityDispatcher.Legacy.isLegacyKey(mobId)) {
                EntityDispatcher.EntityDispatcherEntry<? extends Entity> entry = EntityDispatcher.getInstance().entryForClass(EntityDispatcher.Legacy.getClassFromEncodeID(mobId));
                this.mobId = entry != null ? entry.stringID : null;
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to convert legacy mobspawner id!", e);
        }
    }

    public boolean anyPlayerInRange() {
        return this.worldObj != null && this.worldObj.getClosestPlayer((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5, 16.0) != null;
    }

    @Override
    public void tick() {
        if (this.worldObj.getBlockId(this.x, this.y, this.z) != Blocks.MOBSPAWNER.id()) {
            return;
        }
        this.yaw2 = this.yaw;
        if (!this.anyPlayerInRange()) {
            return;
        }
        double xPos = (double)this.x + (double)this.worldObj.rand.nextFloat();
        double yPos = (double)this.y + (double)this.worldObj.rand.nextFloat();
        double zPos = (double)this.z + (double)this.worldObj.rand.nextFloat();
        this.worldObj.spawnParticle("smoke", xPos, yPos, zPos, 0.0, 0.0, 0.0, 0);
        this.worldObj.spawnParticle("flame", xPos, yPos, zPos, 0.0, 0.0, 0.0, 0);
        this.yaw += (double)(1000.0f / ((float)this.delay + 200.0f));
        while (this.yaw > 360.0) {
            this.yaw -= 360.0;
            this.yaw2 -= 360.0;
        }
        if (!this.worldObj.isClientSide) {
            if (!this.worldObj.getDifficulty().canHostileMobsSpawn()) {
                return;
            }
            if (this.mobId == null || this.mobId.equalsIgnoreCase("none")) {
                return;
            }
            if (this.delay == -1) {
                this.updateDelay();
            }
            if (this.delay > 0) {
                --this.delay;
                return;
            }
            if (this.mobId == null) {
                this.nearby = this.countNearbySpawners();
            }
            int byte0 = 4;
            for (int i = 0; i < byte0; ++i) {
                Mob mob = (Mob)EntityDispatcher.getInstance().createEntityInWorld(this.mobId, this.worldObj);
                if (mob == null) {
                    return;
                }
                AABBd checkBB = new AABBd(this.x, this.y, this.z, this.x + 1, this.y + 1, this.z + 1);
                MathHelper.aabbGrow(checkBB, 8.0, 4.0, 8.0, checkBB);
                int nearbySpawnCount = this.worldObj.getEntitiesWithinAABB(mob.getClass(), checkBB).size();
                if (nearbySpawnCount >= 6) {
                    this.updateDelay();
                    return;
                }
                double d6 = (double)this.x + (this.worldObj.rand.nextDouble() - this.worldObj.rand.nextDouble()) * 4.0;
                double d7 = this.y + this.worldObj.rand.nextInt(3) - 1;
                double d8 = (double)this.z + (this.worldObj.rand.nextDouble() - this.worldObj.rand.nextDouble()) * 4.0;
                mob.moveTo(d6, d7, d8, this.worldObj.rand.nextFloat() * 360.0f, 0.0f);
                if (!mob.canSpawnHere()) {
                    this.updateDelay();
                    continue;
                }
                this.worldObj.entityJoinedWorld(mob);
                for (int k = 0; k < 20; ++k) {
                    double d1 = (double)this.x + 0.5 + ((double)this.worldObj.rand.nextFloat() - 0.5) * 2.0;
                    double d3 = (double)this.y + 0.5 + ((double)this.worldObj.rand.nextFloat() - 0.5) * 2.0;
                    double d5 = (double)this.z + 0.5 + ((double)this.worldObj.rand.nextFloat() - 0.5) * 2.0;
                    this.worldObj.spawnParticle("smoke", d1, d3, d5, 0.0, 0.0, 0.0, 0);
                    this.worldObj.spawnParticle("flame", d1, d3, d5, 0.0, 0.0, 0.0, 0);
                    this.worldObj.playSoundAtEntity(null, mob, "tile.mobspawner.spawn", 0.025f, 0.75f);
                }
                mob.spawnExplosionParticle();
                this.updateDelay();
            }
        }
        super.tick();
    }

    @Override
    public Packet getDescriptionPacket() {
        return new PacketSetMobSpawner(new TilePos(this.x, this.y, this.z), EntityDispatcher.getInstance().entryForId(this.mobId));
    }

    public int countNearbySpawners() {
        int r = 4;
        int count = 0;
        TilePos tilePos = new TilePos(0, 0, 0);
        tilePos.x = this.x - r;
        while (tilePos.x <= this.x + r) {
            tilePos.y = this.y - r;
            while (tilePos.y <= this.y + r) {
                tilePos.z = this.z - r;
                while (tilePos.z <= this.z + r) {
                    int id = this.worldObj.getBlockId(tilePos);
                    if (id == Blocks.MOBSPAWNER.id()) {
                        ++count;
                    }
                    ++tilePos.z;
                }
                ++tilePos.y;
            }
            ++tilePos.x;
        }
        return count;
    }

    private void updateDelay() {
        this.delay = 200 + this.worldObj.rand.nextInt(600);
        if (this.mobId == null) {
            this.delay *= 2;
            LOGGER.debug("x2");
            if (this.nearby > 1) {
                LOGGER.debug("x4");
                this.delay *= 4;
            }
        }
    }

    @Override
    public void readAdditionalData(@NotNull CompoundTag compoundTag) {
        this.setMobId(compoundTag.getString("EntityId"));
        this.delay = compoundTag.getShort("Delay");
    }

    @Override
    public void writeAdditionalData(@NotNull CompoundTag compoundTag) {
        compoundTag.putString("EntityId", this.mobId != null ? this.mobId : "none");
        compoundTag.putShort("Delay", (short)this.delay);
    }
}

