#version 410
out vec4 FragColor;
in vec2 TexCoords;

uniform sampler2D depthtex0;

uniform float width;
uniform float height;
uniform float intensity;

float getDepth(vec2 coord){
	return texture(depthtex0, coord).r;
}

void main(){
	float outline = 0.0;
	
	float size = 4.0 * intensity;
	
	outline += clamp(getDepth(TexCoords) - getDepth(TexCoords + vec2(size / width, 0)), 0.0, 1.0);
	outline += clamp(getDepth(TexCoords) - getDepth(TexCoords - vec2(size / width, 0)), 0.0, 1.0);
	outline += clamp(getDepth(TexCoords) - getDepth(TexCoords + vec2(0, size / height)), 0.0, 1.0);
	outline += clamp(getDepth(TexCoords) - getDepth(TexCoords - vec2(0, size / height)), 0.0, 1.0);
	
	outline = 1.0 - clamp(outline * 512, 0.0, 1.0);
	
	FragColor = vec4(vec3(outline), 1.0);
}