/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.achievements;

import java.util.Objects;
import java.util.Random;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.ItemElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.TooltipElement;
import net.minecraft.client.gui.achievements.data.AchievementPage;
import net.minecraft.client.gui.achievements.data.AchievementPageRegistry;
import net.minecraft.client.gui.achievements.data.AchievementPages;
import net.minecraft.client.gui.options.OptionsButtonElement;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.Scissor;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.renderer.BlendFactor;
import net.minecraft.client.render.renderer.CompareFunc;
import net.minecraft.client.render.renderer.DrawMode;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.Shaders;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.tessellator.RenderBuffer;
import net.minecraft.client.render.tessellator.TessellatorShader;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.achievement.Achievement;
import net.minecraft.core.achievement.stat.StatsCounter;
import net.minecraft.core.item.Item;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL41;

public class ScreenAchievements
extends Screen {
    private static final int TOP_SPACING = 24;
    private static final int BUTTON_SPACING = 4;
    private static final int SEPARATOR_WIDTH = 8;
    private static final int PADDING = 8;
    private static final int PAGE_BUTTON_HEIGHT = 20;
    private static final int ACHIEVEMENT_CELL_WIDTH = 24;
    private static final int ACHIEVEMENT_CELL_HEIGHT = 24;
    private static final int ACHIEVEMENT_ICON_WIDTH = 26;
    private static final int ACHIEVEMENT_ICON_HEIGHT = 26;
    private static final int TOOLTIP_BOX_WIDTH_MIN = 120;
    private static final int TOOLTIP_OFF_X = 8;
    private static final int TOOLTIP_OFF_Y = -4;
    protected int mouseXOld = 0;
    protected int mouseYOld = 0;
    protected double oldShiftX;
    protected double oldShiftY;
    protected double targetShiftX;
    protected double targetShiftY;
    protected double currentShiftX;
    protected double currentShiftY;
    private boolean draggingViewport = false;
    private final StatsCounter statsCounter;
    private final TooltipElement tooltip;
    private ItemElement renderItem = null;
    Screen parent;
    private int top;
    private int bottom;
    private int viewportLeft;
    private int viewportTop;
    private int viewportRight;
    private int viewportBottom;
    private int viewportWidth;
    private int viewportHeight;
    private double viewportZoom = 1.0;
    private double shiftMinX;
    private double shiftMinY;
    private double shiftMaxX;
    private double shiftMaxY;
    private int pageListLeft;
    private int pageListRight;
    private float pageListScrollAmount = 0.0f;
    private Float oldPagesListScrollAmount;
    private int pagesListScrollRegionHeight;
    private Integer clickX;
    private Integer clickY;
    private AchievementPage hoveredPage = null;
    private Achievement hoveredAchievement = null;
    private AchievementPage currentPage = AchievementPages.overworldPage;
    @NotNull
    private BGLayer[] layers;
    private static final int TILE_WIDTH = 16;
    private static final int TILE_HEIGHT = 16;
    public int lastTileX = Integer.MIN_VALUE;
    public int lastTileY = Integer.MIN_VALUE;
    public int lastTilesWide = Integer.MIN_VALUE;
    public int lastTilesTall = Integer.MIN_VALUE;
    @Nullable
    public RenderBuffer lastBackgroundTileBuf;
    @Nullable
    public RenderBuffer lastBackgroundShadowBuf;

    public ScreenAchievements(Screen parent, StatsCounter statsCounter) {
        this.statsCounter = statsCounter;
        this.parent = parent;
        this.tooltip = new TooltipElement(this.mc);
        this.renderItem = new ItemElement(this.mc);
        this.layers = new BGLayer[this.currentPage.backgroundLayers()];
        for (int i = 0; i < this.layers.length; ++i) {
            this.layers[i] = new BGLayer(i);
        }
    }

    @Override
    public void init() {
        this.buttons.clear();
        this.buttons.add(new OptionsButtonElement(1, this.width / 2 - 100, this.height - 20 - 4, 200, 20, I18n.getInstance().translateKey("gui.achievements.button.done")));
        this.lastTileX = Integer.MIN_VALUE;
        this.lastTileY = Integer.MIN_VALUE;
        this.top = 24;
        this.bottom = this.height - 28;
        this.pagesListScrollRegionHeight = this.bottom - this.top;
        this.pageListLeft = 0;
        this.pageListRight = this.width / 4;
        this.viewportZoom = 1.0;
        this.viewportLeft = this.drawSidebar() ? this.pageListRight + 8 : 0;
        this.viewportTop = this.top;
        this.viewportBottom = this.bottom;
        this.viewportRight = this.width;
        this.viewportWidth = this.viewportRight - this.viewportLeft;
        this.viewportHeight = this.viewportBottom - this.viewportTop;
        int achMinX = Integer.MAX_VALUE;
        int achMinY = Integer.MAX_VALUE;
        int achMaxX = Integer.MIN_VALUE;
        int achMaxY = Integer.MIN_VALUE;
        for (AchievementPage.AchievementEntry ach : this.currentPage.getAchievementEntries()) {
            if (ach.x < achMinX) {
                achMinX = ach.x;
            }
            if (ach.y < achMinY) {
                achMinY = ach.y;
            }
            if (ach.x > achMaxX) {
                achMaxX = ach.x;
            }
            if (ach.y <= achMaxY) continue;
            achMaxY = ach.y;
        }
        this.shiftMinX = achMinX * 24;
        this.shiftMinY = achMinY * 24;
        this.shiftMaxX = achMaxX * 24 + 24;
        this.shiftMaxY = achMaxY * 24 + 24;
        this.shiftMinX -= (double)((int)((double)this.viewportWidth / 4.0));
        this.shiftMinY -= (double)((int)((double)this.viewportHeight / 4.0));
        this.shiftMaxX += (double)((int)((double)this.viewportWidth / 4.0));
        this.shiftMaxY += (double)((int)((double)this.viewportHeight / 4.0));
        AchievementPage.AchievementEntry ach = this.currentPage.onOpenAchievement();
        this.targetShiftX = this.currentShiftX = (double)(ach.x * 24) + 12.0;
        this.oldShiftX = this.currentShiftX;
        this.targetShiftY = this.currentShiftY = (double)(ach.y * 24) + 12.0;
        this.oldShiftY = this.currentShiftY;
    }

    @Override
    public void removed() {
        if (this.lastBackgroundShadowBuf != null) {
            this.lastBackgroundShadowBuf.delete();
            this.lastBackgroundShadowBuf = null;
        }
        if (this.lastBackgroundTileBuf != null) {
            this.lastBackgroundTileBuf.delete();
            this.lastBackgroundTileBuf = null;
        }
    }

    @Override
    protected void buttonClicked(@NotNull ButtonElement button) {
        if (button.id == 1) {
            this.mc.displayScreen(this.parent);
        }
        super.buttonClicked(button);
    }

    @Override
    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        if (eventKey == Keyboard.KEY_ESCAPE) {
            this.mc.displayScreen(this.parent);
        } else {
            super.keyPressed(eventCharacter, eventKey, mx, my);
        }
    }

    @Override
    public void mouseClicked(int mx, int my, int buttonNum) {
        if (this.drawSidebar() && mx >= this.pageListLeft && mx <= this.pageListRight - 6 && my >= this.top && my <= this.bottom) {
            int pagesListHeight = this.getTotalPagesListHeight();
            int pagesListY = this.top - (int)this.pageListScrollAmount;
            if (pagesListHeight < this.bottom - this.top) {
                pagesListY = this.top + (this.bottom - this.top - pagesListHeight) / 2;
            }
            for (AchievementPage page : AchievementPageRegistry.getInstance().getPages()) {
                if (mx >= this.pageListLeft && mx <= this.pageListRight - 6 && my >= pagesListY && my <= pagesListY + 20) {
                    this.currentPage = page;
                    if (this.lastBackgroundShadowBuf != null) {
                        this.lastBackgroundShadowBuf.delete();
                        this.lastBackgroundShadowBuf = null;
                    }
                    if (this.lastBackgroundTileBuf != null) {
                        this.lastBackgroundTileBuf.delete();
                        this.lastBackgroundTileBuf = null;
                    }
                    this.mc.sndManager.playSound("random.click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
                    this.layers = new BGLayer[this.currentPage.backgroundLayers()];
                    for (int i = 0; i < this.layers.length; ++i) {
                        this.layers[i] = new BGLayer(i);
                    }
                    this.init();
                    break;
                }
                pagesListY += 20;
            }
        }
        super.mouseClicked(mx, my, buttonNum);
        this.clickX = mx;
        this.clickY = my;
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        if (Mouse.isButtonDown(0)) {
            if (mx >= this.viewportLeft && mx < this.viewportRight && my >= this.viewportTop && my < this.viewportBottom) {
                if (!this.draggingViewport) {
                    this.draggingViewport = true;
                } else {
                    this.targetShiftX -= (double)(mx - this.mouseXOld) / this.viewportZoom;
                    this.targetShiftY -= (double)(my - this.mouseYOld) / this.viewportZoom;
                    this.currentShiftX = this.oldShiftX = this.targetShiftX;
                    this.currentShiftY = this.oldShiftY = this.targetShiftY;
                }
                this.mouseXOld = mx;
                this.mouseYOld = my;
            }
            this.currentShiftX = MathHelper.clamp(this.currentShiftX, this.shiftMinX, this.shiftMaxX);
            this.currentShiftY = MathHelper.clamp(this.currentShiftY, this.shiftMinY, this.shiftMaxY);
        } else if (this.mc.controllerInput != null) {
            this.targetShiftX += (double)this.mc.controllerInput.joyRight.getX() / this.viewportZoom * 4.0;
            this.targetShiftY += (double)this.mc.controllerInput.joyRight.getY() / this.viewportZoom * 4.0;
            this.currentShiftX = this.oldShiftX = this.targetShiftX;
            this.currentShiftY = this.oldShiftY = this.targetShiftY;
            this.currentShiftX = MathHelper.clamp(this.currentShiftX, this.shiftMinX, this.shiftMaxX);
            this.currentShiftY = MathHelper.clamp(this.currentShiftY, this.shiftMinY, this.shiftMaxY);
            if (this.mc.controllerInput.buttonLeftTrigger.isPressed()) {
                this.viewportZoom -= 0.01;
            } else if (this.mc.controllerInput.buttonRightTrigger.isPressed()) {
                this.viewportZoom += (double)0.01f;
            }
            this.viewportZoom = MathHelper.clamp(this.viewportZoom, 0.5, 2.0);
        } else {
            this.clickY = null;
            this.clickX = null;
            this.oldPagesListScrollAmount = null;
            this.draggingViewport = false;
        }
        if (this.drawSidebar() && mx >= this.pageListLeft && mx <= this.pageListRight) {
            if (Keyboard.isKeyDown(Keyboard.KEY_LCONTROL) || Keyboard.isKeyDown(Keyboard.KEY_RCONTROL)) {
                this.scrollPagesList((float)Mouse.getDWheel() / -0.01f);
            } else {
                this.scrollPagesList((float)Mouse.getDWheel() / -0.05f);
            }
            this.onScrollPagesList();
        } else if (mx >= this.viewportLeft && mx <= this.viewportRight && my >= this.viewportTop && my <= this.viewportBottom) {
            double change = (double)Mouse.getDWheel() / 10.0;
            this.viewportZoom = MathHelper.clamp(this.viewportZoom + change, 0.5, 2.0);
            if (change != 0.0) {
                double[] notches;
                for (double notch : notches = new double[]{0.25, 0.5, 1.0, 2.0, 4.0}) {
                    if (!(Math.abs(this.viewportZoom - notch) < 0.05)) continue;
                    this.viewportZoom = notch;
                    break;
                }
            }
        }
        Mouse.getDWheel();
        this.renderBackground();
        if (this.drawSidebar()) {
            this.overlayBackground(0, this.pageListRight, this.top, this.bottom, 0x202020);
        }
        this.renderAchievementsPanel(mx, my, partialTick);
        this.overlayBackground(0, this.width, 0, this.top, 0x404040);
        this.overlayBackground(0, this.width, this.bottom, this.height, 0x404040);
        this.overlayBackground(this.pageListRight, this.viewportLeft, this.top, this.bottom, 0x404040);
        GLRenderer.enableState(State.BLEND);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        super.render(mx, my, partialTick);
        GLRenderer.enableState(State.DEPTH_TEST);
        GLRenderer.globalSetLightEnabled(true);
        Lighting.disable();
        GLRenderer.globalSetLightEnabled(false);
        GLRenderer.disableState(State.DEPTH_TEST);
        if (this.drawSidebar()) {
            Scissor.enable(this.pageListLeft, this.top, this.pageListRight - this.pageListLeft, this.bottom - this.top);
            int pagesListHeight = this.getTotalPagesListHeight();
            int pagesListY = this.top - (int)this.pageListScrollAmount;
            if (pagesListHeight < this.bottom - this.top) {
                pagesListY = this.top + (this.bottom - this.top - pagesListHeight) / 2;
            }
            this.hoveredPage = my >= this.top && my <= this.bottom ? this.drawPagesListItems(this.pageListLeft + 8 - 4, pagesListY, this.pageListRight - 8, mx, my) : this.drawPagesListItems(this.pageListLeft + 8 - 4, pagesListY, this.pageListRight - 8, -1, -1);
            Scissor.disable();
        }
        GLRenderer.pushFrame();
        GLRenderer.setShader(Shaders.COLOR);
        GLRenderer.enableState(State.BLEND);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        int fadeDist = 4;
        TessellatorShader tessellator = GLRenderer.getTessellator();
        if (this.drawSidebar()) {
            tessellator.startDrawingQuads();
            tessellator.setColor2i(0, 0);
            tessellator.addVertexWithUV(this.pageListLeft, this.top + fadeDist, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(this.pageListRight, this.top + fadeDist, 0.0, 1.0, 1.0);
            tessellator.setColor2i(0, 255);
            tessellator.addVertexWithUV(this.pageListRight, this.top, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(this.pageListLeft, this.top, 0.0, 0.0, 0.0);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setColor2i(0, 255);
            tessellator.addVertexWithUV(this.pageListLeft, this.bottom, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(this.pageListRight, this.bottom, 0.0, 1.0, 1.0);
            tessellator.setColor2i(0, 0);
            tessellator.addVertexWithUV(this.pageListRight, this.bottom - fadeDist, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(this.pageListLeft, this.bottom - fadeDist, 0.0, 0.0, 0.0);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setColor2i(0, 0);
            tessellator.addVertexWithUV(this.viewportLeft, this.top + fadeDist, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(this.viewportRight, this.top + fadeDist, 0.0, 1.0, 1.0);
            tessellator.setColor2i(0, 255);
            tessellator.addVertexWithUV(this.viewportRight, this.top, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(this.viewportLeft, this.top, 0.0, 0.0, 0.0);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setColor2i(0, 255);
            tessellator.addVertexWithUV(this.viewportLeft, this.bottom, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(this.viewportRight, this.bottom, 0.0, 1.0, 1.0);
            tessellator.setColor2i(0, 0);
            tessellator.addVertexWithUV(this.viewportRight, this.bottom - fadeDist, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(this.viewportLeft, this.bottom - fadeDist, 0.0, 0.0, 0.0);
            tessellator.draw();
        } else {
            tessellator.startDrawingQuads();
            tessellator.setColor2i(0, 0);
            tessellator.addVertexWithUV(0.0, this.top + fadeDist, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(this.width, this.top + fadeDist, 0.0, 1.0, 1.0);
            tessellator.setColor2i(0, 255);
            tessellator.addVertexWithUV(this.width, this.top, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(0.0, this.top, 0.0, 0.0, 0.0);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setColor2i(0, 255);
            tessellator.addVertexWithUV(0.0, this.bottom, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(this.width, this.bottom, 0.0, 1.0, 1.0);
            tessellator.setColor2i(0, 0);
            tessellator.addVertexWithUV(this.width, this.bottom - fadeDist, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(0.0, this.bottom - fadeDist, 0.0, 0.0, 0.0);
            tessellator.draw();
        }
        GLRenderer.popFrame();
        if (this.hoveredAchievement != null) {
            this.drawAchievementToolTip(this.hoveredAchievement, mx, my);
        }
        if (this.drawSidebar()) {
            this.drawPagesListScrollBar(mx, my);
            if (this.hoveredPage != null) {
                String msg = this.hoveredPage.getDescription() + "\n" + String.valueOf(TextFormatting.LIGHT_GRAY) + I18n.getInstance().translateKeyAndFormat("gui.achievements.label.completion", Math.round(this.hoveredPage.getCompletionFraction(this.statsCounter) * 100.0) + "%");
                this.tooltip.render(msg, mx, my, 8, -4, 120, -1, true);
            }
        }
        this.renderLabels();
        GLRenderer.enableState(State.DEPTH_TEST);
        this.hoveredAchievement = null;
        this.hoveredPage = null;
    }

    @Override
    public void tick() {
        this.oldShiftX = this.targetShiftX;
        this.oldShiftY = this.targetShiftY;
        double xDiff = this.currentShiftX - this.targetShiftX;
        double yDiff = this.currentShiftY - this.targetShiftY;
        if (xDiff * xDiff + yDiff * yDiff < 4.0) {
            this.targetShiftX += xDiff;
            this.targetShiftY += yDiff;
        } else {
            this.targetShiftX += xDiff * 0.85;
            this.targetShiftY += yDiff * 0.85;
        }
    }

    protected void renderLabels() {
        this.drawStringCenteredNoShadow(this.fontRenderer, I18n.getInstance().translateKey("gui.achievements.label.title"), this.width / 2, 5, 0xFFFFFF);
    }

    protected void renderAchievementsPanel(int mouseX, int mouseY, float partialTick) {
        double shiftX = MathHelper.lerp(this.oldShiftX, this.targetShiftX, (double)partialTick);
        double shiftY = MathHelper.lerp(this.oldShiftY, this.targetShiftY, (double)partialTick);
        shiftX = MathHelper.clamp(shiftX, this.shiftMinX, this.shiftMaxX);
        shiftY = MathHelper.clamp(shiftY, this.shiftMinY, this.shiftMaxY);
        this.zLevel = 0.0f;
        GLRenderer.setDepthFunc(CompareFunc.GREATER_EQUAL);
        GLRenderer.pushFrame();
        GLRenderer.modelM4f().translate(0.0f, 0.0f, -200.0f);
        Scissor.enable(this.viewportLeft, this.viewportTop, this.viewportWidth, this.viewportHeight);
        GLRenderer.globalSetLightEnabled(false);
        this.drawRectDouble(this.viewportLeft, this.viewportTop, this.viewportRight, this.viewportBottom, 0xFF000000 | this.currentPage.backgroundColor());
        GLRenderer.pushFrame();
        this.drawBackgroundTiles(shiftX, shiftY);
        GLRenderer.enableState(State.DEPTH_TEST);
        GLRenderer.setDepthFunc(CompareFunc.LESS_EQUAL);
        this.drawConnectingLines(mouseX, mouseY, shiftX, shiftY);
        Lighting.enableInventoryLight();
        GLRenderer.globalSetLightEnabled(false);
        this.hoveredAchievement = this.drawAchievementIcons(mouseX, mouseY, shiftX, shiftY);
        GLRenderer.popFrame();
        GLRenderer.disableState(State.DEPTH_TEST);
        GLRenderer.enableState(State.BLEND);
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        Scissor.disable();
        GLRenderer.popFrame();
        this.zLevel = 0.0f;
        GLRenderer.setDepthFunc(CompareFunc.LESS_EQUAL);
        GLRenderer.disableState(State.DEPTH_TEST);
    }

    private void drawBackgroundTiles(double shiftX, double shiftY) {
        double zoom = this.viewportZoom;
        TextureRegistry.worldAtlas.bind();
        int offset = 288;
        int viewTileX = (MathHelper.floor(shiftX) + 288) / 16;
        int viewTileY = (MathHelper.floor(shiftY) + 288) / 16;
        double remainderX = (shiftX + 288.0) % 16.0;
        double remainderY = (shiftY + 288.0) % 16.0;
        Random random = new Random();
        int tilesWide = (int)((double)this.viewportWidth / (16.0 * zoom) + 2.0);
        int tilesTall = (int)((double)this.viewportHeight / (16.0 * zoom) + 2.0);
        int orgX = -tilesWide / 2 - 1;
        int orgY = -tilesTall / 2 - 1;
        int endX = tilesWide / 2 + 1;
        int endY = tilesTall / 2 + 1;
        tilesWide = endX - orgX;
        tilesTall = endY - orgY;
        boolean dirty = false;
        if (viewTileX != this.lastTileX || viewTileY != this.lastTileY || tilesWide != this.lastTilesWide || tilesTall != this.lastTilesTall) {
            this.lastTileX = viewTileX;
            this.lastTileY = viewTileY;
            this.lastTilesWide = tilesWide;
            this.lastTilesTall = tilesTall;
            dirty = true;
            for (BGLayer layer : this.layers) {
                layer.resize(tilesWide, tilesTall);
            }
            long worldSeed = this.mc.currentWorld == null ? 0L : this.mc.currentWorld.getRandomSeed();
            for (int _y = 0; _y < tilesTall; ++_y) {
                for (int _x = 0; _x < tilesWide; ++_x) {
                    int tileX = orgX + _x + viewTileX;
                    int tileY = orgY + _y + viewTileY;
                    random.setSeed(worldSeed);
                    long l1 = random.nextLong();
                    random.setSeed(tileX);
                    long l2 = random.nextLong();
                    random.setSeed(tileY);
                    long l3 = random.nextLong();
                    long seed = Objects.hash(l1, l2, l3 ^ 0xFFFFFFFFFFFFFFFFL);
                    for (BGLayer layer : this.layers) {
                        random.setSeed(seed);
                        IconCoordinate fore = this.currentPage.getBackgroundTile(this, layer.id, random, tileX, tileY);
                        layer.put(fore, _x, _y);
                    }
                }
            }
            for (BGLayer layer : this.layers) {
                random.setSeed(worldSeed);
                this.currentPage.postProcessBackground(this, random, layer, orgX + viewTileX, orgY + viewTileY);
            }
        }
        if (dirty) {
            for (int renderpass = 0; renderpass < 2; ++renderpass) {
                TessellatorShader t = GLRenderer.getTessellator();
                if (renderpass == 0) {
                    t.startDrawingQuads();
                } else {
                    t.startDrawing(DrawMode.TRIANGLES);
                }
                for (int _y = 0; _y < tilesTall; ++_y) {
                    int tileY = orgY + _y + viewTileY;
                    float brightness = 0.6f - (float)tileY / 25.0f * 0.3f;
                    for (int _x = 0; _x < tilesWide; ++_x) {
                        int tileX = orgX + _x + viewTileX;
                        for (int i = this.layers.length - 1; i >= 0; --i) {
                            BGLayer topLayer = this.getLayer(i);
                            IconCoordinate fore = topLayer.get(_x, _y);
                            IconCoordinate next = null;
                            if (i - 1 >= 0) {
                                BGLayer nextLayer = this.getLayer(i - 1);
                                next = nextLayer.get(_x, _y);
                            }
                            boolean bottom = false;
                            boolean top = false;
                            boolean left = false;
                            boolean right = false;
                            boolean topLeft = false;
                            boolean topRight = false;
                            boolean bottomLeft = false;
                            boolean bottomRight = false;
                            if (fore != null && next == null && i - 1 >= 0) {
                                BGLayer nextLayer = this.getLayer(i - 1);
                                top = nextLayer.get(_x, _y - 1) != null;
                                left = nextLayer.get(_x - 1, _y) != null;
                                right = nextLayer.get(_x + 1, _y) != null;
                                bottom = nextLayer.get(_x, _y + 1) != null;
                                topLeft = nextLayer.get(_x - 1, _y - 1) != null;
                                topRight = nextLayer.get(_x + 1, _y - 1) != null;
                                bottomLeft = nextLayer.get(_x - 1, _y + 1) != null;
                                bottomRight = nextLayer.get(_x + 1, _y + 1) != null;
                            }
                            double iconLeft = _x * 16;
                            double iconTop = _y * 16;
                            double iconWidth = 16.0;
                            double iconHeight = 16.0;
                            if (renderpass == 0) {
                                if (fore == null) continue;
                                float shadowScale = (float)Math.pow(0.65f, i);
                                if (next != null) {
                                    shadowScale *= 0.5f;
                                }
                                t.setColor4f(brightness * shadowScale, brightness * shadowScale, brightness * shadowScale, 1.0f);
                                this.addGuiIconDouble(t, iconLeft, iconTop, iconWidth, iconHeight, fore);
                                continue;
                            }
                            double off = 0.0;
                            double fadeDist = 6.0 * zoom;
                            int shadowDarkness = 128;
                            if (top) {
                                t.setColor2i(0, 0);
                                t.addVertex(iconLeft - 0.0, iconTop + fadeDist + 0.0, 0.0);
                                t.setColor2i(0, 0);
                                t.addVertex(iconLeft + iconWidth + 0.0, iconTop + fadeDist + 0.0, 0.0);
                                t.setColor2i(0, shadowDarkness);
                                t.addVertex(iconLeft - 0.0, iconTop - 0.0, 0.0);
                                t.setColor2i(0, shadowDarkness);
                                t.addVertex(iconLeft - 0.0, iconTop - 0.0, 0.0);
                                t.setColor2i(0, 0);
                                t.addVertex(iconLeft + iconWidth + 0.0, iconTop + fadeDist + 0.0, 0.0);
                                t.setColor2i(0, shadowDarkness);
                                t.addVertex(iconLeft + iconWidth + 0.0, iconTop - 0.0, 0.0);
                            }
                            if (left) {
                                t.setColor2i(0, 0);
                                t.addVertex(iconLeft + fadeDist + 0.0, iconTop + iconHeight + 0.0, 0.0);
                                t.setColor2i(0, 0);
                                t.addVertex(iconLeft + fadeDist + 0.0, iconTop - 0.0, 0.0);
                                t.setColor2i(0, shadowDarkness);
                                t.addVertex(iconLeft - 0.0, iconTop + iconHeight + 0.0, 0.0);
                                t.setColor2i(0, shadowDarkness);
                                t.addVertex(iconLeft - 0.0, iconTop + iconHeight + 0.0, 0.0);
                                t.setColor2i(0, 0);
                                t.addVertex(iconLeft + fadeDist + 0.0, iconTop - 0.0, 0.0);
                                t.setColor2i(0, shadowDarkness);
                                t.addVertex(iconLeft - 0.0, iconTop - 0.0, 0.0);
                            }
                            if (bottom) {
                                t.setColor2i(0, 0);
                                t.addVertex(iconLeft + iconWidth + 0.0, iconTop + iconHeight - fadeDist + 0.0, 0.0);
                                t.setColor2i(0, 0);
                                t.addVertex(iconLeft - 0.0, iconTop + iconHeight - fadeDist + 0.0, 0.0);
                                t.setColor2i(0, shadowDarkness);
                                t.addVertex(iconLeft + iconWidth + 0.0, iconTop + iconHeight - 0.0, 0.0);
                                t.setColor2i(0, shadowDarkness);
                                t.addVertex(iconLeft + iconWidth + 0.0, iconTop + iconHeight - 0.0, 0.0);
                                t.setColor2i(0, 0);
                                t.addVertex(iconLeft - 0.0, iconTop + iconHeight - fadeDist + 0.0, 0.0);
                                t.setColor2i(0, shadowDarkness);
                                t.addVertex(iconLeft - 0.0, iconTop + iconHeight - 0.0, 0.0);
                            }
                            if (right) {
                                t.setColor2i(0, 0);
                                t.addVertex(iconLeft + iconWidth - fadeDist + 0.0, iconTop - 0.0, 0.0);
                                t.setColor2i(0, 0);
                                t.addVertex(iconLeft + iconWidth - fadeDist + 0.0, iconTop + iconHeight + 0.0, 0.0);
                                t.setColor2i(0, shadowDarkness);
                                t.addVertex(iconLeft + iconWidth - 0.0, iconTop - 0.0, 0.0);
                                t.setColor2i(0, shadowDarkness);
                                t.addVertex(iconLeft + iconWidth - 0.0, iconTop - 0.0, 0.0);
                                t.setColor2i(0, 0);
                                t.addVertex(iconLeft + iconWidth - fadeDist + 0.0, iconTop + iconHeight + 0.0, 0.0);
                                t.setColor2i(0, shadowDarkness);
                                t.addVertex(iconLeft + iconWidth - 0.0, iconTop + iconHeight + 0.0, 0.0);
                            }
                            if (topLeft && !left && !top) {
                                t.setColor2i(0, 0);
                                t.addVertex(iconLeft - 0.0, iconTop + fadeDist + 0.0, 0.0);
                                t.addVertex(iconLeft + fadeDist + 0.0, iconTop - 0.0, 0.0);
                                t.setColor2i(0, shadowDarkness);
                                t.addVertex(iconLeft - 0.0, iconTop - 0.0, 0.0);
                            }
                            if (topRight && !right && !top) {
                                t.setColor2i(0, 0);
                                t.addVertex(iconLeft + iconWidth - fadeDist + 0.0, iconTop - 0.0, 0.0);
                                t.addVertex(iconLeft + iconWidth - 0.0, iconTop + fadeDist + 0.0, 0.0);
                                t.setColor2i(0, shadowDarkness);
                                t.addVertex(iconLeft + iconWidth - 0.0, iconTop - 0.0, 0.0);
                            }
                            if (bottomLeft && !left && !bottom) {
                                t.setColor2i(0, 0);
                                t.addVertex(iconLeft + fadeDist + 0.0, iconTop + iconHeight - 0.0, 0.0);
                                t.addVertex(iconLeft - 0.0, iconTop + iconHeight - fadeDist + 0.0, 0.0);
                                t.setColor2i(0, shadowDarkness);
                                t.addVertex(iconLeft - 0.0, iconTop + iconHeight - 0.0, 0.0);
                            }
                            if (!bottomRight || right || bottom) continue;
                            t.setColor2i(0, 0);
                            t.addVertex(iconLeft + iconWidth - 0.0, iconTop + iconHeight - fadeDist + 0.0, 0.0);
                            t.addVertex(iconLeft + iconWidth - fadeDist + 0.0, iconTop + iconHeight - 0.0, 0.0);
                            t.setColor2i(0, shadowDarkness);
                            t.addVertex(iconLeft + iconWidth - 0.0, iconTop + iconHeight - 0.0, 0.0);
                        }
                    }
                }
                if (renderpass == 0) {
                    if (this.lastBackgroundTileBuf == null) {
                        this.lastBackgroundTileBuf = t.record(GL41.glGenVertexArrays(), GL41.glGenBuffers());
                        continue;
                    }
                    this.lastBackgroundTileBuf = t.record(this.lastBackgroundTileBuf.vao(), this.lastBackgroundTileBuf.vbo());
                    continue;
                }
                this.lastBackgroundShadowBuf = this.lastBackgroundShadowBuf == null ? t.record(GL41.glGenVertexArrays(), GL41.glGenBuffers()) : t.record(this.lastBackgroundShadowBuf.vao(), this.lastBackgroundShadowBuf.vbo());
            }
        }
        double iconLeft = (double)this.viewportLeft + (double)this.viewportWidth / 2.0 + zoom * (double)(orgX * 16) - zoom * remainderX;
        double iconTop = (double)this.viewportTop + (double)this.viewportHeight / 2.0 + zoom * ((double)(orgY * 16) - remainderY);
        GLRenderer.pushFrame();
        GLRenderer.modelM4f().translate((float)iconLeft, (float)iconTop, 0.0f).scale((float)zoom, (float)zoom, 1.0f);
        if (this.lastBackgroundTileBuf != null) {
            TextureRegistry.worldAtlas.bind();
            GLRenderer.render(this.lastBackgroundTileBuf);
        }
        if (this.lastBackgroundShadowBuf != null) {
            GLRenderer.pushFrame();
            GLRenderer.setShader(Shaders.COLOR);
            GLRenderer.enableState(State.BLEND);
            GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
            GLRenderer.render(this.lastBackgroundShadowBuf);
            GLRenderer.popFrame();
        }
        GLRenderer.popFrame();
    }

    public BGLayer getLayer(int layer) {
        if (layer < 0 || layer >= this.layers.length) {
            return null;
        }
        return this.layers[layer];
    }

    private double timeSin(double amplitude, long period) {
        return Math.sin((double)(System.currentTimeMillis() % period) / (double)period * Math.PI * 2.0) * amplitude;
    }

    private void drawConnectingLines(int mouseX, int mouseY, double shiftX, double shiftY) {
        double zoom = this.viewportZoom;
        for (AchievementPage.AchievementEntry entry : this.currentPage.getAchievementEntries()) {
            int color;
            Achievement ach = entry.achievement;
            AchievementPage.AchievementEntry parentEntry = this.currentPage.getEntry(ach.parent);
            if (parentEntry == null || !this.currentPage.hasAchievement(ach) || !this.currentPage.hasAchievement(ach.parent)) continue;
            double childX = (double)this.viewportLeft + (double)this.viewportWidth / 2.0 + ((double)(entry.x * 24) - shiftX + 11.0) * zoom;
            double childY = (double)this.viewportTop + (double)this.viewportHeight / 2.0 + ((double)(entry.y * 24) - shiftY + 11.0) * zoom;
            double parentX = (double)this.viewportLeft + (double)this.viewportWidth / 2.0 + ((double)(parentEntry.x * 24) - shiftX + 11.0) * zoom;
            double parentY = (double)this.viewportTop + (double)this.viewportHeight / 2.0 + ((double)(parentEntry.y * 24) - shiftY + 11.0) * zoom;
            boolean unlocked = this.statsCounter.isUnlocked(ach);
            boolean canUnlock = this.statsCounter.canUnlock(ach);
            double zoomOff = 11.0 * zoom;
            boolean isHovered = false;
            double x = parentX - zoomOff;
            double y = parentY - zoomOff;
            if (mouseX >= 0 && mouseY >= this.viewportTop && mouseX < this.width && mouseY < this.viewportBottom && (double)mouseX >= x && (double)mouseX <= x + 22.0 * zoom && (double)mouseY >= y && (double)mouseY <= y + 22.0 * zoom) {
                isHovered = true;
            }
            x = childX - zoomOff;
            y = childY - zoomOff;
            if (mouseX >= 0 && mouseY >= this.viewportTop && mouseX < this.width && mouseY < this.viewportBottom && (double)mouseX >= x && (double)mouseX <= x + 22.0 * zoom && (double)mouseY >= y && (double)mouseY <= y + 22.0 * zoom) {
                isHovered = true;
            }
            if (unlocked) {
                color = 0xFF000000 | this.currentPage.lineColorUnlocked(isHovered) & 0xFFFFFF;
            } else if (canUnlock) {
                int alpha = this.timeSin(1.0, 600L) >= 0.6 ? 130 : 255;
                color = alpha << 24 | this.currentPage.lineColorCanUnlock(isHovered) & 0xFFFFFF;
            } else {
                color = 0xFF000000 | this.currentPage.lineColorLocked(isHovered) & 0xFFFFFF;
            }
            this.drawLineHorizontalDouble(childX, parentX, childY, color);
            this.drawLineVerticalDouble(parentX, childY, parentY, color);
        }
    }

    @Nullable
    private Achievement drawAchievementIcons(int mouseX, int mouseY, double shiftX, double shiftY) {
        double zoom = this.viewportZoom;
        Achievement hoveredAchievment = null;
        for (AchievementPage.AchievementEntry entry : this.currentPage.getAchievementEntries()) {
            float brightness;
            Achievement ach = entry.achievement;
            double achViewX = (double)this.viewportLeft + (double)this.viewportWidth / 2.0 + ((double)(entry.x * 24) - shiftX) * zoom;
            double achViewY = (double)this.viewportTop + (double)this.viewportHeight / 2.0 + ((double)(entry.y * 24) - shiftY) * zoom;
            if (achViewX < (double)this.viewportLeft - 24.0 * zoom || achViewY < (double)this.viewportTop - 24.0 * zoom || achViewX > (double)this.viewportRight || achViewY > (double)this.viewportBottom) continue;
            if (this.statsCounter.isUnlocked(ach)) {
                brightness = 1.0f;
                GLRenderer.setColor4f(brightness, brightness, brightness, 1.0f);
            } else if (this.statsCounter.canUnlock(ach)) {
                brightness = this.timeSin(1.0, 600L) >= 0.6 ? 0.6f : 0.8f;
                GLRenderer.setColor4f(brightness, brightness, brightness, 1.0f);
            } else {
                brightness = 0.3f;
                GLRenderer.setColor4f(brightness, brightness, brightness, 1.0f);
            }
            this.drawGuiIconDouble(achViewX - 2.0 * zoom, achViewY - 2.0 * zoom, 26.0 * zoom, 26.0 * zoom, this.currentPage.getAchievementIcon(ach));
            if (!this.statsCounter.canUnlock(ach)) {
                brightness = 0.1f;
                GLRenderer.setColor4f(brightness, brightness, brightness, 1.0f);
            }
            GLRenderer.pushFrame();
            GLRenderer.globalSetLightEnabled(true);
            GLRenderer.enableState(State.CULL_FACE);
            Item achievementItem = Item.itemsList[ach.iconItemId];
            GLRenderer.modelM4f().translate((float)(achViewX + 3.0 * zoom), (float)(achViewY + 3.0 * zoom), 0.0f);
            GLRenderer.modelM4f().scale((float)zoom, (float)zoom, 1.0f);
            ((ItemModel)ItemModelDispatcher.getInstance().getDispatch(achievementItem)).renderGui(GLRenderer.getTessellator(), null, achievementItem.getDefaultStack(), 0, 0, LightmapHelper.getLightmapCoord(15, 15), 1.0f);
            GLRenderer.globalSetLightEnabled(false);
            GLRenderer.popFrame();
            GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            if (mouseX < 0 || mouseY < this.viewportTop || mouseX >= this.width || mouseY >= this.viewportBottom || !((double)mouseX >= achViewX) || !((double)mouseX <= achViewX + 22.0 * zoom) || !((double)mouseY >= achViewY) || !((double)mouseY <= achViewY + 22.0 * zoom)) continue;
            hoveredAchievment = ach;
        }
        return hoveredAchievment;
    }

    private void drawAchievementToolTip(Achievement achievement, int mouseX, int mouseY) {
        int[] boxRender;
        String name = achievement.getStatName();
        String desc = achievement.getDescription();
        int padding = this.tooltip.getPadding();
        if (this.statsCounter.canUnlock(achievement)) {
            boxWidth = Math.max(MathHelper.ceil(this.fontRenderer.stringWidthDouble(name)), 120);
            int boxHeight = MathHelper.ceil(this.fontRenderer.heightOfConstrainedChars(desc, boxWidth));
            if (this.statsCounter.isUnlocked(achievement)) {
                boxHeight += 12;
            }
            boxRender = this.tooltip.drawBackground(mouseX, mouseY, 8, -4, boxWidth + 3, boxHeight + 3 + 12);
            this.fontRenderer.renderWidthConstrained(desc, boxRender[0] + padding, boxRender[1] + 12 + padding, boxWidth).setColor(-6250336).call();
            if (this.statsCounter.isUnlocked(achievement)) {
                this.drawStringShadow(this.fontRenderer, I18n.getInstance().translateKey("gui.achievements.label.taken"), boxRender[0] + padding, boxRender[1] + boxHeight + 8 + padding, -7302913);
            }
        } else {
            boxWidth = Math.max(MathHelper.ceil(this.fontRenderer.stringWidthDouble(name)), 120);
            String msg = I18n.getInstance().translateKeyAndFormat("gui.achievements.label.requires", achievement.parent.getStatName());
            int boxHeight = MathHelper.ceil(this.fontRenderer.heightOfConstrainedChars(msg, boxWidth));
            boxRender = this.tooltip.drawBackground(mouseX, mouseY, 8, -4, boxWidth + 3, boxHeight + 3 + 12);
            this.fontRenderer.renderWidthConstrained(msg, boxRender[0] + padding, boxRender[1] + 12 + padding, boxWidth).setColor(-9416624).call();
        }
        int color = this.statsCounter.canUnlock(achievement) ? achievement.getType().colorName : achievement.getType().colorNameLocked;
        this.drawStringShadow(this.fontRenderer, name, boxRender[0] + padding, boxRender[1] + padding, color);
    }

    public boolean drawSidebar() {
        return AchievementPageRegistry.getInstance().getPages().size() > 1;
    }

    private void scrollPagesList(float amount) {
        if (amount == 0.0f) {
            return;
        }
        this.pageListScrollAmount += amount;
        this.onScrollPagesList();
    }

    private void onScrollPagesList() {
        int totalPagesListHeight = this.getTotalPagesListHeight();
        if (this.pageListScrollAmount < 0.0f || this.pagesListScrollRegionHeight > totalPagesListHeight) {
            this.pageListScrollAmount = 0.0f;
        } else if (this.pageListScrollAmount > (float)(totalPagesListHeight - this.pagesListScrollRegionHeight)) {
            this.pageListScrollAmount = totalPagesListHeight - this.pagesListScrollRegionHeight;
        }
    }

    private int getTotalPagesListHeight() {
        return 20 * AchievementPageRegistry.getInstance().getPages().size();
    }

    @Nullable
    private AchievementPage drawPagesListItems(int x, int y, int width, int mouseX, int mouseY) {
        int y2 = y;
        AchievementPage pageHovered = null;
        for (AchievementPage page : AchievementPageRegistry.getInstance().getPages()) {
            String name = page.getName();
            int textColor = -8421505;
            if (page == this.currentPage) {
                textColor = -1;
            }
            if (mouseX >= x && mouseX < x + width && mouseY >= y2 && mouseY < y2 + 20) {
                textColor = -96;
                pageHovered = page;
            }
            this.renderItem.render(page.getIcon(), x, y2 + 10 - 9);
            if (page.getCompletionFraction(this.statsCounter) >= 1.0) {
                GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                this.drawGuiIcon(x + 8, y2 + 10 - 9 + 8, 11, 11, TextureRegistry.getTexture("minecraft:gui/screen/achievement/star"));
            }
            this.drawStringShadow(this.fontRenderer, name, x + 19, y2 + 10 - 4, textColor);
            y2 += 20;
        }
        return pageHovered;
    }

    protected void drawPagesListScrollBar(int mouseX, int mouseY) {
        float totalPagesListHeight = this.getTotalPagesListHeight();
        float scrollBarHeightPercent = (float)this.pagesListScrollRegionHeight / totalPagesListHeight;
        if (scrollBarHeightPercent > 1.0f) {
            return;
        }
        GLRenderer.pushFrame();
        GLRenderer.setShader(Shaders.COLOR);
        int scrollBarX = this.pageListRight - 6;
        int scrollBarHeightPx = (int)(scrollBarHeightPercent * (float)this.pagesListScrollRegionHeight);
        if (scrollBarHeightPx < 32) {
            scrollBarHeightPx = 32;
        }
        float scrollPercent = this.pageListScrollAmount / (totalPagesListHeight - (float)this.pagesListScrollRegionHeight);
        int scrollBarY = (int)((float)this.top + (float)(this.pagesListScrollRegionHeight - scrollBarHeightPx) * scrollPercent);
        TessellatorShader t = GLRenderer.getTessellator();
        t.startDrawingQuads();
        t.setColorOpaque3i(0, 0, 0);
        t.drawRectangle(scrollBarX, this.top, 6, this.pagesListScrollRegionHeight);
        t.setColor2i(0x808080, 255);
        t.drawRectangle(scrollBarX, scrollBarY, 6, scrollBarHeightPx);
        t.setColor2i(0xC0C0C0, 255);
        t.drawRectangle(scrollBarX + 1, scrollBarY, 5, scrollBarHeightPx - 1);
        t.draw();
        GLRenderer.popFrame();
        if (this.clickX != null && this.clickY != null) {
            if (this.clickX >= scrollBarX && this.clickY >= this.top && this.clickX <= scrollBarX + 6 && this.clickY < this.bottom) {
                if (this.oldPagesListScrollAmount == null) {
                    this.oldPagesListScrollAmount = Float.valueOf(this.pageListScrollAmount);
                }
                this.pageListScrollAmount = this.oldPagesListScrollAmount.floatValue() + (float)(this.clickY - mouseY) * (1.0f / scrollBarHeightPercent) * -1.0f;
                this.onScrollPagesList();
            }
        } else {
            this.oldPagesListScrollAmount = null;
        }
    }

    private void overlayBackground(int minX, int maxX, int minY, int maxY, int color) {
        TessellatorShader tessellator = GLRenderer.getTessellator();
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/background.png").bind();
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        float scale = 32.0f;
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque1i(color);
        tessellator.addVertexWithUV(minX, maxY, 0.0, (float)minX / scale, (float)maxY / scale);
        tessellator.addVertexWithUV(maxX, maxY, 0.0, (float)maxX / scale, (float)maxY / scale);
        tessellator.setColorOpaque1i(color);
        tessellator.addVertexWithUV(maxX, minY, 0.0, (float)maxX / scale, (float)minY / scale);
        tessellator.addVertexWithUV(minX, minY, 0.0, (float)minX / scale, (float)minY / scale);
        tessellator.draw();
    }

    public static class BGLayer {
        private IconCoordinate[] data;
        private int width;
        private int height;
        public final int id;

        public BGLayer(int id) {
            this.id = id;
            this.data = new IconCoordinate[0];
            this.width = 0;
            this.height = 0;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public IconCoordinate[] getData() {
            return this.data;
        }

        protected void resize(int width, int height) {
            this.width = width;
            this.height = height;
            this.data = new IconCoordinate[width * height];
        }

        public void put(IconCoordinate coordinate, int x, int y) {
            if (x < 0) {
                return;
            }
            if (y < 0) {
                return;
            }
            if (x >= this.width) {
                return;
            }
            if (y >= this.height) {
                return;
            }
            this.data[this.makeIndex((int)x, (int)y)] = coordinate;
        }

        public IconCoordinate get(int x, int y) {
            if (x < 0) {
                return null;
            }
            if (y < 0) {
                return null;
            }
            if (x >= this.width) {
                return null;
            }
            if (y >= this.height) {
                return null;
            }
            return this.data[this.makeIndex(x, y)];
        }

        private int makeIndex(int x, int y) {
            return x % this.width + y * this.width;
        }
    }
}

