/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockModelCobbledNetherrack<T extends BlockLogic>
extends BlockModelStandard<T> {
    private final IconCoordinate ashSide = TextureRegistry.getTexture("minecraft:block/cobbled_netherrack/ashen_side");

    public BlockModelCobbledNetherrack(Block<T> block) {
        super(block);
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTexture(@NotNull WorldSource source, @NotNull TilePosc tilePos, @NotNull Side side) {
        Material material = source.getBlockMaterial(tilePos.up(new TilePos()));
        if ((material == Materials.TOP_ASH || material == Materials.ASH) && side.getAxis() != Axis.Y) {
            return this.ashSide;
        }
        return super.getBlockTexture(source, tilePos, side);
    }
}

