/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBdc;

public class BlockModelGrass<T extends BlockLogic>
extends BlockModelStandard<T> {
    public static boolean fancyGrass = false;
    public static boolean useOverlay = false;
    private static final IconCoordinate[] overlayIndices = new IconCoordinate[]{null, null, TextureRegistry.getTexture("minecraft:block/grass/side_overlay"), TextureRegistry.getTexture("minecraft:block/grass/side_overlay"), TextureRegistry.getTexture("minecraft:block/grass/side_overlay"), TextureRegistry.getTexture("minecraft:block/grass/side_overlay")};
    protected IconCoordinate snowSide = TextureRegistry.getTexture("minecraft:block/grass/snowy_side");

    public BlockModelGrass(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        boolean didRender;
        AABBdc bounds = this.block.getBounds();
        boolean bl = didRender = this.isRetro() ? renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos, 1.0f, 1.0f, 1.0f) : renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
        if (!(!fancyGrass || this.retroBlockTextures.hasTexture() && this.isRetro())) {
            useOverlay = true;
            didRender |= renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
            useOverlay = false;
        }
        return didRender;
    }

    @Override
    public void renderStandalone(@NotNull TessellatorGeneral tessellator, int metadata, int lightmapCoord) {
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        AABBdc bounds = this.getBlockBoundsForItemRender();
        tessellator.offsetTranslation(-0.5, -0.5, -0.5);
        tessellator.startDrawingQuads();
        tessellator.setColor1i(-1);
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        renderBlocks.renderBottomFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, metadata));
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        renderBlocks.renderNorthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.NORTH, metadata));
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        renderBlocks.renderSouthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.SOUTH, metadata));
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        renderBlocks.renderWestFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.WEST, metadata));
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        renderBlocks.renderEastFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.EAST, metadata));
        tessellator.setColor1i(this.getStandaloneTintColor(metadata));
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        renderBlocks.renderTopFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.TOP, metadata));
        if (fancyGrass && !this.isRetro()) {
            useOverlay = true;
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            renderBlocks.renderNorthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.NORTH, metadata));
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            renderBlocks.renderSouthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.SOUTH, metadata));
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            renderBlocks.renderWestFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.WEST, metadata));
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            renderBlocks.renderEastFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.EAST, metadata));
            useOverlay = false;
        }
        tessellator.draw();
        tessellator.offsetTranslation(0.5, 0.5, 0.5);
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTexture(@NotNull WorldSource source, @NotNull TilePosc tilePos, @NotNull Side side) {
        Material material = source.getBlockMaterial(tilePos.up(new TilePos()));
        if ((material == Materials.TOP_SNOW || material == Materials.SNOW) && side.getAxis() != Axis.Y) {
            return this.snowSide;
        }
        return super.getBlockTexture(source, tilePos, side);
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTextureFromSideAndMetadata(@NotNull Side side, int data) {
        if (useOverlay) {
            return overlayIndices[side.getId()];
        }
        return super.getBlockTextureFromSideAndMetadata(side, data);
    }

    @Override
    public boolean shouldSideBeColored(@NotNull WorldSource worldSource, @NotNull TilePosc tilePos, @NotNull Side side, int meta) {
        Material material = worldSource.getBlockMaterial(tilePos.up(new TilePos()));
        if (material == Materials.TOP_SNOW || material == Materials.SNOW) {
            return false;
        }
        return useOverlay || side == Side.TOP;
    }
}

