/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.joml.primitives.AABBdc;

public class BlockModelLayer<T extends BlockLogic>
extends BlockModelStandard<T> {
    public BlockModelLayer(Block<T> block) {
        super(block);
        this.withCustomItemBounds(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    }

    @Override
    public void renderStandalone(@NotNull TessellatorGeneral tessellator, int metadata, int lightmapCoord) {
        tessellator.offsetTranslation(0.0, 0.25, 0.0);
        super.renderStandalone(tessellator, metadata, lightmapCoord);
        tessellator.offsetTranslation(0.0, -0.25, 0.0);
    }

    @Override
    public boolean shouldSideBeRendered(@NotNull WorldSource source, @NotNull AABBdc bounds, @NotNull TilePos tilePos, @NotNull Side side, int meta) {
        if (!side.isVertical() && source.getBlockId(tilePos) == this.block.id() && source.getBlockData(tilePos) == meta) {
            return false;
        }
        return super.shouldSideBeRendered(source, bounds, tilePos, side);
    }
}

