/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.client.render.renderer.BlendFactor;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.State;
import net.minecraft.core.entity.monster.MobCreeper;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.models.entity.BoneTransform;
import org.useless.dragonfly.models.entity.StaticEntityModel;

public class MobRendererCreeper
extends MobRenderer<MobCreeper> {
    public MobRendererCreeper(float shadowSize) {
        super(shadowSize);
    }

    @Override
    protected int getOverlayColor(@NotNull MobCreeper creeper, float brightness, float partialTick) {
        float step = creeper.getSwelling(partialTick);
        if ((int)(step * 10.0f) % 2 == 0) {
            return 0;
        }
        return Color.intToIntARGB(MathHelper.clamp((int)(step * 0.2f * 255.0f), 0, 255), 255, 255, 255);
    }

    @Override
    @Nullable
    protected StaticEntityModel getAndSetupModelForLayer(@NotNull MobCreeper creeper, float brightness, float partialTick, int layer) {
        StaticEntityModel model;
        if (layer == 1) {
            model = this.getModel("charged");
            this.bindTexture("/assets/minecraft/textures/armor/power.png");
            float ticks = (float)creeper.tickCount + partialTick;
            GLRenderer.textureM4f().identity();
            float _x = ticks * 0.01f;
            float _y = ticks * 0.01f;
            GLRenderer.textureM4f().translate(_x, _y, 0.0f);
            GLRenderer.enableState(State.BLEND);
            GLRenderer.setColor4f(0.5f, 0.5f, 0.5f, 1.0f);
            GLRenderer.globalSetLightEnabled(false);
            GLRenderer.setBlendFunc(BlendFactor.ONE, BlendFactor.ONE);
        } else {
            if (layer == 2) {
                GLRenderer.textureM4f().identity();
                GLRenderer.globalSetLightEnabled(true);
                GLRenderer.disableState(State.BLEND);
                return null;
            }
            model = this.getModel("main");
        }
        model.resetBones();
        float bodyYaw = this.getBodyYaw(creeper, partialTick);
        float headYaw = this.getHeadYaw(creeper, partialTick) - bodyYaw;
        float headPitch = this.getHeadPitch(creeper, partialTick);
        float limbSwing = this.getLimbSwing(creeper, partialTick);
        float limbYaw = this.getLimbYaw(creeper, partialTick);
        BoneTransform body = model.getTransform("body");
        BoneTransform head = model.getTransform("head");
        head.rotY = headYaw;
        head.rotX = headPitch;
        BoneTransform leg0 = model.getTransform("leg0");
        BoneTransform leg1 = model.getTransform("leg1");
        BoneTransform leg2 = model.getTransform("leg2");
        BoneTransform leg3 = model.getTransform("leg3");
        leg0.rotX = MathHelper.cos(limbSwing * 0.6662f) * 1.4f * limbYaw;
        leg1.rotX = MathHelper.cos(limbSwing * 0.6662f + (float)Math.PI) * 1.4f * limbYaw;
        leg2.rotX = MathHelper.cos(limbSwing * 0.6662f + (float)Math.PI) * 1.4f * limbYaw;
        leg3.rotX = MathHelper.cos(limbSwing * 0.6662f) * 1.4f * limbYaw;
        float g = creeper.getSwelling(partialTick);
        float wobble = 1.0f + MathHelper.sin(g * 100.0f) * g * 0.01f;
        g = MathHelper.clamp(g, 0.0f, 1.0f);
        g *= g;
        g *= g;
        float s = (1.0f + g * 0.4f) * wobble;
        float hs = (1.0f + g * 0.1f) / wobble;
        body.scaleX = s;
        body.scaleY = hs;
        body.scaleZ = s;
        return model;
    }

    @Override
    protected int maxRenderLayer(@NotNull MobCreeper entity) {
        return entity.getPowered() ? 2 : 0;
    }
}

