/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicTransparent;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.IPainted;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;

public class BlockLogicPortal
extends BlockLogicTransparent
implements IPainted {
    public static final int MAX_PORTAL_SIZE = 32;
    public static final int MASK_COLOR = 240;
    public static final int MASK_ROTATION = 3;
    public static final int MASK_COLOR_SET = 8;
    public static final int ORIENTATION_X = 0;
    public static final int ORIENTATION_Z = 1;
    public static final int ORIENTATION_Y = 2;
    @NotNull
    public final Dimension targetDimension;
    @NotNull
    public final Block<?> portalFrame;
    @NotNull
    public final Block<?> portalTrigger;

    public BlockLogicPortal(@NotNull Block<?> block, @NotNull Dimension targetDimension, @NotNull Block<?> portalMaterial, @NotNull Block<?> portalTrigger) {
        super(block, Materials.PORTAL);
        this.targetDimension = targetDimension;
        this.portalFrame = portalMaterial;
        this.portalTrigger = portalTrigger;
    }

    @Override
    @Nullable
    public AABBdc getCollisionAABB(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return null;
    }

    @Override
    @NotNull
    public AABBdc getBoundsFromState(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        int meta = source.getBlockData(tilePos);
        if ((meta & 1) > 0) {
            float f1 = 0.125f;
            float f3 = 0.5f;
            return new AABBd(0.5f - f1, 0.0, 0.5f - f3, 0.5f + f1, 1.0, 0.5f + f3);
        }
        float f = 0.5f;
        float f2 = 0.125f;
        return new AABBd(0.5f - f, 0.0, 0.5f - f2, 0.5f + f, 1.0, 0.5f + f2);
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return PartialSupport.INSTANCE;
    }

    @Nullable
    public Bounds getPortalDims(@NotNull World world, @NotNull TilePosc tilePos, boolean expectMiddle) {
        return this.getPortalDims(world, tilePos, false, expectMiddle);
    }

    @Nullable
    public Bounds getPortalDims(@NotNull World world, @NotNull TilePosc tilePos, boolean swapOrientation, boolean expectMiddle) {
        int id;
        int ry;
        int ra;
        int rz;
        int rx;
        int ry2;
        int maxDims = 32;
        TilePos p = new TilePos(tilePos);
        TilePos tempPos = new TilePos(tilePos);
        int maxBoundA = 0;
        int maxBoundY = 0;
        boolean foundBottom = false;
        Axis axis = Axis.NONE;
        if (world.dimension.portalBlock != null && world.dimension.portalBlock != this.block) {
            return null;
        }
        for (ry2 = 0; ry2 > -32; --ry2) {
            if (world.getBlockId(tempPos.set(p.x, p.y + ry2, p.z)) != this.portalFrame.id()) continue;
            foundBottom = true;
            p.y += ry2;
            break;
        }
        if (!foundBottom) {
            return null;
        }
        ++p.y;
        if (!swapOrientation) {
            for (rx = 0; rx > -32; --rx) {
                if (world.getBlockId(tempPos.set(p.x + rx, p.y, p.z)) != this.portalFrame.id()) continue;
                axis = Axis.X;
                p.x += rx;
                break;
            }
            if (axis == Axis.NONE) {
                for (rz = 0; rz > -32; --rz) {
                    if (world.getBlockId(tempPos.set(p.x, p.y, p.z + rz)) != this.portalFrame.id()) continue;
                    axis = Axis.Z;
                    p.z += rz;
                    break;
                }
            }
        } else {
            for (rz = 0; rz > -32; --rz) {
                if (world.getBlockId(tempPos.set(p.x, p.y, p.z + rz)) != this.portalFrame.id()) continue;
                axis = Axis.Z;
                p.z += rz;
                break;
            }
            if (axis == Axis.NONE) {
                for (rx = 0; rx > -32; --rx) {
                    if (world.getBlockId(tempPos.set(p.x + rx, p.y, p.z)) != this.portalFrame.id()) continue;
                    axis = Axis.X;
                    p.x += rx;
                    break;
                }
            }
        }
        if (axis == Axis.NONE) {
            return null;
        }
        block0 : switch (axis) {
            case X: {
                for (rx = 1; rx < 32; ++rx) {
                    if (world.getBlockId(tempPos.set(p.x + rx, p.y, p.z)) != this.portalFrame.id()) continue;
                    maxBoundA = rx;
                    break block0;
                }
                break;
            }
            default: {
                for (rz = 1; rz < 32; ++rz) {
                    if (world.getBlockId(tempPos.set(p.x, p.y, p.z + rz)) != this.portalFrame.id()) continue;
                    maxBoundA = rz;
                    break block0;
                }
            }
        }
        if (maxBoundA == 0) {
            return swapOrientation ? null : this.getPortalDims(world, tilePos, true, expectMiddle);
        }
        --p.y;
        for (ry2 = 1; ry2 < 32; ++ry2) {
            if (p.y + ry2 >= world.getHeightBlocks()) {
                return swapOrientation ? null : this.getPortalDims(world, tilePos, true, expectMiddle);
            }
            if (world.getBlockId(tempPos.set(p.x + (axis == Axis.X ? 1 : 0), p.y + ry2, p.z + (axis == Axis.Z ? 1 : 0))) != this.portalFrame.id()) continue;
            maxBoundY = ry2;
            break;
        }
        if (maxBoundY == 0) {
            return swapOrientation ? null : this.getPortalDims(world, tilePos, true, expectMiddle);
        }
        for (ra = 0; ra <= maxBoundA; ++ra) {
            for (ry = 0; ry <= maxBoundY; ++ry) {
                if (!(ra == 0 || ra == maxBoundA || ry == 0 || ry == maxBoundY ? world.getBlockId(tempPos.set(p.x + (axis == Axis.X ? ra : 0), p.y + ry, p.z + (axis == Axis.Z ? ra : 0))) != this.portalFrame.id() : (id = world.getBlockId(tempPos.set(p.x + (axis == Axis.X ? ra : 0), p.y + ry, p.z + (axis == Axis.Z ? ra : 0)))) != 0 && id != this.portalTrigger.id() && id != this.block.id())) continue;
                return swapOrientation ? null : this.getPortalDims(world, tilePos, true, expectMiddle);
            }
        }
        if (expectMiddle) {
            for (ra = 1; ra < maxBoundA; ++ra) {
                for (ry = 1; ry < maxBoundY; ++ry) {
                    id = world.getBlockId(tempPos.set(p.x + (axis == Axis.X ? ra : 0), p.y + ry, p.z + (axis == Axis.Z ? ra : 0)));
                    if (id == this.block.id()) continue;
                    return swapOrientation ? null : this.getPortalDims(world, tilePos, true, true);
                }
            }
        }
        return new Bounds(axis, new TilePos(p), maxBoundA, maxBoundY);
    }

    public boolean tryToCreatePortal(@NotNull World world, @NotNull TilePosc tilePos, @Nullable DyeColor color) {
        Bounds bounds;
        if (color == null) {
            color = DyeColor.PURPLE;
        }
        if ((bounds = this.getPortalDims(world, tilePos, false)) == null) {
            return false;
        }
        world.noNeighborUpdate = true;
        switch (bounds.axis) {
            case X: {
                TilePos p = new TilePos();
                for (int ra = 1; ra < bounds.maxBoundA; ++ra) {
                    for (int ry = 1; ry < bounds.maxBoundB; ++ry) {
                        p.x = bounds.pos.x + ra;
                        p.y = bounds.pos.y + ry;
                        p.z = bounds.pos.z;
                        world.setBlockIdData(p, this.block.id(), 0);
                    }
                }
                p.x = bounds.pos.x + 1;
                p.y = bounds.pos.y + 1;
                p.z = bounds.pos.z;
                world.setBlockData(p, 2);
                this.setColor(world, p, color);
                world.markBlocksDirty(p, p.add(bounds.maxBoundA, bounds.maxBoundB, 0, new TilePos()));
                break;
            }
            case Z: {
                TilePos p = new TilePos();
                for (int ra = 1; ra < bounds.maxBoundA; ++ra) {
                    for (int ry = 1; ry < bounds.maxBoundB; ++ry) {
                        p.x = bounds.pos.x;
                        p.y = bounds.pos.y + ry;
                        p.z = bounds.pos.z + ra;
                        world.setBlockIdData(p, this.block.id(), 1);
                    }
                }
                p.x = bounds.pos.x;
                p.y = bounds.pos.y + 1;
                p.z = bounds.pos.z + 1;
                world.setBlockData(p, 3);
                this.setColor(world, p, color);
                world.markBlocksDirty(p, p.add(0, bounds.maxBoundB, bounds.maxBoundA, new TilePos()));
                break;
            }
        }
        world.noNeighborUpdate = false;
        return true;
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePosc tilePos, int id) {
        Bounds bounds = this.getPortalDims(world, tilePos, true);
        if (bounds == null) {
            world.setBlockIdNotify(tilePos, 0);
        }
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        return null;
    }

    @Override
    public void onEntityCollision(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Entity entity) {
        if (entity instanceof EntityItem) {
            EntityItem entityItem = (EntityItem)entity;
            if (entityItem.item != null && entityItem.item.itemID == Items.DYE.id) {
                DyeColor color = DyeColor.colorFromItemMeta(entityItem.item.getMetadata());
                if (this.getColor(world, tilePos) != color) {
                    this.setColor(world, tilePos, color);
                    --entityItem.item.stackSize;
                    if (entityItem.item.stackSize <= 0) {
                        entityItem.remove();
                        return;
                    }
                }
            }
        }
        if (entity.vehicle == null && entity.passenger == null) {
            entity.handlePortal(this.block.id(), this.getColor(world, tilePos));
        }
    }

    @Override
    public void animationTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand) {
        int meta = world.getBlockData(tilePos);
        if ((meta & 2) > 0 && rand.nextInt(20) == 0) {
            world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)tilePos.x() + 0.5, (double)tilePos.y() + 0.5, (double)tilePos.z() + 0.5, "portal.portal", 0.5f, rand.nextFloat() * 0.4f + 0.8f);
        }
        TilePos queryPos = new TilePos();
        for (int l = 0; l < 4; ++l) {
            double px = (double)tilePos.x() + (double)rand.nextFloat();
            double py = (double)tilePos.y() + (double)rand.nextFloat();
            double pz = (double)tilePos.z() + (double)rand.nextFloat();
            int i1 = rand.nextInt(2) * 2 - 1;
            double xd = (rand.nextDouble() - 0.5) * 0.5;
            double yd = (rand.nextDouble() - 0.5) * 0.5;
            double zd = (rand.nextDouble() - 0.5) * 0.5;
            if (world.getBlockId(tilePos.add(Direction.WEST, queryPos)) == this.block.id() || world.getBlockId(tilePos.add(Direction.EAST, queryPos)) == this.block.id()) {
                pz = (double)tilePos.z() + 0.5 + 0.25 * (double)i1;
                zd = (double)rand.nextFloat() * 2.0 * (double)i1;
            } else {
                px = (double)tilePos.x() + 0.5 + 0.25 * (double)i1;
                xd = (double)rand.nextFloat() * 2.0 * (double)i1;
            }
            world.spawnParticle("portal", px, py, pz, xd, yd, zd, this.fromMetadata((int)meta).blockMeta);
        }
    }

    @Override
    @NotNull
    public DyeColor fromMetadata(int meta) {
        if ((meta & 8) == 0) {
            return DyeColor.PURPLE;
        }
        return DyeColor.colorFromBlockMeta((meta & 0xF0) >> 4);
    }

    @Override
    public int toMetadata(@NotNull DyeColor color) {
        return color.blockMeta << 4 & 0xF0;
    }

    @Override
    public int stripColorFromMetadata(int meta) {
        return meta & 0xFFFFFF0F;
    }

    @Override
    public void removeDye(@NotNull World world, @NotNull TilePosc tilePos) {
        int meta = world.getBlockData(tilePos);
        world.setBlockIdDataNotify(tilePos, Blocks.STAIRS_PLANKS_OAK.id(), this.stripColorFromMetadata(meta));
    }

    @Override
    @NotNull
    public DyeColor getColor(@NotNull World world, @NotNull TilePosc tilePos) {
        return IPainted.super.getColor(world, tilePos);
    }

    @Override
    public void setColor(@NotNull World world, @NotNull TilePosc tilePos, @NotNull DyeColor color) {
        Bounds bounds = this.getPortalDims(world, tilePos, true);
        if (bounds == null) {
            world.setBlockIdNotify(tilePos, 0);
            return;
        }
        TilePos portalPos = bounds.pos;
        TilePos p = new TilePos(tilePos);
        switch (bounds.axis) {
            case X: {
                for (int ra = 1; ra < bounds.maxBoundA; ++ra) {
                    for (int ry = 1; ry < bounds.maxBoundB; ++ry) {
                        p.x = portalPos.x + ra;
                        p.y = portalPos.y + ry;
                        p.z = portalPos.z;
                        this.setColorRaw(world, p, color);
                    }
                }
                break;
            }
            case Z: {
                for (int ra = 1; ra < bounds.maxBoundA; ++ra) {
                    for (int ry = 1; ry < bounds.maxBoundB; ++ry) {
                        p.x = portalPos.x;
                        p.y = portalPos.y + ry;
                        p.z = portalPos.z + ra;
                        this.setColorRaw(world, p, color);
                    }
                }
                break;
            }
        }
    }

    private void setColorRaw(@NotNull World world, @NotNull TilePos tilePos, @NotNull DyeColor color) {
        int meta = world.getBlockData(tilePos);
        world.setBlockDataNotify(tilePos, this.stripColorFromMetadata(meta) | this.toMetadata(color) | 8);
    }

    public record Bounds(@NotNull Axis axis, @NotNull TilePos pos, int maxBoundA, int maxBoundB) {
    }
}

