/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.ListTag;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.helper.UUIDHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemFlag
extends Item {
    public ItemFlag(@NotNull String name, @NotNull String namespaceId, int id) {
        super(name, namespaceId, id);
        this.setMaxStackSize(1);
    }

    @Override
    @NotNull
    public String getLanguageKey(@NotNull ItemStack selfStack) {
        if (this.hasFlagBeenDrawnOn(selfStack) || this.doesFlagContainDyes(selfStack)) {
            return this.getKey() + ".modified";
        }
        return super.getLanguageKey(selfStack);
    }

    @Override
    public boolean onUseOnBlock(@NotNull ItemStack selfStack, @NotNull World world, @Nullable Player player, @NotNull TilePosc blockPos, @NotNull Side side, double xHit, double yHit) {
        Object flagData;
        TileEntity tileEntity;
        if (world.getBlockId(blockPos) == Blocks.FLAG.id() && player != null && !player.isSneaking() && (tileEntity = world.getTileEntity(blockPos)) instanceof TileEntityFlag) {
            TileEntityFlag flag = (TileEntityFlag)tileEntity;
            flagData = selfStack.getData().getCompoundOrDefault("FlagData", new CompoundTag());
            if (this.hasFlagBeenDrawnOn(selfStack) && this.doesFlagContainDyes(selfStack)) {
                player.sendStatusMessage(I18n.getInstance().translateKey("flag.overwrite"));
                return false;
            }
            flag.copyFlagNBT((CompoundTag)flagData);
            UUIDHelper.writeToTag((CompoundTag)flagData, player.uuid, "OwnerUUID");
            selfStack.getData().putCompound("FlagData", (CompoundTag)flagData);
            player.sendStatusMessage(I18n.getInstance().translateKey("flag.copied"));
            return true;
        }
        if (side == Side.BOTTOM) {
            return false;
        }
        if (!world.getBlockMaterial(blockPos).isSolid()) {
            return false;
        }
        if (!world.canPlaceInsideBlock(blockPos)) {
            blockPos = blockPos.add(side.getDirection(), new TilePos());
        }
        if (blockPos.y() < 0 || blockPos.y() >= world.getHeightBlocks()) {
            return false;
        }
        if (!Blocks.SIGN_POST_PLANKS_OAK.canPlaceAt(world, blockPos)) {
            return false;
        }
        world.playBlockSoundEffect(player, (float)blockPos.x() + 0.5f, (float)blockPos.y() + 0.5f, (float)blockPos.z() + 0.5f, Blocks.FLAG, EnumBlockSoundEffectType.PLACE);
        world.setBlockIdDataNotify(blockPos, Blocks.FLAG.id(), 0);
        selfStack.consumeItem(player);
        flagData = world.getTileEntity(blockPos);
        if (flagData instanceof TileEntityFlag) {
            TileEntityFlag flag = (TileEntityFlag)flagData;
            flagData = selfStack.getData().getCompoundOrDefault("FlagData", null);
            if (flagData != null) {
                flag.readAdditionalData((CompoundTag)flagData);
            }
            if (!world.isClientSide && flag.owner == null && player != null) {
                player.displayFlagEditorScreen(flag);
            }
        }
        return true;
    }

    public boolean hasFlagBeenDrawnOn(@NotNull ItemStack selfStack) {
        CompoundTag flagData = selfStack.getData().getCompound("FlagData");
        if (flagData == null) {
            return false;
        }
        byte[] colors = flagData.getByteArray("Colors");
        if (colors == null) {
            return false;
        }
        for (int i = 0; i < colors.length; ++i) {
            if (colors[i] == 0) continue;
            return true;
        }
        return false;
    }

    public boolean doesFlagContainDyes(@NotNull ItemStack selfStack) {
        CompoundTag flagData = selfStack.getData().getCompound("FlagData");
        if (flagData == null) {
            return false;
        }
        ListTag items = flagData.getList("Items");
        return items != null && items.tagCount() > 0;
    }
}

