/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.core.net.handler.PacketHandler;
import net.minecraft.core.net.packet.Packet;

public class PacketSyncIDs
extends Packet {
    public static final int MAX_ID_STRING_SIZE = 128;
    public static final int DESTINATION_SOUND_IDS = 0;
    public static final int DESTINATION_ENTITY_IDS = 1;
    private int packetSize;
    public int destinationId = -1;
    public Int2ObjectMap<String> mapping;

    public PacketSyncIDs() {
    }

    public PacketSyncIDs(int destinationId, Int2ObjectMap<String> mapping) {
        this.destinationId = destinationId;
        this.mapping = mapping;
    }

    @Override
    public void read(DataInputStream in) throws IOException {
        int size = 0;
        this.packetSize = size += this.readIds(in);
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        int size = 0;
        this.packetSize = size += this.writeIds(out);
    }

    public int readIds(DataInputStream in) throws IOException {
        this.mapping = new Int2ObjectOpenHashMap<String>();
        int bytesRead = 0;
        this.destinationId = in.readByte() & 0xFF;
        int count = in.readInt();
        bytesRead += 4;
        for (int i = 0; i < count; ++i) {
            int id = in.readShort() & 0xFFFF;
            String name = PacketSyncIDs.readStringUTF8(in, 128);
            this.mapping.put(id, name);
        }
        return bytesRead;
    }

    public int writeIds(DataOutputStream out) throws IOException {
        int bytesWritten = 0;
        out.writeByte(this.destinationId);
        out.writeInt(this.mapping.size());
        bytesWritten += 4;
        for (Int2ObjectMap.Entry entry : this.mapping.int2ObjectEntrySet()) {
            out.writeShort(entry.getIntKey());
            PacketSyncIDs.writeStringUTF8((String)entry.getValue(), out);
        }
        return bytesWritten;
    }

    @Override
    public void handlePacket(PacketHandler packetHandler) {
        packetHandler.handleSyncIDs(this);
    }

    @Override
    public int getEstimatedSize() {
        return this.packetSize + 1;
    }
}

