/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.hud.component;

import net.minecraft.client.entity.player.PlayerLocal;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.gui.hud.component.HudComponentMovable;
import net.minecraft.client.gui.hud.component.layout.Layout;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.util.helper.Direction;

public class HudComponentRotationLock
extends HudComponentMovable {
    public HudComponentRotationLock(String key, Layout layout) {
        super(key, 24, 16, layout);
    }

    @Override
    public boolean isVisible() {
        return HudComponentRotationLock.mc.thePlayer.rotationLock != null && HudComponentRotationLock.mc.thePlayer.rotationLock != Direction.NONE && HudComponentRotationLock.mc.gameSettings.immersiveMode.drawOverlays();
    }

    @Override
    public void render(HudIngame hud, int xSizeScreen, int ySizeScreen, float partialTick) {
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GLRenderer.enableState(State.BLEND);
        int x = this.getLayout().getComponentX(this, xSizeScreen);
        int y = this.getLayout().getComponentY(this, ySizeScreen);
        String prefix = (Integer)HudComponentRotationLock.mc.gameSettings.rotationOverlayMode.value % 2 == 1 ? "arrow" : "cube";
        PlayerLocal player = HudComponentRotationLock.mc.thePlayer;
        boolean facingUp = player.xRot < -45.0f;
        boolean facingDown = player.xRot > 45.0f;
        Direction dir = Direction.getDirection(player);
        if (dir.isHorizontal()) {
            dir = dir.rotate(-Direction.getHorizontalDirection((double)((double)player.yRot)).rotate((int)2).index);
            if (facingUp) {
                if (dir == Direction.SOUTH) {
                    dir = Direction.UP;
                }
                if (dir == Direction.NORTH) {
                    dir = Direction.DOWN;
                }
            }
            if (facingDown) {
                if (dir == Direction.SOUTH) {
                    dir = Direction.DOWN;
                }
                if (dir == Direction.NORTH) {
                    dir = Direction.UP;
                }
            }
        } else if (dir == Direction.UP) {
            dir = Direction.DOWN;
            if (facingUp) {
                dir = Direction.SOUTH;
            } else if (facingDown) {
                dir = Direction.NORTH;
            }
        } else if (dir == Direction.DOWN) {
            dir = Direction.UP;
            if (facingDown) {
                dir = Direction.SOUTH;
            } else if (facingUp) {
                dir = Direction.NORTH;
            }
        }
        String[] dirTextures = new String[]{"down", "up", "back", "front", "left", "right"};
        hud.drawGuiIcon(x, y, 16, 16, TextureRegistry.getTexture("minecraft:gui/hud/rotation/" + prefix + "_" + dirTextures[dir.getId()]));
        dir = Direction.getVerticalDirection(player);
        dirTextures = new String[]{"downer", "upper", "back", "front", "left", "right"};
        hud.drawGuiIcon(x + 16, y + 4, 8, 8, TextureRegistry.getTexture("minecraft:gui/hud/rotation/" + prefix + "_" + dirTextures[dir.getId()]));
    }

    @Override
    public void renderPreview(Gui gui, Layout layout, int xSizeScreen, int ySizeScreen) {
        int x = layout.getComponentX(this, xSizeScreen);
        int y = layout.getComponentY(this, ySizeScreen);
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GLRenderer.enableState(State.BLEND);
        String prefix = (Integer)HudComponentRotationLock.mc.gameSettings.rotationOverlayMode.value % 2 == 1 ? "arrow" : "cube";
        gui.drawGuiIcon(x, y, 16, 16, TextureRegistry.getTexture("minecraft:gui/hud/rotation/" + prefix + "_front"));
        gui.drawGuiIcon(x + 16, y + 4, 8, 8, TextureRegistry.getTexture("minecraft:gui/hud/rotation/" + prefix + "_downer"));
    }
}

