/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model.generic;

import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.generic.BlockModelGeneric;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFenceThin;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class BlockModelGenericFenceThin<T extends BlockLogicFenceThin>
extends BlockModelGeneric<T> {
    @NotNull
    public final StaticBlockModel post;
    @NotNull
    public final StaticBlockModel side;
    @NotNull
    public final StaticBlockModel top;

    public BlockModelGenericFenceThin(@NotNull Block<T> block, @NotNull String basekey) {
        super(block, BlockModelDispatcher.loadDataModel(basekey + "/inventory"));
        this.post = BlockModelDispatcher.loadDataModel(basekey + "/post").asModel();
        this.side = BlockModelDispatcher.loadDataModel(basekey + "/side").asModel();
        this.top = BlockModelDispatcher.loadDataModel(basekey + "/side_top").asModel();
    }

    @Override
    public boolean renderAttached(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos, boolean cullFaces, @Nullable IconCoordinate overrideTexture) {
        boolean upEast;
        boolean didRender = false;
        TilePos queryPos = new TilePos();
        boolean north = ((BlockLogicFenceThin)this.block.getLogic()).canConnectTo(worldSource, tilePos, Side.NORTH);
        boolean south = ((BlockLogicFenceThin)this.block.getLogic()).canConnectTo(worldSource, tilePos, Side.SOUTH);
        boolean west = ((BlockLogicFenceThin)this.block.getLogic()).canConnectTo(worldSource, tilePos, Side.WEST);
        boolean east = ((BlockLogicFenceThin)this.block.getLogic()).canConnectTo(worldSource, tilePos, Side.EAST);
        Block<?> blockAbove = worldSource.getBlock(tilePos.up(queryPos));
        boolean upNorth = blockAbove == this.block && ((BlockLogicFenceThin)this.block.getLogic()).canConnectTo(worldSource, tilePos.up(queryPos), Side.NORTH);
        boolean upSouth = blockAbove == this.block && ((BlockLogicFenceThin)this.block.getLogic()).canConnectTo(worldSource, tilePos.up(queryPos), Side.SOUTH);
        boolean upWest = blockAbove == this.block && ((BlockLogicFenceThin)this.block.getLogic()).canConnectTo(worldSource, tilePos.up(queryPos), Side.WEST);
        boolean bl = upEast = blockAbove == this.block && ((BlockLogicFenceThin)this.block.getLogic()).canConnectTo(worldSource, tilePos.up(queryPos), Side.EAST);
        if (north) {
            didRender = upNorth ? (didRender |= this.side.renderAttached(this, tessellator, worldSource, tilePos, 0, 0, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture)) : (didRender |= this.top.renderAttached(this, tessellator, worldSource, tilePos, 0, 0, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture));
        }
        if (west) {
            didRender = upWest ? (didRender |= this.side.renderAttached(this, tessellator, worldSource, tilePos, 0, 1, 0, 0.0, 0.0, 0.0, true, cullFaces, overrideTexture)) : (didRender |= this.top.renderAttached(this, tessellator, worldSource, tilePos, 0, 1, 0, 0.0, 0.0, 0.0, true, cullFaces, overrideTexture));
        }
        if (south) {
            didRender = upSouth ? (didRender |= this.side.renderAttached(this, tessellator, worldSource, tilePos, 0, 2, 0, 0.0, 0.0, 0.0, true, cullFaces, overrideTexture)) : (didRender |= this.top.renderAttached(this, tessellator, worldSource, tilePos, 0, 2, 0, 0.0, 0.0, 0.0, true, cullFaces, overrideTexture));
        }
        if (east) {
            didRender = upEast ? (didRender |= this.side.renderAttached(this, tessellator, worldSource, tilePos, 0, 3, 0, 0.0, 0.0, 0.0, true, cullFaces, overrideTexture)) : (didRender |= this.top.renderAttached(this, tessellator, worldSource, tilePos, 0, 3, 0, 0.0, 0.0, 0.0, true, cullFaces, overrideTexture));
        }
        if (((BlockLogicFenceThin)this.block.getLogic()).shouldDrawColumn(worldSource, tilePos)) {
            didRender |= this.post.renderAttached(this, tessellator, worldSource, tilePos, 0, 0, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
        }
        return didRender;
    }
}

