/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tessellator;

import com.mojang.logging.LogUtils;
import java.nio.ByteBuffer;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.renderer.DrawMode;
import net.minecraft.client.render.terrain.VertexConfig;
import net.minecraft.client.render.terrain.VertexData;
import net.minecraft.client.render.tessellator.RenderBuffer;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL41;
import org.slf4j.Logger;

public class TessellatorTerrainImpl
implements TessellatorGeneral {
    private static final Logger LOGGER = LogUtils.getLogger();
    public TerrainVertexData data;
    public boolean drawing;
    private int color;
    private int lightmapCoord;
    private double textureU;
    private double textureV;
    private double offsetX;
    private double offsetY;
    private double offsetZ;
    private byte normalX;
    private byte normalY;
    private byte normalZ;
    private boolean lockedColor = false;
    private int quadVertCount = 0;

    public TessellatorTerrainImpl(int bufferSize) {
        this.data = new TerrainVertexData(bufferSize);
    }

    @Override
    public void startDrawing(@NotNull DrawMode drawMode) {
        if (this.drawing) {
            this.drawing = false;
            throw new IllegalStateException("Already drawing!");
        }
        this.drawing = true;
        this.data.vertexCount = 0;
        this.quadVertCount = 0;
        this.setLightmapCoord1i(LightmapHelper.getLightmapCoord(15, 15));
        this.setColor4i(255, 255, 255, 255);
        this.setTextureUV(0.0, 0.0);
        this.setNormal(0.0f, 1.0f, 0.0f);
        this.lockedColor = false;
        this.data.buffer.clear();
    }

    @Override
    public void draw() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RenderBuffer record(int vao, int vbo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addVertex(double x, double y, double z) {
        this.checkIsDrawing();
        this.checkCanFit(64);
        ByteBuffer buffer = this.data.buffer;
        buffer.putFloat((float)(this.offsetX + x));
        buffer.putFloat((float)(this.offsetY + y));
        buffer.putFloat((float)(this.offsetZ + z));
        buffer.putInt(this.color);
        buffer.putFloat((float)this.textureU);
        buffer.putFloat((float)this.textureV);
        buffer.put((byte)((LightmapHelper.getBlockLightFromCoord(this.lightmapCoord) << 4) + 7)).put((byte)((LightmapHelper.getSkyLightFromCoord(this.lightmapCoord) << 4) + 7));
        buffer.put(this.normalX);
        buffer.put(this.normalY);
        buffer.put(this.normalZ);
        ++this.data.vertexCount;
        if (this.quadVertCount % 4 == 2) {
            int vertSize = this.data.config.getVertexSize();
            this.checkCanFit(128);
            this.data.buffer.put(this.data.buffer.position(), this.data.buffer, this.data.buffer.position() - vertSize * 3, vertSize);
            this.data.buffer.put(this.data.buffer.position() + vertSize, this.data.buffer, this.data.buffer.position() - vertSize, vertSize);
            this.data.buffer.position(this.data.buffer.position() + vertSize * 2);
            this.data.vertexCount += 2;
        }
        ++this.quadVertCount;
    }

    public void checkCanFit(int size) {
        if (this.data.buffer.capacity() < this.data.buffer.position() + size) {
            int newSize = this.data.buffer.capacity() * 2;
            LOGGER.info("Expanding {} Buffer ({} -> {})", "Terrain Tessellator", this.data.buffer.capacity(), newSize);
            ByteBuffer newBuffer = BufferUtils.createByteBuffer(newSize);
            this.data.buffer.flip();
            newBuffer.put(this.data.buffer);
            this.data.buffer = newBuffer;
        }
    }

    @Override
    public void setTextureUV(double u, double v) {
        this.checkIsDrawing();
        this.textureU = u;
        this.textureV = v;
    }

    @Override
    public void setLightmapCoord1i(int lightmapCoord) {
        this.checkIsDrawing();
        this.lightmapCoord = lightmapCoord;
    }

    @Override
    public void setColor1i(int argb) {
        this.checkIsDrawing();
        if (this.lockedColor) {
            return;
        }
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        this.color = a << 24 | b << 16 | g << 8 | r;
    }

    @Override
    public void lockColor() {
        this.checkIsDrawing();
        this.lockedColor = true;
    }

    @Override
    public void setTranslation(double x, double y, double z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
    }

    @Override
    public void offsetTranslation(double x, double y, double z) {
        this.offsetX += x;
        this.offsetY += y;
        this.offsetZ += z;
    }

    public void checkIsDrawing() {
        if (!this.drawing) {
            this.drawing = false;
            throw new IllegalStateException("Not drawing!");
        }
    }

    @Override
    public void setNormal(float x, float y, float z) {
        this.checkIsDrawing();
        this.normalX = (byte)(x * 127.0f);
        this.normalY = (byte)(y * 127.0f);
        this.normalZ = (byte)(z * 127.0f);
    }

    public static class TerrainVertexData
    extends VertexData {
        public TerrainVertexData(int size) {
            super(size);
            this.config = new TerrainVertexConfig();
        }
    }

    public static class TerrainVertexConfig
    implements VertexConfig<TerrainVertexConfig> {
        @Override
        @NotNull
        public DrawMode drawmode() {
            return DrawMode.TRIANGLES;
        }

        @Override
        public void enable(int vao, int vbo) {
            GL41.glBindVertexArray(vao);
            GL41.glBindBuffer(34962, vbo);
            int vertexSize = this.getVertexSize();
            int offset = 0;
            GL41.glVertexAttribPointer(0, 3, 5126, false, vertexSize, offset);
            GL41.glVertexAttribPointer(1, 4, 5121, true, vertexSize, offset += 12);
            GL41.glVertexAttribPointer(2, 2, 5126, false, vertexSize, offset += 4);
            GL41.glVertexAttribPointer(3, 2, 5121, true, vertexSize, offset += 8);
            GL41.glVertexAttribPointer(4, 3, 5120, true, vertexSize, offset += 2);
            offset += 3;
            GL41.glEnableVertexAttribArray(0);
            GL41.glEnableVertexAttribArray(1);
            GL41.glEnableVertexAttribArray(2);
            GL41.glEnableVertexAttribArray(3);
            GL41.glEnableVertexAttribArray(4);
        }

        @Override
        public void disable() {
            GL41.glDisableVertexAttribArray(0);
            GL41.glDisableVertexAttribArray(1);
            GL41.glDisableVertexAttribArray(2);
            GL41.glDisableVertexAttribArray(3);
            GL41.glBindBuffer(34962, 0);
            GL41.glBindVertexArray(0);
        }

        @Override
        public int getVertexSize() {
            int size = 12;
            size += 4;
            size += 8;
            size += 2;
            return size += 3;
        }

        @Override
        @NotNull
        public TerrainVertexConfig copy() {
            return this;
        }

        public boolean equals(Object obj) {
            return obj instanceof TerrainVertexConfig;
        }
    }
}

