/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.vehicle.EntityBoat;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.IBonemealable;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBdc;

public class BlockLogicAlgae
extends BlockLogic
implements IBonemealable {
    protected BlockLogicAlgae(@NotNull Block<?> block, @NotNull Material material) {
        super(block, material);
        this.setBlockBounds(0.0, -0.125, 0.0, 1.0, 0.00625f, 1.0);
    }

    @Override
    public void onEntityCollision(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Entity entity) {
        if (entity instanceof EntityBoat) {
            world.playBlockEvent(null, tilePos, 2001, this.block.id());
            world.setBlockIdNotify(tilePos, 0);
        }
    }

    @Override
    public boolean canPlaceAt(@NotNull World world, @NotNull TilePosc tilePos) {
        int blockId = world.getBlockId(tilePos);
        return blockId == 0 && Blocks.hasTag(world.getBlockId(tilePos.add(Direction.DOWN, new TilePos())), BlockTags.IS_WATER) && world.getBlockData(tilePos.add(Direction.DOWN, new TilePos())) == 0;
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePosc tilePos, int id) {
        if (!Blocks.hasTag(world.getBlockId(tilePos.add(Direction.DOWN, new TilePos())), BlockTags.IS_WATER) || world.getBlockData(tilePos.add(Direction.DOWN, new TilePos())) != 0) {
            world.setBlockId(tilePos, 0);
        }
    }

    @Override
    @Nullable
    public AABBdc getCollisionAABB(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return null;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return PartialSupport.INSTANCE;
    }

    @Override
    public @NotNull ItemStack @Nullable [] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        ItemStack[] itemStackArray;
        switch (dropCause) {
            case SILK_TOUCH: 
            case PICK_BLOCK: {
                ItemStack[] itemStackArray2 = new ItemStack[1];
                itemStackArray = itemStackArray2;
                itemStackArray2[0] = new ItemStack(this.block);
                break;
            }
            default: {
                itemStackArray = null;
            }
        }
        return itemStackArray;
    }

    @Override
    public boolean onBonemealUsed(@NotNull ItemStack itemStack, @Nullable Player player, @NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        @NotNull Random rand = world.rand;
        if (!world.isClientSide) {
            if (player == null || player.getGamemode().hasBlockConsumption()) {
                --itemStack.stackSize;
            }
            TilePos queryPos = new TilePos();
            block0: for (int i = 0; i < 128; ++i) {
                int checkX = tilePos.x();
                int checkY = tilePos.y();
                int checkZ = tilePos.z();
                for (int j = 0; j < i / 16; ++j) {
                    int bId = world.getBlockId(queryPos.set(checkX += rand.nextInt(3) - 1, checkY - 1, checkZ += rand.nextInt(3) - 1));
                    int bMeta = world.getBlockData(queryPos.set(checkX, checkY - 1, checkZ));
                    if (bId != Blocks.FLUID_WATER_FLOWING.id() && bId != Blocks.FLUID_WATER_STILL.id() || bMeta != 0) continue block0;
                }
                if (world.getBlockId(queryPos.set(checkX, checkY, checkZ)) != 0 || !((double)rand.nextFloat() > 0.75)) continue;
                world.setBlockIdNotify(queryPos.set(checkX, checkY, checkZ), this.block.id());
            }
            return true;
        }
        return true;
    }
}

