/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.List;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;

public abstract class BlockLogicFenceThin
extends BlockLogic {
    public BlockLogicFenceThin(@NotNull Block<?> block, @NotNull Material material) {
        super(block, material);
    }

    @Override
    public boolean canPlaceOnSurface() {
        return true;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        if (side.isVertical()) {
            return PartialSupport.INSTANCE.center();
        }
        return PartialSupport.INSTANCE;
    }

    @Override
    @Nullable
    public AABBdc getCollisionAABB(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        boolean connectEast = this.canConnectTo(source, tilePos, Side.EAST);
        boolean connectWest = this.canConnectTo(source, tilePos, Side.WEST);
        boolean connectSouth = this.canConnectTo(source, tilePos, Side.SOUTH);
        boolean connectNorth = this.canConnectTo(source, tilePos, Side.NORTH);
        return new AABBd(connectWest ? 0.0f : 0.375f, 0.0, connectNorth ? 0.0f : 0.375f, 1.0f - (connectEast ? 0.0f : 0.375f), 1.0, 1.0f - (connectSouth ? 0.0f : 0.375f));
    }

    @Override
    @NotNull
    public AABBdc getBoundsFromState(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        boolean connectEast = this.canConnectTo(source, tilePos, Side.EAST);
        boolean connectWest = this.canConnectTo(source, tilePos, Side.WEST);
        boolean connectSouth = this.canConnectTo(source, tilePos, Side.SOUTH);
        boolean connectNorth = this.canConnectTo(source, tilePos, Side.NORTH);
        return new AABBd(connectWest ? 0.0f : 0.375f, 0.0, connectNorth ? 0.0f : 0.375f, 1.0f - (connectEast ? 0.0f : 0.375f), 1.0, 1.0f - (connectSouth ? 0.0f : 0.375f));
    }

    @Override
    public void getCollisionAABBs(@NotNull World world, @NotNull TilePosc tilePos, @NotNull AABBdc aabb, @NotNull @NotNull List<@NotNull AABBdc> aabbList) {
        boolean connectEast = this.canConnectTo(world, tilePos, Side.EAST);
        boolean connectWest = this.canConnectTo(world, tilePos, Side.WEST);
        boolean connectSouth = this.canConnectTo(world, tilePos, Side.SOUTH);
        boolean connectNorth = this.canConnectTo(world, tilePos, Side.NORTH);
        double thickness = 0.125;
        if (connectEast) {
            this.addIntersectingBoundingBox(aabb, new AABBd(0.375, 0.0, 0.375, 1.0, 1.0, 0.625).translate(tilePos.x(), tilePos.y(), tilePos.z()), aabbList);
        }
        if (connectWest) {
            this.addIntersectingBoundingBox(aabb, new AABBd(0.0, 0.0, 0.375, 0.625, 1.0, 0.625).translate(tilePos.x(), tilePos.y(), tilePos.z()), aabbList);
        }
        if (connectSouth) {
            this.addIntersectingBoundingBox(aabb, new AABBd(0.375, 0.0, 0.375, 0.625, 1.0, 1.0).translate(tilePos.x(), tilePos.y(), tilePos.z()), aabbList);
        }
        if (connectNorth) {
            this.addIntersectingBoundingBox(aabb, new AABBd(0.375, 0.0, 0.0, 0.625, 1.0, 0.625).translate(tilePos.x(), tilePos.y(), tilePos.z()), aabbList);
        }
        if (!(connectEast || connectWest || connectSouth || connectNorth)) {
            this.addIntersectingBoundingBox(aabb, new AABBd(0.375, 0.0, 0.375, 0.625, 1.0, 0.625).translate(tilePos.x(), tilePos.y(), tilePos.z()), aabbList);
        }
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    public abstract boolean canConnectTo(@NotNull WorldSource var1, @NotNull TilePosc var2, @NotNull Side var3);

    @Deprecated
    public final boolean canConnectTo(@NotNull WorldSource world, int x, int y, int z, @NotNull Side side) {
        return this.canConnectTo(world, new TilePos(x, y, z), side);
    }

    public boolean shouldDrawColumn(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        boolean drawColumn = this.shouldDrawColumn_do(source, tilePos);
        if (drawColumn) {
            return true;
        }
        TilePos queryPos = new TilePos();
        int oy = 1;
        while (source.getBlockId(tilePos.add(0, oy, 0, queryPos)) == this.block.id()) {
            ++oy;
        }
        --oy;
        boolean drawColumnFromOther = false;
        while (source.getBlockId(tilePos.add(0, oy, 0, queryPos)) == this.block.id()) {
            if (this.shouldDrawColumn_do(source, tilePos.add(0, oy, 0, queryPos))) {
                drawColumnFromOther = true;
                break;
            }
            --oy;
        }
        return drawColumnFromOther;
    }

    private boolean shouldDrawColumn_do(@NotNull WorldSource world, @NotNull TilePosc tilePos) {
        boolean connectNorth = this.canConnectTo(world, tilePos, Side.NORTH);
        boolean connectSouth = this.canConnectTo(world, tilePos, Side.SOUTH);
        boolean connectEast = this.canConnectTo(world, tilePos, Side.EAST);
        boolean connectWest = this.canConnectTo(world, tilePos, Side.WEST);
        boolean lineNorthSouth = connectNorth && connectSouth;
        boolean lineEastWest = connectEast && connectWest;
        return !lineNorthSouth && !lineEastWest || lineNorthSouth && lineEastWest || lineNorthSouth && (connectEast || connectWest) || lineEastWest && (connectNorth || connectSouth);
    }
}

