/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFlower;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.IBonemealable;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockLogicSaplingBase
extends BlockLogicFlower
implements IBonemealable {
    public boolean canGrowOnSand = false;

    public BlockLogicSaplingBase(@NotNull Block<?> block) {
        super(block);
        float f = 0.4f;
        this.setBlockBounds(0.5f - f, 0.0, 0.5f - f, 0.5f + f, f * 2.0f, 0.5f + f);
    }

    @Override
    public boolean mayPlaceOn(int blockId) {
        return blockId == Blocks.SAND.id() || super.mayPlaceOn(blockId);
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand, boolean isRandomTick) {
        if (world.isClientSide) {
            return;
        }
        TilePos queryPos = new TilePos();
        if (!this.canGrowOnSand && world.getBlockId(tilePos.down(queryPos)) == Blocks.SAND.id()) {
            world.setBlockIdNotify(tilePos, Blocks.DEADBUSH.id());
        }
        super.updateTick(world, tilePos, rand, isRandomTick);
        int growthRate = 30;
        if (world.getSeasonManager().getCurrentSeason() != null) {
            growthRate = MathHelper.floor_float((float)growthRate / world.getSeasonManager().getCurrentSeason().cropGrowthFactor);
        }
        if (world.getBlockLightValue(tilePos.up(queryPos)) >= 9 && rand.nextInt(growthRate) == 0) {
            int l = world.getBlockData(tilePos);
            if ((l & 8) == 0) {
                world.setBlockDataNotify(tilePos, l | 8);
            } else {
                this.growTree(world, tilePos, rand);
            }
        }
    }

    @Override
    public boolean onBonemealUsed(@NotNull ItemStack itemStack, @Nullable Player player, @NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        if (!world.isClientSide) {
            this.growTree(world, tilePos, world.rand);
            if (player == null || player.getGamemode().hasBlockConsumption()) {
                --itemStack.stackSize;
            }
        }
        return true;
    }

    public abstract void growTree(@NotNull World var1, @NotNull TilePosc var2, @NotNull Random var3);
}

