/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.piston;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.block.piston.TileEntityMovingPistonBlock;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;

public class BlockLogicPistonMoving
extends BlockLogic {
    public BlockLogicPistonMoving(Block<?> container) {
        super(container, Materials.PISTON);
        container.withHardness(-1.0f);
        container.withEntity(null);
    }

    @Override
    public void onRemoved(@NotNull World world, @NotNull TilePosc tilePos, int data) {
        TileEntity tileEntity = world.getTileEntity(tilePos);
        if (tileEntity instanceof TileEntityMovingPistonBlock) {
            TileEntityMovingPistonBlock moving = (TileEntityMovingPistonBlock)tileEntity;
            moving.finalTick();
        } else {
            super.onRemoved(world, tilePos, data);
        }
    }

    @Override
    public boolean canPlaceAt(@NotNull World world, @NotNull TilePosc tilePos) {
        return false;
    }

    @Override
    public boolean canPlaceOnSide(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        if (!world.isClientSide && world.getTileEntity(tilePos) == null) {
            int id = 0;
            TileEntity tileEntity = world.getTileEntity(tilePos);
            if (tileEntity instanceof TileEntityMovingPistonBlock) {
                TileEntityMovingPistonBlock piston = (TileEntityMovingPistonBlock)tileEntity;
                id = piston.getMovedId();
            }
            world.setBlockIdNotify(tilePos, id);
            return true;
        }
        return false;
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        return null;
    }

    @Override
    public void dropWithCause(@NotNull World world, @NotNull EnumDropCause dropCause, @NotNull TilePosc tilePos, int data, @Nullable TileEntity tileEntity, @Nullable Player player) {
        TileEntityMovingPistonBlock piston;
        Block<?> b;
        if (world.isClientSide) {
            return;
        }
        TileEntity tileEntity2 = world.getTileEntity(tilePos);
        if (tileEntity2 instanceof TileEntityMovingPistonBlock && (b = Blocks.getBlock((piston = (TileEntityMovingPistonBlock)tileEntity2).getMovedId())) != null) {
            b.dropWithCause(world, EnumDropCause.WORLD, tilePos, data, null, null);
        }
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePosc tilePos, int id) {
        if (!world.isClientSide) {
            world.getTileEntity(tilePos);
        }
    }

    public static TileEntity createTileEntity(int movedId, int movedData, @Nullable TileEntity movedEntity, @NotNull Direction direction, boolean extending, boolean isSourcePiston) {
        assert (!(movedEntity instanceof TileEntityMovingPistonBlock)) : "Moving piston entity should not be able to be put into another moving piston!";
        return new TileEntityMovingPistonBlock(movedId, movedData, movedEntity, direction, extending, isSourcePiston);
    }

    @Override
    @Nullable
    public AABBdc getCollisionAABB(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        TileEntity tileEntity = source.getTileEntity(tilePos);
        if (tileEntity instanceof TileEntityMovingPistonBlock) {
            TileEntityMovingPistonBlock piston = (TileEntityMovingPistonBlock)tileEntity;
            float progress = piston.getProgress(0.0f);
            if (piston.isExtending()) {
                progress = 1.0f - progress;
            }
            return this.getCollisionShapeFromTileEntity(source, tilePos, piston.getMovedId(), progress, piston.getDirection());
        }
        return null;
    }

    @Override
    @NotNull
    public AABBdc getBoundsFromState(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        TileEntity tileEntity = source.getTileEntity(tilePos);
        if (tileEntity instanceof TileEntityMovingPistonBlock) {
            TileEntityMovingPistonBlock piston = (TileEntityMovingPistonBlock)tileEntity;
            Block<?> block = Blocks.blocksList[piston.getMovedId()];
            if (block == null || block == this.block) {
                return super.getBoundsFromState(source, tilePos);
            }
            float directionStretch = piston.getProgress(0.0f);
            if (piston.isExtending()) {
                directionStretch = 1.0f - directionStretch;
            }
            Direction direction = piston.getDirection();
            AABBdc otherBounds = block.getBoundsFromState(source, tilePos);
            return otherBounds.translate((float)(-direction.getOffsetX()) * directionStretch, (float)(-direction.getOffsetY()) * directionStretch, (float)(-direction.getOffsetZ()) * directionStretch, new AABBd());
        }
        return super.getBoundsFromState(source, tilePos);
    }

    @Nullable
    public AABBdc getCollisionShapeFromTileEntity(@NotNull WorldSource source, @NotNull TilePosc tilePos, int blockID, float directionStretch, @NotNull Direction direction) {
        if (blockID == 0 || blockID == this.block.id()) {
            return null;
        }
        AABBdc aabb = Blocks.blocksList[blockID].getCollisionAABB(source, tilePos);
        if (aabb == null) {
            return null;
        }
        return aabb.translate((float)(-direction.getOffsetX()) * directionStretch, (float)(-direction.getOffsetY()) * directionStretch, (float)(-direction.getOffsetZ()) * directionStretch, new AABBd());
    }
}

