/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.ItemBlock;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBlockAlgae<T extends BlockLogic>
extends ItemBlock<T> {
    public ItemBlockAlgae(Block<T> block) {
        super(block);
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
    }

    @Override
    public boolean onUseOnBlock(@NotNull ItemStack selfStack, @NotNull World world, @Nullable Player player, @NotNull TilePosc blockPos, @NotNull Side side, double xHit, double yHit) {
        return false;
    }

    @Override
    @Nullable
    public ItemStack onUse(@NotNull ItemStack selfStack, @NotNull World world, @NotNull Player player) {
        double reachDistance = player.getGamemode().getBlockReachDistance();
        HitResult rayCast = player.rayCast(reachDistance, 1.0f, true, false, false);
        if (rayCast == null) {
            return selfStack;
        }
        if (rayCast instanceof HitResult.Tile) {
            HitResult.Tile hitTile = (HitResult.Tile)rayCast;
            TilePos blockPos = new TilePos(hitTile.tilePos);
            if (world.getBlockId(blockPos) == Blocks.FLUID_WATER_STILL.id()) {
                ++blockPos.y;
            } else {
                return selfStack;
            }
            if (world.getBlockId(blockPos) != 0) {
                return selfStack;
            }
            if (selfStack.consumeItem(player) && world.setBlockIdDataNotify(blockPos, this.block.id(), 0)) {
                this.block.onPlacedByMob(world, blockPos, Side.NONE, player, 0.5, 0.5);
                world.playBlockSoundEffect(player, (float)blockPos.x + 0.5f, (float)blockPos.y + 0.5f, (float)blockPos.z + 0.5f, this.block, EnumBlockSoundEffectType.PLACE);
                player.swingItem();
            }
        }
        return selfStack;
    }

    @Override
    public void onUseByActivator(@NotNull ItemStack selfStack, @NotNull World world, @NotNull TileEntityActivator activator, @NotNull Random random, @NotNull TilePosc blockPos, @NotNull Direction direction, double offX, double offY, double offZ) {
        blockPos = blockPos.add(direction, new TilePos());
        TilePos up = blockPos.up(new TilePos());
        Block<?> b = world.getBlock(blockPos);
        Block<?> bAbove = world.getBlock(up);
        if (b == Blocks.FLUID_WATER_STILL && (bAbove == null || bAbove.hasTag(BlockTags.PLACE_OVERWRITES))) {
            world.setBlockIdNotify(up, this.block.id());
            this.block.onPlacedOnSide(world, up, Side.NONE, 0.5, 0.5);
        }
    }
}

