#version 410 core

#define FOG
#define RADIAL_FOG

in vec4 Color;
in vec2 TexCoord;

out vec4 FragColor;

layout (std140) uniform FogState {
	vec4 color;
	int mode;
	float start;
	float end;
	float density;
} fogState;

layout (std140) uniform Matrices {
	mat4 projection;
	mat4 projectionInv;
	mat4 view;
	mat4 viewInv;
} matrices;

uniform int isEyeInLiquid;
uniform vec2 uViewPortSize;

uniform sampler2D colortex;
uniform sampler2D lighttex;

float distance() {
	vec4 fragPos = matrices.projectionInv * vec4((gl_FragCoord.xy / uViewPortSize) * 2.0 - 1.0, gl_FragCoord.z * 2.0 - 1.0, 1.0);
	fragPos /= fragPos.w;

	return length(fragPos.xyz);
}

void main() {
	vec4 tex = texture(colortex, TexCoord);
	
	// Alpha test
	if(tex.a < 0.1) {
		discard;
	}
	
	// Hide clouds when in water or lava
	if(isEyeInLiquid != 0) {
		discard;
	}
	
	vec4 col = Color;

	float fogStrength = 0.0;

	float end = (fogState.end * 1.5);
	float start = fogState.start / (fogState.end * 1.5);

	fogStrength = distance() / end;
	fogStrength -= start;
	fogStrength /= (1.0 - start);
	fogStrength = clamp(fogStrength, 0.0, 1.0);
	col.a *= 1.0 - fogStrength;
	
	FragColor = tex * col;
}