/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.worldsettings;

import java.util.Objects;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.popup.PopupBuilder;
import net.minecraft.client.gui.popup.PopupScreen;
import net.minecraft.client.gui.worldsettings.ButtonComponent;
import net.minecraft.client.render.window.CursorShape;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.settings.WorldConfiguration;
import net.minecraft.core.world.type.WorldTypeGroups;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldTypeButtonComponent
extends ButtonComponent {
    @Nullable
    private WorldConfiguration worldConfiguration = null;
    @NotNull
    private final ButtonElement button = new ButtonElement(0, 0, 0, 150, 20, "");

    public WorldTypeButtonComponent(@NotNull String translationKey, @Nullable String tooltipTranslationKey) {
        super(translationKey, tooltipTranslationKey);
    }

    public void setWorldConfiguration(@NotNull WorldConfiguration worldConfiguration) {
        this.worldConfiguration = worldConfiguration;
        this.button.displayString = I18n.getInstance().translateKey(this.worldConfiguration.getWorldTypeGroup().get(Dimension.OVERWORLD).getLanguageKey() + ".name");
    }

    @Override
    public void resetValue() {
        Objects.requireNonNull(this.worldConfiguration).setWorldTypeGroup(WorldTypeGroups.DEFAULT);
        this.button.displayString = I18n.getInstance().translateKey(this.worldConfiguration.getWorldTypeGroup().get(Dimension.OVERWORLD).getLanguageKey() + ".name");
    }

    @Override
    public boolean isDefault() {
        return Objects.requireNonNull(this.worldConfiguration).getWorldTypeGroup() == WorldTypeGroups.DEFAULT;
    }

    @Override
    protected void buttonClicked(int mouseButton, int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
        I18n i18n = I18n.getInstance();
        @NotNull String @NotNull [] keys2 = new String[WorldTypeGroups.GROUPS.size()];
        @NotNull String @NotNull [] descs = new String[WorldTypeGroups.GROUPS.size()];
        for (int i = 0; i < keys2.length; ++i) {
            keys2[i] = i18n.translateKey(WorldTypeGroups.GROUPS.get(i).get(Dimension.OVERWORLD).getLanguageKey() + ".name");
            descs[i] = i18n.translateKey(WorldTypeGroups.GROUPS.get(i).get(Dimension.OVERWORLD).getLanguageKey() + ".desc") + "\n" + String.valueOf(TextFormatting.GRAY) + Registries.WORLD_TYPES.getKey(WorldTypeGroups.GROUPS.get(i).get(Dimension.OVERWORLD));
        }
        PopupScreen popup = new PopupBuilder(Objects.requireNonNull(WorldTypeButtonComponent.mc.currentScreen), 150).closeOnEsc(0).closeOnClickOut(0).withLabel("gui.world_settings.label.select_world_type").withList("worldTypeList", 140, keys2, descs, WorldTypeGroups.GROUPS.indexOf(Objects.requireNonNull(this.worldConfiguration).getWorldTypeGroup()), true).withOnCloseListener((statusCode, results) -> {
            if (statusCode == 1) {
                this.worldConfiguration.setWorldTypeGroup(Objects.requireNonNull(WorldTypeGroups.GROUPS.get((Integer)results.get("worldTypeList"))));
                this.button.displayString = I18n.getInstance().translateKey(this.worldConfiguration.getWorldTypeGroup().get(Dimension.OVERWORLD).getLanguageKey() + ".name");
            }
        }).build();
        mc.displayScreen(popup);
    }

    @Override
    protected void renderButton(int x, int y, int relativeButtonX, int relativeButtonY, int buttonWidth, int buttonHeight, int relativeMouseX, int relativeMouseY) {
        super.renderButton(x, y, relativeButtonX, relativeButtonY, buttonWidth, buttonHeight, relativeMouseX, relativeMouseY);
        this.button.xPosition = x + relativeButtonX;
        this.button.yPosition = y + relativeButtonY;
        this.button.width = buttonWidth;
        this.button.height = buttonHeight;
        this.button.drawButton(mc, x + relativeMouseX, y + relativeMouseY);
        if (WorldTypeButtonComponent.mc.currentScreen != null && relativeMouseX >= relativeButtonX && relativeMouseX < relativeButtonX + buttonWidth && relativeMouseY >= relativeButtonY && relativeButtonY < relativeButtonY + buttonHeight) {
            WorldTypeButtonComponent.mc.currentScreen.setDesiredCursor(CursorShape.HAND);
        }
    }
}

