/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import net.minecraft.client.Minecraft;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;

public final class LightingCache {
    private final Minecraft mc = Minecraft.getMinecraft();
    private static final int CACHE_RANGE = 1;
    private static final int CACHE_SIZE = 3;
    private int brightnessCached = 0;
    private final float[] brightnessValue = new float[27];
    private int opacityCached = 0;
    private int opacityValue = 0;
    private int lightmapCoordCached = 0;
    private final int[] lightmapCoordValue = new int[27];
    @NotNull
    private final TilePos offset = new TilePos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    private Block<?> block;
    private WorldSource access;
    @NotNull
    private final TilePos queryPos = new TilePos();

    @Deprecated
    public void setupCache(@NotNull Block<?> block, @NotNull WorldSource source, int x, int y, int z) {
        this.setupCache(block, source, new TilePos(x, y, z));
    }

    public void setupCache(@NotNull Block<?> block, @NotNull WorldSource source, @NotNull TilePosc tilePos) {
        if (!tilePos.equals(this.offset) || this.block != block || this.access != source) {
            this.block = block;
            this.access = source;
            this.brightnessCached = 0;
            this.opacityCached = 0;
            this.lightmapCoordCached = 0;
            this.offset.set(tilePos);
        }
    }

    private float calcBrightness(@NotNull TilePos tilePos) {
        int blockId = this.access.getBlockId(tilePos);
        Block<?> block = Blocks.getBlock(blockId);
        if (this.block.emission >= 15) {
            return 1.0f;
        }
        if (!this.mc.isAmbientOcclusionEnabled()) {
            return 1.0f;
        }
        if (block == null) {
            return 1.0f;
        }
        return 1.0f - block.getAmbientOcclusionStrength(this.access, tilePos);
    }

    public float getBrightness(int relX, int relY, int relZ) {
        int index = (relX + 1) * 3 * 3 + (relY + 1) * 3 + (relZ + 1);
        if (!LightingCache.bitGet(this.brightnessCached, index)) {
            this.brightnessValue[index] = this.calcBrightness(this.offset.add(relX, relY, relZ, this.queryPos));
            this.brightnessCached = LightingCache.bitSet(this.brightnessCached, index);
        }
        return this.brightnessValue[index];
    }

    public boolean getOpacity(int relX, int relY, int relZ) {
        int index = (relX + 1) * 3 * 3 + (relY + 1) * 3 + (relZ + 1);
        if (!LightingCache.bitGet(this.opacityCached, index)) {
            this.opacityValue = LightingCache.bitSetState(this.opacityValue, index, Blocks.solid[this.access.getBlockId(this.offset.add(relX, relY, relZ, this.queryPos))]);
            this.opacityCached = LightingCache.bitSet(this.opacityCached, index);
        }
        return LightingCache.bitGet(this.opacityValue, index);
    }

    public int getLightmapCoord(int relX, int relY, int relZ) {
        int index = (relX + 1) * 3 * 3 + (relY + 1) * 3 + (relZ + 1);
        if (!LightingCache.bitGet(this.lightmapCoordCached, index)) {
            int lightEmission = this.block.emission;
            this.lightmapCoordValue[index] = this.access.getLightmapCoord(this.offset.add(relX, relY, relZ, this.queryPos), lightEmission);
            this.lightmapCoordCached = LightingCache.bitSet(this.lightmapCoordCached, index);
        }
        return this.lightmapCoordValue[index];
    }

    private static boolean bitGet(int value, int index) {
        return (value & 1 << index) != 0;
    }

    private static int bitSet(int value, int index) {
        return value | 1 << index;
    }

    private static int bitSetState(int value, int index, boolean state) {
        if (state) {
            return value | 1 << index;
        }
        return value & ~(1 << index);
    }
}

