/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model.generic;

import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.generic.BlockModelGenericFence;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFence;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class BlockModelGenericFencePainted<T extends BlockLogicFence>
extends BlockModelGenericFence<T> {
    @NotNull
    public final StaticBlockModel[] inventory = new StaticBlockModel[16];
    @NotNull
    public final StaticBlockModel[] post = new StaticBlockModel[16];
    @NotNull
    public final StaticBlockModel[] side = new StaticBlockModel[16];

    public BlockModelGenericFencePainted(@NotNull Block<T> block) {
        super(block, "minecraft:block/fence/white");
        for (DyeColor color : DyeColor.blockOrderedColors()) {
            this.inventory[color.blockMeta] = BlockModelDispatcher.loadDataModel("minecraft:block/fence/" + color.colorID + "/inventory").asModel();
            this.post[color.blockMeta] = BlockModelDispatcher.loadDataModel("minecraft:block/fence/" + color.colorID + "/post").asModel();
            this.side[color.blockMeta] = BlockModelDispatcher.loadDataModel("minecraft:block/fence/" + color.colorID + "/side").asModel();
        }
    }

    @Override
    public boolean renderAttached(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos, boolean cullFaces, @Nullable IconCoordinate overrideTexture) {
        int color = worldSource.getBlockData(tilePos) & 0xF;
        boolean north = ((BlockLogicFence)this.block.getLogic()).canConnectTo(worldSource, tilePos, Side.NORTH);
        boolean south = ((BlockLogicFence)this.block.getLogic()).canConnectTo(worldSource, tilePos, Side.SOUTH);
        boolean west = ((BlockLogicFence)this.block.getLogic()).canConnectTo(worldSource, tilePos, Side.WEST);
        boolean east = ((BlockLogicFence)this.block.getLogic()).canConnectTo(worldSource, tilePos, Side.EAST);
        if (north) {
            this.side[color].renderAttached(this, tessellator, worldSource, tilePos, 0, 0, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
        }
        if (west) {
            this.side[color].renderAttached(this, tessellator, worldSource, tilePos, 0, 1, 0, 0.0, 0.0, 0.0, true, cullFaces, overrideTexture);
        }
        if (south) {
            this.side[color].renderAttached(this, tessellator, worldSource, tilePos, 0, 2, 0, 0.0, 0.0, 0.0, true, cullFaces, overrideTexture);
        }
        if (east) {
            this.side[color].renderAttached(this, tessellator, worldSource, tilePos, 0, 3, 0, 0.0, 0.0, 0.0, true, cullFaces, overrideTexture);
        }
        return this.post[color].renderAttached(this, tessellator, worldSource, tilePos, 0, 0, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
    }

    @Override
    @NotNull
    public StaticBlockModel getModelFromData(int data) {
        return this.inventory[data & 0xF];
    }
}

