/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model.generic;

import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.generic.BlockModelGeneric;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityFurnaceBlast;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class BlockModelGenericFurnace<T extends BlockLogic>
extends BlockModelGeneric<T> {
    public final StaticBlockModel filled;

    public BlockModelGenericFurnace(@NotNull Block<T> block, @NotNull String baseKey) {
        super(block, BlockModelDispatcher.loadDataModel(baseKey));
        this.filled = BlockModelDispatcher.loadDataModel(baseKey + "_filled").asModel();
    }

    @Override
    @NotNull
    public StaticBlockModel getModel(@NotNull WorldSource source, @NotNull TilePosc tilePosc) {
        TileEntity tileEntity = source.getTileEntity(tilePosc);
        if (tileEntity instanceof Container) {
            boolean hasOutput;
            Container container = (Container)((Object)tileEntity);
            if (container instanceof TileEntityFurnaceBlast) {
                hasOutput = container.getItem(3) != null;
            } else {
                boolean bl = hasOutput = container.getItem(2) != null;
            }
            if (hasOutput) {
                return this.filled;
            }
        }
        return super.getModel(source, tilePosc);
    }
}

