/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model.generic;

import net.minecraft.client.render.block.model.generic.BlockModelGenericVeryRotatable;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicVeryRotatable;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.useless.dragonfly.data.block.BlockModelData;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class BlockModelGenericPiston<T extends BlockLogic>
extends BlockModelGenericVeryRotatable<T> {
    @NotNull
    public final StaticBlockModel extended;

    public BlockModelGenericPiston(@NotNull Block<T> block, @NotNull BlockModelData base, @NotNull BlockModelData extended) {
        super(block, base);
        this.extended = extended.asModel();
    }

    public boolean renderHeadless(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePos tilePos) {
        Direction dir = BlockLogicVeryRotatable.metaToDirection(worldSource.getBlockData(tilePos));
        switch (dir) {
            case UP: {
                return this.extended.renderAttached(this, tessellator, worldSource, tilePos, 1, 0, 0, 0.0, 0.0, 0.0, false, false, null);
            }
            case DOWN: {
                return this.extended.renderAttached(this, tessellator, worldSource, tilePos, -1, 0, 0, 0.0, 0.0, 0.0, false, false, null);
            }
            case NORTH: {
                return this.extended.renderAttached(this, tessellator, worldSource, tilePos, 0, 0, 0, 0.0, 0.0, 0.0, false, false, null);
            }
            case SOUTH: {
                return this.extended.renderAttached(this, tessellator, worldSource, tilePos, 0, 2, 0, 0.0, 0.0, 0.0, false, false, null);
            }
            case WEST: {
                return this.extended.renderAttached(this, tessellator, worldSource, tilePos, 0, 1, 0, 0.0, 0.0, 0.0, false, false, null);
            }
            case EAST: {
                return this.extended.renderAttached(this, tessellator, worldSource, tilePos, 0, 3, 0, 0.0, 0.0, 0.0, false, false, null);
            }
        }
        return false;
    }

    @Override
    @NotNull
    public StaticBlockModel getModelFromData(int data) {
        boolean extended = (data & 8) != 0;
        return extended ? this.extended : super.getModelFromData(data);
    }
}

