/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tileentity;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.font.FontRenderer;
import net.minecraft.client.render.font.SF;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.tessellator.TessellatorShader;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicSign;
import net.minecraft.core.block.BlockLogicSignPainted;
import net.minecraft.core.block.IPainted;
import net.minecraft.core.block.entity.TileEntitySign;
import net.minecraft.core.enums.EnumSignPicture;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.joml.primitives.AABBd;
import org.useless.dragonfly.models.entity.StaticEntityModel;

public class TileEntityRendererSign
extends TileEntityRenderer<TileEntitySign> {
    private final Minecraft mc = Minecraft.getMinecraft();
    @NotNull
    private final StringBuilder builder = new StringBuilder();
    private final String[] signColorTextures = new String[16];
    private final BufferedTextMeshRenderer textMeshRenderer = new BufferedTextMeshRenderer();

    public TileEntityRendererSign() {
        for (int i = 0; i < this.signColorTextures.length; ++i) {
            this.signColorTextures[i] = "/assets/minecraft/textures/entity/sign/" + DyeColor.colorFromBlockMeta((int)i).colorID + ".png";
        }
    }

    @Override
    public void doRender(@NotNull TessellatorGeneral t, @NotNull TileEntitySign tileEntity, double x, double y, double z, float partialTick) {
        int colorSign;
        float height;
        StaticEntityModel model;
        Object obj;
        Block<?> block = tileEntity.getBlock();
        if (block == null || !((obj = block.getLogic()) instanceof BlockLogicSign)) {
            return;
        }
        BlockLogicSign sign = (BlockLogicSign)obj;
        GLRenderer.pushFrame();
        float scale = 0.041666668f;
        GLRenderer.modelM4f().translate((float)x + 0.5f, (float)y, (float)z + 0.5f);
        int meta = tileEntity.getBlockMeta();
        if (sign.isFreeStanding) {
            angle = (float)((meta & 0xF) * 360) / 16.0f;
            GLRenderer.modelM4f().rotateY(Math.toRadians(-angle));
            model = this.getModel("post");
            height = 20.0f;
        } else {
            angle = switch (meta & 0xF) {
                case 2 -> 180.0f;
                case 3 -> 0.0f;
                case 4 -> 90.0f;
                default -> -90.0f;
            };
            GLRenderer.modelM4f().rotateY(Math.toRadians(-angle));
            GLRenderer.modelM4f().translate(0.0f, 0.0f, -0.45833334f);
            model = this.getModel("wall");
            height = 13.0f;
        }
        GLRenderer.pushFrame();
        GLRenderer.modelM4f().scale(0.041666668f, 0.041666668f, -0.041666668f);
        if (Block.hasLogicClass(block, BlockLogicSignPainted.class)) {
            DyeColor c = ((IPainted)block.getLogic()).fromMetadata(meta);
            this.bindTexture(this.signColorTextures[c.blockMeta]);
            colorSign = c.color.getARGB();
        } else {
            this.bindTexture("/assets/minecraft/textures/entity/sign.png");
            colorSign = 6905411;
        }
        GLRenderer.disableState(State.BLEND);
        model.render();
        GLRenderer.enableState(State.BLEND);
        GLRenderer.popFrame();
        GLRenderer.pushFrame();
        GLRenderer.enableState(State.BLEND);
        GLRenderer.modelM4f().translate(0.0f, height * 0.041666668f, 0.04375f);
        GLRenderer.setDepthMask(false);
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        EnumSignPicture picture = tileEntity.getPicture();
        if (picture != EnumSignPicture.NONE) {
            TileEntityRendererSign.drawTexturedModalRect(1.0, 0.5, colorSign, TextureRegistry.getTexture(picture.getTextureKey()));
        }
        GLRenderer.disableState(State.BLEND);
        GLRenderer.popFrame();
        FontRenderer sr = this.getFont();
        float lightOffset = 0.0f;
        if (tileEntity.isGlowing()) {
            lightOffset = 96.0f;
            GLRenderer.setLightmapCoord1i(LightmapHelper.getLightmapCoord(15, 15));
        }
        GLRenderer.pushFrame();
        float scale2 = 0.011111113f;
        GLRenderer.modelM4f().translate(0.0f, height * 0.041666668f, 0.045833334f);
        GLRenderer.modelM4f().scale(0.011111113f, -0.011111113f, 0.011111113f);
        GLRenderer.setDepthMask(false);
        int color = Colors.allSignColors[tileEntity.getColor().id].getARGB();
        int r = (int)MathHelper.clamp((float)Color.redFromInt(color) + lightOffset, 0.0f, 255.0f);
        int g = (int)MathHelper.clamp((float)Color.greenFromInt(color) + lightOffset, 0.0f, 255.0f);
        int b = (int)MathHelper.clamp((float)Color.blueFromInt(color) + lightOffset, 0.0f, 255.0f);
        color = Color.intToIntARGB(0, r, g, b);
        CharSequence line1 = tileEntity.signText[0];
        CharSequence line2 = tileEntity.signText[1];
        CharSequence line3 = tileEntity.signText[2];
        CharSequence line4 = tileEntity.signText[3];
        switch (tileEntity.lineBeingEdited) {
            case 0: {
                this.builder.setLength(0);
                line1 = this.builder.append("\u00a7+\u00a7f> \u00a7-").append(line1).append("\u00a7+\u00a7f <\u00a7-");
                break;
            }
            case 1: {
                this.builder.setLength(0);
                line2 = this.builder.append("\u00a7+\u00a7f> \u00a7-").append(line2).append("\u00a7+\u00a7f <\u00a7-");
                break;
            }
            case 2: {
                this.builder.setLength(0);
                line3 = this.builder.append("\u00a7+\u00a7f> \u00a7-").append(line3).append("\u00a7+\u00a7f <\u00a7-");
                break;
            }
            case 3: {
                this.builder.setLength(0);
                line4 = this.builder.append("\u00a7+\u00a7f> \u00a7-").append(line4).append("\u00a7+\u00a7f <\u00a7-");
            }
        }
        boolean _x = false;
        int _y = -tileEntity.signText.length * 5;
        if (tileEntity.isGlowing() && (Integer)this.mc.gameSettings.fancyGraphics.value >= 1) {
            this.textMeshRenderer.render(sr, t, line1, line2, line3, line4, 0, _y, SF.setOutlined(SF.setColor(0L, color)));
        } else {
            this.textMeshRenderer.render(sr, t, line1, line2, line3, line4, 0, _y, SF.setColor(0L, color));
        }
        GLRenderer.popFrame();
        GLRenderer.setDepthMask(true);
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GLRenderer.popFrame();
    }

    private static void drawTexturedModalRect(double width, double height, int color, @NotNull IconCoordinate coordinate) {
        coordinate.parentAtlas.bind();
        TessellatorShader tessellator = GLRenderer.getTessellator();
        tessellator.startDrawingQuads();
        tessellator.setColor2i(color, 128);
        tessellator.addVertexWithUV(-width / 2.0, height / 2.0, 0.0, coordinate.getIconUMin(), coordinate.getIconVMin());
        tessellator.addVertexWithUV(-width / 2.0, -height / 2.0, 0.0, coordinate.getIconUMin(), coordinate.getIconVMax());
        tessellator.addVertexWithUV(width / 2.0, -height / 2.0, 0.0, coordinate.getIconUMax(), coordinate.getIconVMax());
        tessellator.addVertexWithUV(width / 2.0, height / 2.0, 0.0, coordinate.getIconUMax(), coordinate.getIconVMin());
        tessellator.draw();
    }

    @Override
    public void tick() {
        this.textMeshRenderer.tick();
    }

    @Override
    public boolean isVisible(@NotNull TileEntitySign tileEntity, @NotNull ICamera camera, float partialTick) {
        return camera.getFrustum().isVisible(new AABBd(tileEntity.x, tileEntity.y, tileEntity.z, tileEntity.x + 1, tileEntity.y + 1, tileEntity.z + 1), partialTick);
    }

    public static class BufferedTextMeshRenderer {
        private static final long MAX_NON_RENDERED_TIME = 120000L;
        @NotNull
        private final IntList freeDisplayLists = new IntArrayList();
        @NotNull
        private final @NotNull List<@NotNull MeshEntry> bufferedMeshes = new ArrayList<MeshEntry>();
        @NotNull
        private final MeshEntry referenceEntry = new MeshEntry("", "", "", "", 0L);

        public void tick() {
            Iterator<MeshEntry> iterator2 = this.bufferedMeshes.iterator();
            while (iterator2.hasNext()) {
                MeshEntry entry = iterator2.next();
                if (System.currentTimeMillis() - entry.lastUse <= 120000L) continue;
                assert (entry.list != -1);
                this.freeDisplayLists.add(entry.list);
                iterator2.remove();
            }
        }

        public void render(@NotNull FontRenderer sr, @NotNull TessellatorGeneral t, @NotNull CharSequence line1, @NotNull CharSequence line2, @NotNull CharSequence line3, @NotNull CharSequence line4, int x, int y, long config) {
            GLRenderer.pushFrame();
            GLRenderer.modelM4f().translate(x, y, 0.0f);
            this.renderInternal(sr, t, line1, line2, line3, line4, config);
            GLRenderer.popFrame();
        }

        private void renderInternal(@NotNull FontRenderer sr, @NotNull TessellatorGeneral t, @NotNull CharSequence line1, @NotNull CharSequence line2, @NotNull CharSequence line3, @NotNull CharSequence line4, long config) {
            this.referenceEntry.line1 = line1.toString();
            this.referenceEntry.line2 = line2.toString();
            this.referenceEntry.line3 = line3.toString();
            this.referenceEntry.line4 = line4.toString();
            this.referenceEntry.config = config;
            sr.render(line1, -sr.stringWidth(line1) / 2, 0).setConfig(config).call();
            sr.render(line2, -sr.stringWidth(line2) / 2, 10).setConfig(config).call();
            sr.render(line3, -sr.stringWidth(line3) / 2, 20).setConfig(config).call();
            sr.render(line4, -sr.stringWidth(line4) / 2, 30).setConfig(config).call();
        }

        public static class MeshEntry {
            public long config;
            @NotNull
            public String line1;
            @NotNull
            public String line2;
            @NotNull
            public String line3;
            @NotNull
            public String line4;
            public long lastUse = 0L;
            public int list = -1;

            public MeshEntry(@NotNull CharSequence line1, @NotNull CharSequence line2, @NotNull CharSequence line3, @NotNull CharSequence line4, long config) {
                this.config = config;
                this.line1 = line1.toString();
                this.line2 = line2.toString();
                this.line3 = line3.toString();
                this.line4 = line4.toString();
            }

            public boolean equals(Object o) {
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                MeshEntry entry = (MeshEntry)o;
                return this.config == entry.config && this.line1.equals(entry.line1) && this.line2.equals(entry.line2) && this.line3.equals(entry.line3) && this.line4.equals(entry.line4);
            }

            public int hashCode() {
                int result = Long.hashCode(this.config);
                result = 31 * result + this.line1.hashCode();
                result = 31 * result + this.line2.hashCode();
                result = 31 * result + this.line3.hashCode();
                result = 31 * result + this.line4.hashCode();
                return result;
            }
        }
    }
}

