/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicLeavesCherry;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.IBonemealable;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePosc;
import net.minecraft.core.world.season.Seasons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicLeavesCherryFlowering
extends BlockLogicLeavesCherry
implements IBonemealable {
    public static final int MASK_GROWTH_DATA = 240;
    public static final int MAX_GROWTH_STATE = 1;

    public BlockLogicLeavesCherryFlowering(@NotNull Block<?> block) {
        super(block);
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        int growthRate = BlockLogicLeavesCherryFlowering.getGrowthRate(data);
        if (dropCause == EnumDropCause.PICK_BLOCK || dropCause == EnumDropCause.SILK_TOUCH) {
            return new ItemStack[]{new ItemStack(this)};
        }
        if (growthRate == 0) {
            return null;
        }
        return new ItemStack[]{new ItemStack(Items.FOOD_CHERRY, world.rand.nextInt(2) + 1)};
    }

    @Override
    public void onAttacked(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @NotNull Side side, double xHit, double yHit) {
        this.onInteracted(world, tilePos, player, side, xHit, yHit);
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        return this.harvest(world, tilePos, player);
    }

    public boolean harvest(@NotNull World world, @NotNull TilePosc tilePos, @Nullable Player player) {
        int meta = world.getBlockData(tilePos);
        int growthRate = BlockLogicLeavesCherryFlowering.getGrowthRate(meta);
        if (growthRate > 0) {
            if (player != null) {
                world.playSoundAtEntity(player, player, "item.pickup", 1.0f, 1.0f);
            }
            if (!world.isClientSide) {
                this.dropWithCause(world, EnumDropCause.WORLD, tilePos, meta, null, null);
            }
            world.setBlockDataNotify(tilePos, BlockLogicLeavesCherryFlowering.setGrowthRate(meta, 0));
            world.scheduleBlockUpdate(tilePos, Blocks.LEAVES_CHERRY_FLOWERING.id(), this.tickDelay());
            return true;
        }
        return false;
    }

    @Override
    public void onActivatorInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull TileEntityActivator activator, @NotNull Direction direction) {
        this.harvest(world, tilePos, null);
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand, boolean isRandomTick) {
        super.updateTick(world, tilePos, rand, isRandomTick);
        int meta = world.getBlockData(tilePos);
        int growthRate = BlockLogicLeavesCherryFlowering.getGrowthRate(meta);
        if (world.getSeasonManager().getCurrentSeason() == Seasons.OVERWORLD_SPRING) {
            if (rand.nextInt(20) == 0 && growthRate == 0) {
                world.setBlockDataNotify(tilePos, BlockLogicLeavesCherryFlowering.setGrowthRate(meta, 1));
                world.scheduleBlockUpdate(tilePos, Blocks.LEAVES_CHERRY_FLOWERING.id(), this.tickDelay());
            }
        } else if (growthRate > 0) {
            world.setBlockDataNotify(tilePos, meta & 0xF);
            world.scheduleBlockUpdate(tilePos, Blocks.LEAVES_CHERRY_FLOWERING.id(), this.tickDelay());
        }
    }

    @Override
    public boolean onBonemealUsed(@NotNull ItemStack itemStack, @Nullable Player player, @NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        int meta = world.getBlockData(tilePos);
        if (BlockLogicLeavesCherryFlowering.getGrowthRate(meta) == 0) {
            if (!world.isClientSide) {
                if (world.getSeasonManager().getCurrentSeason() != Seasons.OVERWORLD_SPRING) {
                    return true;
                }
                world.setBlockDataNotify(tilePos, BlockLogicLeavesCherryFlowering.setGrowthRate(meta, 1));
                if (player == null || player.getGamemode().hasBlockConsumption()) {
                    --itemStack.stackSize;
                }
            }
            return true;
        }
        return false;
    }

    public static int getGrowthRate(int meta) {
        return (meta & 0xF0) >> 4;
    }

    public static int setGrowthRate(int meta, int growthRate) {
        return meta & 0xFFFFFF0F | growthRate << 4 & 0xF0;
    }
}

