/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicMesh;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityMeshGold;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicMeshGold
extends BlockLogicMesh {
    public BlockLogicMeshGold(@NotNull Block<?> block) {
        super(block);
        block.withEntity(TileEntityMeshGold::new);
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        TileEntity tileEntity = world.getTileEntity(tilePos);
        if (tileEntity instanceof TileEntityMeshGold) {
            TileEntityMeshGold meshGold = (TileEntityMeshGold)tileEntity;
            ItemStack heldItem = player.getHeldItem();
            boolean flag = meshGold.setFilterItem(player, heldItem);
            world.notifyBlocksOfNeighborChange(tilePos, this.id());
            if (heldItem != null && heldItem.stackSize <= 0) {
                player.inventory.setItem(player.inventory.getCurrentSlot(), null);
            }
            return flag;
        }
        return false;
    }

    @Override
    public boolean collidesWithEntity(@NotNull Entity entity, @NotNull World world, @NotNull TilePosc tilePos) {
        if (entity instanceof EntityItem) {
            EntityItem entityItem = (EntityItem)entity;
            TileEntity tileEntity = world.getTileEntity(tilePos);
            if (tileEntity instanceof TileEntityMeshGold) {
                TileEntityMeshGold meshGold = (TileEntityMeshGold)tileEntity;
                if (meshGold.filterItem == null) {
                    return true;
                }
                ItemStack entityStack = entityItem.item;
                return !this.stacksAreSame(entityStack, meshGold.filterItem);
            }
        }
        return true;
    }

    @Override
    public boolean isEquivalent(@NotNull World world, @NotNull TilePosc thisPos, @NotNull TilePosc thatPos) {
        if (super.isEquivalent(world, thisPos, thatPos)) {
            TileEntity thisEntity = world.getTileEntity(thisPos);
            TileEntity otherEntity = world.getTileEntity(thatPos);
            if (thisEntity instanceof TileEntityMeshGold) {
                TileEntityMeshGold thisMesh = (TileEntityMeshGold)thisEntity;
                if (otherEntity instanceof TileEntityMeshGold) {
                    TileEntityMeshGold otherMesh = (TileEntityMeshGold)otherEntity;
                    return this.stacksAreSame(thisMesh.filterItem, otherMesh.filterItem);
                }
            }
        }
        return false;
    }

    public boolean stacksAreSame(@Nullable ItemStack a, @Nullable ItemStack b) {
        return a == b || a != null && b != null && a.itemID == b.itemID && a.getMetadata() == b.getMetadata() && a.getData().equals(b.getData());
    }
}

