/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFlower;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicMushroom
extends BlockLogicFlower {
    public BlockLogicMushroom(@NotNull Block<?> block) {
        super(block);
        float f = 0.2f;
        this.setBlockBounds(0.5f - f, 0.0, 0.5f - f, 0.5f + f, f * 2.0f, 0.5f + f);
        block.setTicking(true);
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand, boolean isRandomTick) {
        TilePos checkPos;
        if (rand.nextInt(25) == 0 && world.isAirBlock(checkPos = tilePos.add(rand.nextInt(3) - 1, rand.nextInt(2) - rand.nextInt(2), rand.nextInt(3) - 1, new TilePos())) && this.canStay(world, checkPos)) {
            checkPos.set(tilePos.x() + rand.nextInt(3) - 1, checkPos.y, tilePos.z() + rand.nextInt(3) - 1);
            if (world.isAirBlock(checkPos) && this.canStay(world, checkPos)) {
                world.setBlockIdNotify(checkPos, this.block.id());
            }
        }
    }

    @Override
    protected boolean mayPlaceOn(int blockId) {
        return Blocks.solid[blockId];
    }

    @Override
    public boolean canStay(@NotNull World world, @NotNull TilePosc tilePos) {
        if (tilePos.y() < 0 || tilePos.y() >= world.getHeightBlocks()) {
            return false;
        }
        return world.getFullBlockLightValue(tilePos) < 13 && this.mayPlaceOn(world.getBlockId(tilePos.down(new TilePos())));
    }

    @Override
    public boolean onBonemealUsed(@NotNull ItemStack itemStack, @Nullable Player player, @NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        Random rand = world.rand;
        if (!world.isClientSide && this.canBeBonemealed) {
            if (player == null || player.getGamemode().hasBlockConsumption()) {
                --itemStack.stackSize;
            }
            TilePos queryPos = new TilePos();
            block0: for (int j1 = 0; j1 < 32; ++j1) {
                int checkX = tilePos.x();
                int checkY = tilePos.y();
                int checkZ = tilePos.z();
                for (int j2 = 0; j2 < j1 / 16; ++j2) {
                    if (world.getFullBlockLightValue(queryPos.set(checkX += rand.nextInt(3) - 1, checkY += (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, checkZ += rand.nextInt(3) - 1)) >= 13 || !this.mayPlaceOn(world.getBlockId(queryPos.set(checkX, checkY - 1, checkZ)))) continue block0;
                }
                if (world.getBlockId(queryPos.set(checkX, checkY, checkZ)) != 0 || !((double)rand.nextFloat() > 0.85)) continue;
                world.setBlockIdNotify(queryPos.set(checkX, checkY, checkZ), this.block.id());
            }
            return true;
        }
        return this.canBeBonemealed;
    }
}

