/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.net.thread;

import com.b100.utils.FileUtils;
import com.b100.utils.StreamUtils;
import com.b100.utils.StringUtils;
import com.b100.xml.XmlFile;
import com.b100.xml.XmlParser;
import com.b100.xml.element.XmlContentTag;
import com.b100.xml.element.XmlTag;
import com.mojang.logging.LogUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.sound.SoundEngine;
import net.minecraft.client.sound.SoundRepository;
import net.minecraft.core.net.CertificateHelper;
import org.slf4j.Logger;

public class ThreadDownloadResources
extends Thread {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static String[] extractFiles = new String[]{"ui/ui_back.ogg", "ui/ui_click.ogg", "ui/ui_focus.ogg", "ui/ui_scroll.ogg", "ui/crafting_fail.ogg", "ui/crafting_made.ogg"};
    public static String resourceDomain = "https://api.betterthanadventure.net/MinecraftResources/";
    public final Minecraft mc;
    public File resourcesFolder;
    public volatile ThreadDownloadState downloading = ThreadDownloadState.IDLE;
    public volatile long timeOfError = -1L;
    public AtomicInteger downloadProgress = new AtomicInteger(0);
    public volatile int toDownload;

    public ThreadDownloadResources(File file, Minecraft minecraft) {
        super("Resource Download");
        this.mc = minecraft;
        this.setDaemon(true);
        this.resourcesFolder = new File(file, "resources/");
        if (!this.resourcesFolder.exists() && !this.resourcesFolder.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + String.valueOf(this.resourcesFolder));
        }
    }

    @Override
    public void run() {
        try {
            for (String extractResource : extractFiles) {
                File output = new File(this.resourcesFolder, "minecraft/sounds/" + extractResource);
                if (output.exists()) continue;
                StreamUtils.transferDataAndClose(ThreadDownloadResources.class.getResourceAsStream("/assets/minecraft/sounds/" + extractResource), Files.newOutputStream(FileUtils.createNewFile(output).toPath(), new OpenOption[0]));
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception when copying 'sound/ui/' files to resources!", e);
        }
        try {
            if (((Boolean)this.mc.gameSettings.downloadSoundfiles.value).booleanValue()) {
                LOGGER.info("Downloading sounds...");
                try {
                    this.downloadResources();
                }
                catch (Exception e) {
                    this.downloading = ThreadDownloadState.ERROR;
                    this.timeOfError = System.currentTimeMillis();
                    LOGGER.error("Error downloading sounds...", e);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error downloading sounds", e);
        }
    }

    public void downloadResources() {
        XmlFile file;
        String xmlString = StringUtils.getWebsiteContentAsString(resourceDomain);
        try {
            file = (XmlFile)new XmlParser().parseWebsite(resourceDomain);
        }
        catch (Exception e) {
            File xmlFile = new File("error.xml").getAbsoluteFile();
            StringUtils.saveStringToFile(xmlFile, xmlString);
            throw new RuntimeException("XML Parse Error. The content of the XML file is saved to " + xmlFile.getAbsolutePath(), e);
        }
        XmlContentTag content = file.getRootElement().getAsContentTag();
        ArrayList<SoundEntry> entries = new ArrayList<SoundEntry>();
        for (XmlTag tag : (List)content.content()) {
            if (!tag.name().equals("Contents")) continue;
            String name = (String)tag.getAsContentTag().get("Key").getAsStringTag().content();
            String fileName = this.remapDirectory(name);
            long size = tag.getAsContentTag().get("Size").getAsStringTag().getLong();
            File soundFile = new File(this.resourcesFolder, "minecraft/sounds/" + fileName);
            soundFile.mkdirs();
            if (soundFile.isFile() && (((Boolean)this.mc.gameSettings.allowSoundOverrides.value).booleanValue() || soundFile.length() == size)) continue;
            entries.add(new SoundEntry(soundFile, name, size));
        }
        if (entries.isEmpty()) {
            return;
        }
        this.downloading = ThreadDownloadState.DOWNLOADING;
        this.toDownload = entries.size();
        for (SoundEntry soundEntry : entries) {
            try {
                this.downloadSoundFile(soundEntry.name, soundEntry.file);
                this.downloadProgress.incrementAndGet();
            }
            catch (Exception e) {
                throw new RuntimeException("Error downloading sound file: " + soundEntry.name, e);
            }
        }
        SoundRepository.reload();
        this.mc.sndManager.destroy();
        this.mc.sndManager = new SoundEngine();
        this.mc.sndManager.init(this.mc.gameSettings);
        this.downloading = ThreadDownloadState.IDLE;
    }

    private String remapDirectory(String path) {
        if (path.startsWith("newsound/")) {
            path = path.replaceFirst("newsound/", "");
        }
        if (path.startsWith("sound/")) {
            path = path.replaceFirst("sound/", "");
        }
        if (path.startsWith("streaming/")) {
            path = path.replaceFirst("streaming/", "record/");
        }
        if (path.startsWith("newmusic/")) {
            path = path.replaceFirst("newmusic/", "music/");
        }
        return path;
    }

    private void downloadSoundFile(String name, File file) throws Exception {
        Object url = resourceDomain + name;
        url = ((String)url).replace(" ", "%20");
        LOGGER.info("Downloading File: {}", url);
        StreamUtils.transferDataAndClose(new BufferedInputStream(CertificateHelper.getWebsiteAsStream((String)url)), new BufferedOutputStream(Files.newOutputStream(FileUtils.createNewFile(file).toPath(), new OpenOption[0])));
    }

    public static enum ThreadDownloadState {
        IDLE,
        DOWNLOADING,
        ERROR;

    }

    private static class SoundEntry {
        private final File file;
        private final String name;
        private final long size;

        public SoundEntry(File file, String name, long size) {
            this.file = file;
            this.name = name;
            this.size = size;
        }
    }
}

