/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicDoor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.joml.primitives.AABBdc;

public class BlockModelDoor<T extends BlockLogicDoor>
extends BlockModelStandard<T> {
    public BlockModelDoor(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        tessellator.setLightmapCoord1i(LightmapHelper.getLightmapCoord(15, 15));
        tessellator.setColorOpaque3f(1.0f, 1.0f, 1.0f);
        AABBdc bounds = this.block.getBoundsFromState(worldSource, tilePos);
        TilePos queryPos = new TilePos();
        boolean aboveIsDoor = Block.hasLogicClass(worldSource.getBlock(tilePos.up(queryPos)), BlockLogicDoor.class);
        boolean belowIsDoor = Block.hasLogicClass(worldSource.getBlock(tilePos.down(queryPos)), BlockLogicDoor.class);
        int meta = worldSource.getBlockData(tilePos);
        if (!belowIsDoor) {
            renderBlocks.renderBottomFace(tessellator, bounds, tilePos, this.getBlockTexture(worldSource, tilePos, Side.BOTTOM));
        }
        if (!aboveIsDoor) {
            renderBlocks.renderTopFace(tessellator, bounds, tilePos, this.getBlockTexture(worldSource, tilePos, Side.TOP));
        }
        BlockModelDoor.renderBlocks.flipTexture = this.shouldFlipTexture(Side.NORTH, meta);
        IconCoordinate texture = this.getBlockTexture(worldSource, tilePos, Side.NORTH);
        renderBlocks.renderNorthFace(tessellator, bounds, tilePos, texture);
        BlockModelDoor.renderBlocks.flipTexture = false;
        BlockModelDoor.renderBlocks.flipTexture = this.shouldFlipTexture(Side.SOUTH, meta);
        texture = this.getBlockTexture(worldSource, tilePos, Side.SOUTH);
        renderBlocks.renderSouthFace(tessellator, bounds, tilePos, texture);
        BlockModelDoor.renderBlocks.flipTexture = false;
        BlockModelDoor.renderBlocks.flipTexture = this.shouldFlipTexture(Side.WEST, meta);
        texture = this.getBlockTexture(worldSource, tilePos, Side.WEST);
        renderBlocks.renderWestFace(tessellator, bounds, tilePos, texture);
        BlockModelDoor.renderBlocks.flipTexture = false;
        BlockModelDoor.renderBlocks.flipTexture = this.shouldFlipTexture(Side.EAST, meta);
        texture = this.getBlockTexture(worldSource, tilePos, Side.EAST);
        renderBlocks.renderEastFace(tessellator, bounds, tilePos, texture);
        BlockModelDoor.renderBlocks.flipTexture = false;
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    protected boolean shouldFlipTexture(@NotNull Side side, int meta) {
        if (side == Side.TOP || side == Side.BOTTOM) {
            return false;
        }
        int state = ((BlockLogicDoor)this.block.getLogic()).getRotation(meta);
        int l = state / 2 + (side.getId() & 1 ^ state);
        if ((state == 0 || state == 2) ^ side.getId() <= 3) {
            return false;
        }
        return ((l += (meta & 4) / 4) & 1) != 0;
    }
}

