/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model.generic;

import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.DisplayPos;
import org.useless.dragonfly.data.block.BlockModelData;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class BlockModelGeneric<T extends BlockLogic>
extends BlockModel<T> {
    @NotNull
    public final StaticBlockModel staticModel;
    public boolean render3d = true;
    public boolean forceCullSelf = false;

    public BlockModelGeneric(@NotNull Block<T> block, @NotNull StaticBlockModel staticModel) {
        super(block);
        this.staticModel = staticModel;
    }

    public BlockModelGeneric(@NotNull Block<T> block, @NotNull BlockModelData staticModel) {
        super(block);
        this.staticModel = staticModel.asModel();
    }

    @NotNull
    public BlockModelGeneric<T> render3D(boolean flag) {
        this.render3d = flag;
        return this;
    }

    @NotNull
    public BlockModelGeneric<T> forceCullSelf(boolean flag) {
        this.forceCullSelf = flag;
        return this;
    }

    @Override
    public final boolean renderNoCulling(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        return this.renderAttached(tessellator, worldSource, tilePos, false, null);
    }

    @Override
    public final boolean render(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        return this.renderAttached(tessellator, worldSource, tilePos, true, null);
    }

    @Override
    public final boolean renderWithOverrideTexture(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos, IconCoordinate overrideTexture) {
        return this.renderAttached(tessellator, worldSource, tilePos, true, overrideTexture);
    }

    public boolean renderAttached(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos, boolean cullFaces, @Nullable IconCoordinate overrideTexture) {
        return this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 0, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
    }

    @Override
    public void renderStandalone(@NotNull TessellatorGeneral tessellator, int metadata, int lightmapCoord) {
        this.getModelFromData(metadata).renderStandalone(this, tessellator, 0.0, 0.0, 0.0, metadata, lightmapCoord, (BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block));
    }

    @NotNull
    public StaticBlockModel getModel(@NotNull WorldSource source, @NotNull TilePosc tilePosc) {
        return this.getModelFromData(source.getBlockData(tilePosc));
    }

    @NotNull
    public StaticBlockModel getModelFromData(int data) {
        return this.staticModel;
    }

    @Override
    public boolean shouldItemRender3d() {
        return this.render3d;
    }

    @Override
    @NotNull
    public DisplayPos getItemDisplayPos(@NotNull String id) {
        return this.staticModel.getItemDisplayPos(id);
    }

    @Override
    public int renderLayer() {
        return this.staticModel.renderLayer();
    }

    public boolean cullSide(@NotNull WorldSource worldSource, @NotNull TilePosc blockPos, @Nullable Direction direction) {
        if (direction != null) {
            TilePos shifted = blockPos.add(direction, new TilePos());
            if (this.forceCullSelf) {
                return worldSource.getBlock(shifted) == this.block || worldSource.isBlockOpaqueCube(shifted);
            }
            return worldSource.isBlockOpaqueCube(shifted);
        }
        return false;
    }

    @Override
    @Nullable
    public IconCoordinate getParticleTexture(@NotNull Side side, int meta) {
        return this.getModelFromData(meta).getParticle(side);
    }

    @Override
    @Nullable
    public IconCoordinate getOverlayTexture(int meta) {
        return this.getModelFromData(meta).getOverlay();
    }

    @Override
    public int particleColorIndex(@NotNull WorldSource worldSource, @NotNull TilePosc tilePos, @NotNull Side side, int meta) {
        return this.getModel(worldSource, tilePos).particleColorIndex(side);
    }
}

