/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.texture.stitcher;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.URISyntaxException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.customatlas.CustomAtlasHandler;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.texturepack.TexturePack;
import net.minecraft.client.util.helper.Textures;
import net.minecraft.core.util.collection.NamespaceID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.lwjgl.opengl.GL41;
import org.slf4j.Logger;

public class AtlasStitcher {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String rootAssetPath = "/assets";
    @NotNull
    public Map<NamespaceID, IconCoordinate> iconMap = new Object2ObjectOpenHashMap<NamespaceID, IconCoordinate>();
    @NotNull
    public Map<String, String> idDirMap = new Object2ObjectOpenHashMap<String, String>();
    @NotNull
    public Map<String, String> layerPostfixMap = new Object2ObjectOpenHashMap<String, String>();
    @NotNull
    public Map<String, BufferedImage> layerImageMap = new Object2ObjectOpenHashMap<String, BufferedImage>();
    @NotNull
    public Map<String, Texture> layerTextureMap = new Object2ObjectOpenHashMap<String, Texture>();
    @NotNull
    public Object2IntMap<String> layerDefaultColorMap = new Object2IntOpenHashMap<String>();
    public BufferedImage colorImage;
    @NotNull
    public final Texture colorTexture;
    private int atlasWidth;
    private int atlasHeight;
    private double invWidth;
    private double invHeight;
    private final boolean mipmap;
    private final boolean tickPaused;
    private final List<Box> boxes = new ObjectArrayList<Box>();

    public AtlasStitcher(boolean tickWhenPaused, boolean mipmap) {
        this.tickPaused = tickWhenPaused;
        this.mipmap = mipmap;
        this.addLayer("color", "", -65281);
        this.colorTexture = this.layerTextureMap.get("color");
    }

    @NotNull
    public AtlasStitcher addDirectory(@NotNull String id, @NotNull String path) {
        this.idDirMap.put(id, path);
        return this;
    }

    @NotNull
    public AtlasStitcher addLayer(@NotNull String id, @NotNull String filePostfix, int defaultColor) {
        this.layerPostfixMap.put(id, filePostfix);
        this.layerTextureMap.put(id, new Texture());
        this.layerDefaultColorMap.put(id, defaultColor);
        return this;
    }

    @NotNull
    protected IconCoordinate getTexture(@NotNull NamespaceID id) {
        IconCoordinate cached = this.iconMap.get(id);
        if (cached != null) {
            return cached;
        }
        IconCoordinate iconCoordinate = new IconCoordinate(this, id);
        this.iconMap.put(id, iconCoordinate);
        return iconCoordinate;
    }

    @NotNull
    public String getSourceImageId(@NotNull NamespaceID id) {
        String value = id.value();
        int slashIndex = value.indexOf("/");
        if (slashIndex != -1) {
            String dir = this.idDirMap.get(value.substring(0, slashIndex));
            return String.format("%s/%s/%s/%s", rootAssetPath, id.namespace(), dir, value.substring(slashIndex + 1));
        }
        throw new IllegalArgumentException("Id " + String.valueOf(id) + " does not specify an id!");
    }

    public void initializeAll(@NotNull String namespace, boolean searchSubDirectories) throws IOException, URISyntaxException {
        for (Map.Entry<String, String> e : this.idDirMap.entrySet()) {
            String[] paths;
            String folder = String.format("%s/%s/%s/", rootAssetPath, namespace, e.getValue());
            for (String p : paths = TextureRegistry.getFilesAndSubFiles(folder, searchSubDirectories)) {
                if (!p.contains(".") || p.lastIndexOf(".") != p.indexOf(".")) continue;
                this.getTexture(new NamespaceID(namespace, e.getKey() + "/" + p.replace(".png", "")));
            }
        }
    }

    public void preinit() {
        this.boxes.clear();
        for (IconCoordinate coordinate : this.iconMap.values()) {
            Box box = new Box(Minecraft.getMinecraft(), this, coordinate, null);
            this.boxes.add(box);
            coordinate.setDimension(box.image.getWidth(), box.image.getHeight());
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void init() {
        maxWidth = 0;
        maxHeight = 0;
        for (Box box : this.boxes) {
            maxWidth = Math.max(maxWidth, box.coord.width + box.border * 2);
            maxHeight = Math.max(maxHeight, box.coord.height + box.border * 2);
        }
        this.boxes.sort((Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$init$0(net.minecraft.client.render.texture.stitcher.AtlasStitcher$Box net.minecraft.client.render.texture.stitcher.AtlasStitcher$Box ), (Lnet/minecraft/client/render/texture/stitcher/AtlasStitcher$Box;Lnet/minecraft/client/render/texture/stitcher/AtlasStitcher$Box;)I)());
        atlasWidth = Math.max(Integer.highestOneBit(maxWidth) << 1, 256);
        atlasHeight = Math.max(Integer.highestOneBit(maxHeight) << 1, 256);
        spaces = new ObjectArrayList<Object>();
        spaces.add(new Space(0, 0, atlasWidth, atlasHeight));
        packed = new ObjectArrayList<K>();
        block1: for (Box box : this.boxes) {
            while (true) lbl-1000:
            // 4 sources

            {
                for (i = spaces.size() - 1; i >= 0; --i) {
                    space = (Space)spaces.get(i);
                    if (box.coord.width + box.border * 2 > space.w || box.coord.height + box.border * 2 > space.h) continue;
                    packed.add(box);
                    box.x = space.x;
                    box.y = space.y;
                    if (box.coord.width + box.border * 2 == space.w && box.coord.height + box.border * 2 == space.h) {
                        last = (Space)spaces.remove(spaces.size() - 1);
                        if (i >= spaces.size()) continue block1;
                        spaces.set(i, last);
                        continue block1;
                    }
                    if (box.coord.height == space.h) {
                        space.x += box.coord.width + box.border * 2;
                        space.w -= box.coord.width + box.border * 2;
                        continue block1;
                    }
                    if (box.coord.width + box.border * 2 == space.w) {
                        space.y += box.coord.height + box.border * 2;
                        space.h -= box.coord.height + box.border * 2;
                        continue block1;
                    }
                    spaces.add(new Space(space.x + box.coord.width + box.border * 2, space.y, space.w - (box.coord.width + box.border * 2), box.coord.height + box.border * 2));
                    space.y += box.coord.height + box.border * 2;
                    space.h -= box.coord.height + box.border * 2;
                    continue block1;
                }
                if (atlasWidth <= atlasHeight) {
                    spaces.add(0, new Space(atlasWidth, 0, atlasWidth, atlasHeight));
                    atlasWidth *= 2;
                    ** continue;
                }
                spaces.add(0, new Space(0, atlasHeight, atlasWidth, atlasHeight));
                atlasHeight *= 2;
            }
        }
        for (Box box : packed) {
            box.coord.setPosition(box.x, box.y);
        }
        for (Map.Entry e : this.layerPostfixMap.entrySet()) {
            atlas = new BufferedImage(atlasWidth, atlasHeight, 2);
            g = atlas.createGraphics();
            this.layerImageMap.put((String)e.getKey(), atlas);
            for (Box box : packed) {
                image = this.getImage((String)e.getKey(), box.coord);
                _subImage = new BufferedImage(box.coord.width, box.coord.height, 2);
                _subImage.setRGB(0, 0, _subImage.getWidth(), _subImage.getHeight(), image.getRGB(0, 0, _subImage.getWidth(), _subImage.getHeight(), new int[_subImage.getWidth() * _subImage.getHeight()], 0, _subImage.getWidth()), 0, _subImage.getWidth());
                g.drawImage((Image)_subImage, box.x, box.y, null);
            }
            g.dispose();
            t = this.layerTextureMap.get(e.getKey());
            if (!t.isGenerated()) {
                t.generate();
            }
            t.setupTexture(atlas, false, false, this.mipmap);
        }
        this.colorImage = this.layerImageMap.get("color");
        this.atlasWidth = atlasWidth;
        this.atlasHeight = atlasHeight;
        this.invWidth = 1.0 / (double)this.atlasWidth;
        this.invHeight = 1.0 / (double)this.atlasHeight;
        for (Box box : packed) {
            box.coord.cacheUVs();
        }
    }

    public BufferedImage getImage(@NotNull String layer, @NotNull IconCoordinate coordinate) {
        TexturePack pack;
        String source = this.getSourceImageId(coordinate.namespaceId);
        String postfix = this.layerPostfixMap.getOrDefault(layer, "");
        String path = postfix.isEmpty() ? source + ".png" : source + "." + postfix + ".png";
        BufferedImage image = CustomAtlasHandler.getTextureOverride(Minecraft.getMinecraft().texturePackList, source + "png");
        if (image == null && (pack = Minecraft.getMinecraft().texturePackList.getHighestPriorityTexturePackWithFile(source + ".png")) != null) {
            for (int attempt = 0; attempt < 3; ++attempt) {
                try {
                    image = Textures.readImageUnhandled(pack.getResourceAsStream(path));
                    if (image == null) continue;
                    break;
                }
                catch (Exception e) {
                    LOGGER.error("", e);
                }
            }
        }
        if (image == null || image == Textures.missingTexture) {
            image = new BufferedImage(coordinate.width, coordinate.height, 2);
            int defaultColor = this.layerDefaultColorMap.getOrDefault((Object)layer, -65281);
            for (int x = 0; x < image.getWidth(); ++x) {
                for (int y = 0; y < image.getHeight(); ++y) {
                    image.setRGB(x, y, defaultColor);
                }
            }
            return image;
        }
        return image;
    }

    public int[] getIconData(@NotNull String layer, @NotNull IconCoordinate coordinate, int[] dest) {
        BufferedImage img = this.layerImageMap.get(layer);
        if (img != null) {
            assert (dest.length >= coordinate.getArea());
            img.getRGB(coordinate.iconX, coordinate.iconY, coordinate.width, coordinate.height, dest, 0, coordinate.width);
        }
        return dest;
    }

    public void bind() {
        this.colorTexture.bind();
    }

    public void bind(@NotNull String layer) {
        Texture t = this.layerTextureMap.get(layer);
        if (t != null) {
            t.bind();
        } else {
            GL41.glBindTexture(3553, 0);
        }
    }

    public int getAtlasWidth() {
        return this.atlasWidth;
    }

    public int getAtlasHeight() {
        return this.atlasHeight;
    }

    public double getInverseWidth() {
        return this.invWidth;
    }

    public double getInverseHeight() {
        return this.invHeight;
    }

    public boolean tickWhenPaused() {
        return this.tickPaused;
    }

    public boolean hasMipmaps() {
        return this.mipmap;
    }

    private static /* synthetic */ int lambda$init$0(Box o1, Box o2) {
        int diff = o2.coord.height - o1.coord.height;
        if (diff != 0) {
            return diff;
        }
        return o1.coord.namespaceId.compareTo(o2.coord.namespaceId);
    }

    private static class Box {
        private int x;
        private int y;
        private int border;
        @NotNull
        private final IconCoordinate coord;
        @NotNull
        private final BufferedImage image;
        @Nullable
        private TexturePack pack;

        public Box(@NotNull Minecraft mc, @NotNull AtlasStitcher atlasStitcher, @NotNull IconCoordinate coordinate, @Nullable BufferedImage defaultTexture) {
            TexturePack pack;
            coordinate.resetMetadata();
            String path = atlasStitcher.getSourceImageId(coordinate.namespaceId) + ".png";
            BufferedImage image = CustomAtlasHandler.getTextureOverride(mc.texturePackList, path);
            if (image == null && (pack = mc.texturePackList.getHighestPriorityTexturePackWithFile(path)) != null) {
                String metaPath;
                this.pack = pack;
                for (int attempt = 0; attempt < 3; ++attempt) {
                    try {
                        image = Textures.readImageUnhandled(pack.getResourceAsStream(path));
                        if (image == null) continue;
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.error("", e);
                    }
                }
                if (pack.hasFile(metaPath = path + ".mcmeta")) {
                    try (InputStream stream = pack.getResourceAsStream(metaPath);){
                        coordinate.initMetadata(stream);
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to initiate metadata for '{}'!", (Object)coordinate.namespaceId, (Object)e);
                    }
                }
            }
            if (image == null || image == Textures.missingTexture) {
                LOGGER.warn("{} could not be found!", (Object)path);
                if (defaultTexture != null) {
                    image = defaultTexture;
                }
                if (image == null) {
                    image = Textures.missingTexture;
                }
            }
            this.image = image;
            this.coord = coordinate;
        }

        public Box(int x, int y, int border, @NotNull IconCoordinate coord, @NotNull BufferedImage image, @NotNull TexturePack pack) {
            this.x = x;
            this.y = y;
            this.border = border;
            this.coord = coord;
            this.image = image;
            this.pack = pack;
        }
    }

    private static class Space {
        private int x;
        private int y;
        private int w;
        private int h;

        public Space(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }
    }
}

