/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.support;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ISupportable {
    @NotNull
    public ISupport getSupportConstraint(@NotNull World var1, @NotNull TilePosc var2, @NotNull Side var3);

    default public boolean isSupported(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        @Nullable Block<?> supportingBlock = world.getBlock(tilePos.add(side.getDirection(), new TilePos()));
        if (supportingBlock == null) {
            return false;
        }
        @NotNull ISupport supporting = supportingBlock.getSupport(world, tilePos.add(side.getDirection(), new TilePos()), side.getOpposite());
        @NotNull ISupport supported = this.getSupportConstraint(world, tilePos, side);
        return supporting.canSupport(supported, side.getOpposite());
    }
}

