/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.data.registry;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.IntTag;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class Registry<T>
implements Iterable<T> {
    private final List<T> items = new ArrayList<T>();
    private final Map<String, T> keyItemMap = new HashMap<String, T>();
    private final Map<T, String> itemKeyMap = new HashMap<T, String>();
    private final List<ItemAddedCallback<T>> callbacks = new ArrayList<ItemAddedCallback<T>>();
    private Registry<?> parent = null;

    public void register(String key, T item) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(item);
        this.items.add(item);
        this.keyItemMap.put(key, item);
        this.itemKeyMap.put(item, key);
        this.items.sort((t1, t2) -> String.valueOf(this.itemKeyMap.get(t1)).compareTo(String.valueOf(this.itemKeyMap.get(t2))));
        if (item instanceof Registry) {
            ((Registry)item).parent = this;
        }
        for (ItemAddedCallback<T> callback : this.callbacks) {
            callback.onItemAdded(this, item);
        }
    }

    public void unregister(String key) {
        Objects.requireNonNull(key);
        T item = this.keyItemMap.get(key);
        this.items.remove(item);
        this.keyItemMap.remove(key);
        this.itemKeyMap.remove(item);
        this.items.sort((t1, t2) -> String.valueOf(this.itemKeyMap.get(t1)).compareTo(String.valueOf(this.itemKeyMap.get(t2))));
        if (item instanceof Registry) {
            ((Registry)item).parent = null;
        }
    }

    public void addCallback(ItemAddedCallback<T> callback) {
        this.callbacks.add(callback);
    }

    @Nullable
    public T getItem(String key) {
        Objects.requireNonNull(key);
        return this.keyItemMap.get(key);
    }

    public String getKey(T item) {
        Objects.requireNonNull(item);
        return this.itemKeyMap.get(item);
    }

    public Registry<?> getParent() {
        return this.parent;
    }

    public int getNumericIdOfItem(T item) {
        Objects.requireNonNull(item);
        return this.items.indexOf(item);
    }

    public int getNumericIdOfKey(String key) {
        Objects.requireNonNull(key);
        T item = this.getItem(key);
        if (item != null) {
            return this.getNumericIdOfItem(item);
        }
        return -1;
    }

    public T getItemByNumericId(int id) {
        if (id < 0 || id >= this.items.size()) {
            return null;
        }
        return this.items.get(id);
    }

    public int size() {
        return this.items.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.items.iterator();
    }

    public static <T> void writeIdMapToTag(Registry<T> registry, CompoundTag tag) {
        for (T item : registry) {
            tag.putInt(registry.getKey(item), registry.getNumericIdOfItem(item));
        }
    }

    public static Int2ObjectMap<String> readIdMapFromTag(CompoundTag tag) {
        Int2ObjectArrayMap<String> map = new Int2ObjectArrayMap<String>();
        for (Map.Entry entry : ((Map)tag.getValue()).entrySet()) {
            if (!(entry.getValue() instanceof IntTag)) continue;
            IntTag iTag = (IntTag)entry.getValue();
            map.put((int)((Integer)iTag.getValue()), (String)entry.getKey());
        }
        return map;
    }

    public static interface ItemAddedCallback<T> {
        public void onItemAdded(Registry<T> var1, T var2);
    }
}

