/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.noise;

import java.util.Random;
import net.minecraft.core.world.noise.Noise3D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector3d;

public class WorleyNoise
implements Noise3D {
    @NotNull
    private static final Vector2dc RANGE = new Vector2d(0.5, 1.0);
    @NotNull
    private static final Result DUMMY = new Result();
    private final int @NotNull [] p = new int[512];
    private final double @NotNull [] @NotNull [] jitter;
    public final double xo;
    public final double yo;
    public final double zo;

    @NotNull
    public static @NotNull WorleyNoise @NotNull [] genOctaves(long seed, int numOctaves) {
        return WorleyNoise.genOctaves(seed, numOctaves, 0);
    }

    @NotNull
    public static @NotNull WorleyNoise @NotNull [] genOctaves(long seed, int numOctaves, int preOctaves) {
        @NotNull Random random = new Random(seed);
        for (int i = 0; i < preOctaves; ++i) {
            random.nextDouble();
            random.nextDouble();
            random.nextDouble();
            for (int j = 0; j < 256; ++j) {
                random.nextInt(256 - j);
            }
        }
        @NotNull WorleyNoise @NotNull [] octaves = new WorleyNoise[numOctaves];
        for (int i = 0; i < numOctaves; ++i) {
            octaves[i] = new WorleyNoise(random);
        }
        return octaves;
    }

    public WorleyNoise(@NotNull Random random) {
        int i;
        this.xo = random.nextDouble() * 256.0;
        this.yo = random.nextDouble() * 256.0;
        this.zo = random.nextDouble() * 256.0;
        for (i = 0; i < 256; ++i) {
            this.p[i] = i;
        }
        for (i = 0; i < 256; ++i) {
            int newI = random.nextInt(256 - i) + i;
            int temp = this.p[i];
            this.p[i] = this.p[newI];
            this.p[newI] = temp;
            this.p[i + 256] = this.p[i];
        }
        this.jitter = new double[256][3];
        for (i = 0; i < 256; ++i) {
            this.jitter[i][0] = random.nextDouble();
            this.jitter[i][1] = random.nextDouble();
            this.jitter[i][2] = random.nextDouble();
        }
    }

    @Override
    @NotNull
    public Vector2dc getRange2D() {
        return RANGE;
    }

    @Override
    @NotNull
    public Vector2dc getRange3D() {
        return RANGE;
    }

    public void getValue(double x, double z, @NotNull Result result) {
        int h;
        int j;
        int i;
        @NotNull Vector2d ip = new Vector2d(x, z).floor();
        @NotNull Vector2d fp = new Vector2d(x - ip.x(), z - ip.y());
        @NotNull Vector2d mg = new Vector2d();
        @NotNull Vector2d mr = new Vector2d();
        double md = Double.POSITIVE_INFINITY;
        int index = 0;
        @NotNull Vector2d g = new Vector2d();
        @NotNull Vector2d o = new Vector2d();
        @NotNull Vector2d r = new Vector2d();
        @NotNull Vector2d pos = new Vector2d();
        for (i = -1; i <= 1; ++i) {
            for (j = -1; j <= 1; ++j) {
                g.set((double)i, j);
                h = this.hash((int)ip.x() + (int)Math.floor(g.x), (int)ip.y() + (int)Math.floor(g.y));
                o.set(this.jitter[h & 0xFF][0], this.jitter[h & 0xFF][1]);
                g.add(o, r).sub(fp);
                double d = r.dot(r);
                if (!(d < md)) continue;
                md = d;
                mr.set(r);
                mg.set(g);
                index = (int)(o.x * 10.0) + (int)(o.y * 10.0);
            }
        }
        md = Double.POSITIVE_INFINITY;
        for (i = -2; i <= 2; ++i) {
            for (j = -2; j <= 2; ++j) {
                g.set(mg).add(i, j);
                h = this.hash((int)ip.x() + (int)Math.floor(g.x), (int)ip.y() + (int)Math.floor(g.y));
                o.set(this.jitter[h & 0xFF][0], this.jitter[h & 0xFF][1]);
                g.add(o, r).sub(fp);
                pos.set(mr).sub(r);
                if (!(pos.dot(pos) > 1.0E-5)) continue;
                g.set(mr).add(r).mul(0.5);
                o.set(r).sub(mr).normalize();
                md = Math.min(md, g.dot(o));
            }
        }
        result.distance = 1.0 - md;
        result.index = index;
    }

    @Override
    public double getValue(double x, double z) {
        this.getValue(x, z, DUMMY);
        return WorleyNoise.DUMMY.distance;
    }

    @Override
    public double @NotNull [] addRegion(double @Nullable [] out, double x, double z, int xSize, int zSize, double xScale, double zScale, double amplitude) {
        if (out == null || out.length != xSize * zSize) {
            out = new double[xSize * zSize];
        }
        int i = 0;
        for (int xi = 0; xi < xSize; ++xi) {
            double xx = (x + (double)xi) * xScale + this.xo;
            for (int zi = 0; zi < zSize; ++zi) {
                double zz = (z + (double)zi) * zScale + this.zo;
                int n = i++;
                out[n] = out[n] + this.getValue(xx, zz) * amplitude;
            }
        }
        return out;
    }

    @Override
    public double getValue(double x, double y, double z) {
        int h;
        int k;
        int j;
        int i;
        @NotNull Vector3d ip = new Vector3d(x, y, z).floor();
        @NotNull Vector3d fp = new Vector3d(x - ip.x(), y - ip.y(), z - ip.z());
        @NotNull Vector3d mg = new Vector3d();
        @NotNull Vector3d mr = new Vector3d();
        double md = 8.0;
        int index = 0;
        @NotNull Vector3d g = new Vector3d();
        @NotNull Vector3d o = new Vector3d();
        @NotNull Vector3d r = new Vector3d();
        @NotNull Vector3d pos = new Vector3d();
        for (i = -1; i <= 1; ++i) {
            for (j = -1; j <= 1; ++j) {
                for (k = -1; k <= 1; ++k) {
                    g.set(i, j, k);
                    h = this.hash((int)ip.x() + i, (int)ip.y() + j, (int)ip.z() + k);
                    o.set(this.jitter[h & 0xFF][0], this.jitter[h & 0xFF][1], this.jitter[h & 0xFF][2]);
                    g.add(o, r).sub(fp);
                    double d = r.dot(r);
                    if (!(d < md)) continue;
                    md = d;
                    mr.set(r);
                    mg.set(g);
                    index = (int)(o.x * 10.0) + (int)(o.y * 10.0) + (int)(o.z * 10.0);
                }
            }
        }
        md = 8.0;
        for (i = -2; i <= 2; ++i) {
            for (j = -2; j <= 2; ++j) {
                for (k = -2; k <= 2; ++k) {
                    g.set(mg).add(i, j, k);
                    h = this.hash((int)ip.x() + i, (int)ip.y() + j, (int)ip.z() + k);
                    o.set(this.jitter[h & 0xFF][0], this.jitter[h & 0xFF][1], this.jitter[h & 0xFF][2]);
                    g.add(o, r).sub(fp);
                    pos.set(mr).sub(r);
                    if (!(pos.dot(pos) > 1.0E-5)) continue;
                    g.set(mr).add(r).mul(0.5);
                    o.set(r).sub(mr).normalize();
                    md = Math.min(md, g.dot(o));
                }
            }
        }
        return 1.0 - md;
    }

    @Override
    public double @NotNull [] addRegion(double @Nullable [] out, double x, double y, double z, int xSize, int ySize, int zSize, double xScale, double yScale, double zScale, double amplitude) {
        if (out == null || out.length != xSize * zSize) {
            out = new double[xSize * zSize];
        }
        int i = 0;
        for (int xi = 0; xi < xSize; ++xi) {
            double xx = (x + (double)xi) * xScale + this.xo;
            for (int zi = 0; zi < zSize; ++zi) {
                double zz = (z + (double)zi) * zScale + this.zo;
                for (int yi = 0; yi < ySize; ++yi) {
                    double yy = (y + (double)yi) * yScale + this.yo;
                    int n = i++;
                    out[n] = out[n] + this.getValue(xx, yy, zz) * amplitude;
                }
            }
        }
        return out;
    }

    private int hash(int x, int z) {
        return this.p[x + this.p[z & 0xFF] & 0xFF];
    }

    private int hash(int x, int y, int z) {
        return this.p[x + this.p[z + this.p[y & 0xFF] & 0xFF] & 0xFF];
    }

    public static class Result {
        public double distance;
        public int index;
    }
}

