/*
 * Decompiled with CFR 0.152.
 */
package org.useless.dragonfly.data.block.mojang;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.slf4j.Logger;
import org.useless.dragonfly.DisplayPos;
import org.useless.dragonfly.data.block.mojang.BlockModelMojangData;
import org.useless.dragonfly.data.block.mojang.Element;
import org.useless.dragonfly.data.block.mojang.Face;

public class CompiledBlockModelMojangData {
    protected static final Logger LOGGER = LogUtils.getLogger();
    public final BlockModelMojangData data;
    @NotNull
    public final @NotNull Map<@NotNull String, IconCoordinate> textures = new Object2ObjectOpenHashMap<String, IconCoordinate>();
    @NotNull
    public final @NotNull C_Element @NotNull [] elements;
    public final int @NotNull [] particleIndices;
    @NotNull
    public final @NotNull Map<@NotNull String, DisplayPos> displayPosMap;
    public final int renderLayer;

    public CompiledBlockModelMojangData(BlockModelMojangData data) {
        this.data = data;
        if (this.data.textures == null) {
            LOGGER.error("Model '{}' does not have assigned texture data!", (Object)data.modelId());
        } else {
            for (String key : data.textures.keySet()) {
                IconCoordinate coordinate = this.getTexture("#" + key, null, true);
                if (coordinate == null) continue;
                this.textures.put("#" + key, coordinate);
            }
        }
        IconCoordinate particleAll = this.textures.get("#particle");
        if (particleAll != null) {
            this.textures.putIfAbsent("#particle_up", particleAll);
            this.textures.putIfAbsent("#particle_down", particleAll);
            this.textures.putIfAbsent("#particle_north", particleAll);
            this.textures.putIfAbsent("#particle_south", particleAll);
            this.textures.putIfAbsent("#particle_west", particleAll);
            this.textures.putIfAbsent("#particle_east", particleAll);
            this.textures.putIfAbsent("#overlay", particleAll);
        } else {
            if (this.textures.get("#particle_up") == null) {
                LOGGER.warn("Model '{}' does not have an assigned '#particle_up' symbol!", (Object)data.modelId());
            }
            if (this.textures.get("#particle_down") == null) {
                LOGGER.warn("Model '{}' does not have an assigned '#particle_down' symbol!", (Object)data.modelId());
            }
            if (this.textures.get("#particle_north") == null) {
                LOGGER.warn("Model '{}' does not have an assigned '#particle_north' symbol!", (Object)data.modelId());
            }
            if (this.textures.get("#particle_south") == null) {
                LOGGER.warn("Model '{}' does not have an assigned '#particle_south' symbol!", (Object)data.modelId());
            }
            if (this.textures.get("#particle_west") == null) {
                LOGGER.warn("Model '{}' does not have an assigned '#particle_west' symbol!", (Object)data.modelId());
            }
            if (this.textures.get("#particle_east") == null) {
                LOGGER.warn("Model '{}' does not have an assigned '#particle_east' symbol!", (Object)data.modelId());
            }
        }
        if (this.textures.get("#overlay") == null) {
            LOGGER.warn("Model '{}' does not have an assigned '#overlay' symbol!", (Object)data.modelId());
        }
        this.displayPosMap = new Object2ObjectOpenHashMap<String, DisplayPos>();
        if (data.displayPositions != null) {
            this.displayPosMap.putAll(data.displayPositions);
        }
        this.particleIndices = new int[6];
        if (data.particleIndices != null) {
            this.particleIndices[Direction.UP.getId()] = data.particleIndices.getOrDefault((Object)Direction.UP, 0);
            this.particleIndices[Direction.DOWN.getId()] = data.particleIndices.getOrDefault((Object)Direction.DOWN, 0);
            this.particleIndices[Direction.NORTH.getId()] = data.particleIndices.getOrDefault((Object)Direction.NORTH, 0);
            this.particleIndices[Direction.SOUTH.getId()] = data.particleIndices.getOrDefault((Object)Direction.SOUTH, 0);
            this.particleIndices[Direction.WEST.getId()] = data.particleIndices.getOrDefault((Object)Direction.WEST, 0);
            this.particleIndices[Direction.EAST.getId()] = data.particleIndices.getOrDefault((Object)Direction.EAST, 0);
        }
        this.renderLayer = data.renderLayer == null ? 0 : data.renderLayer;
        this.elements = new C_Element[data.elements == null ? 0 : data.elements.size()];
        if (data.elements != null) {
            int i = 0;
            for (Element e : data.elements) {
                this.elements[i] = new C_Element(this, e);
                ++i;
            }
        }
    }

    protected IconCoordinate getTexture(@NotNull String textureSymbol, @Nullable IconCoordinate defaultCoordinate, boolean logWarnings) {
        try {
            if (this.data.textures == null) {
                if (logWarnings) {
                    LOGGER.warn("Model '{}' does not have assigned texture data!", (Object)this.data.modelId());
                }
                return defaultCoordinate;
            }
            @Nullable Object path = this.data.textures.get(textureSymbol.startsWith("#") ? textureSymbol.substring(1) : textureSymbol);
            if (path == null) {
                if (logWarnings) {
                    LOGGER.warn("Texture for symbol '{}' is not assigned to any value!", (Object)textureSymbol);
                }
                return defaultCoordinate;
            }
            if (((String)path).startsWith("#")) {
                return this.getTexture(((String)path).substring(1), defaultCoordinate, logWarnings);
            }
            if (!((String)path).contains(":")) {
                path = "minecraft:" + (String)path;
            }
            if (TextureRegistry.hasTexture((String)path)) {
                return TextureRegistry.getTexture((String)path);
            }
            if (logWarnings) {
                LOGGER.warn("Texture for id '{}' does not exist!", path);
            }
            return BlockModelStandard.BLOCK_TEXTURE_MISSING;
        }
        catch (StackOverflowError stackOverflowError) {
            LOGGER.error("Recursive texture lookup from symbol '{}' in model '{}'!", (Object)textureSymbol, (Object)this.data.modelId());
            return defaultCoordinate;
        }
    }

    public static class C_Element {
        public static final int VERTEX_TOP_LEFT = 0;
        public static final int VERTEX_TOP_RIGHT = 3;
        public static final int VERTEX_BOTTOM_RIGHT = 2;
        public static final int VERTEX_BOTTOM_LEFT = 1;
        public final int lightEmission;
        public final boolean shade;
        public final boolean flip;
        public final float minX;
        public final float minY;
        public final float minZ;
        public final float maxX;
        public final float maxY;
        public final float maxZ;
        public final int faces;
        @NotNull
        public final Element sourceElement;
        @NotNull
        public final @NotNull Vector3dc @NotNull [] vertexPoses;
        @NotNull
        public final @NotNull Vector2fc @NotNull [] vertexUvs;
        @NotNull
        public final @NotNull Vector3fc @NotNull [] faceNormals;
        @NotNull
        public final @NotNull Vector3fc @NotNull [] faceUps;
        @NotNull
        public final @NotNull Vector3fc @NotNull [] faceLefts;
        public final int @NotNull [] tintIndices;
        public final @Nullable Direction @NotNull [] cullfaces;
        @NotNull
        public final @NotNull Direction @NotNull [] directions;
        @NotNull
        public final @NotNull IconCoordinate @NotNull [] textures;

        public C_Element(@NotNull CompiledBlockModelMojangData data, @NotNull Element element) {
            int f;
            this.faces = element.faces.size();
            this.sourceElement = element;
            this.vertexPoses = new Vector3dc[this.faces * 4];
            this.vertexUvs = new Vector2fc[this.faces * 4];
            this.faceNormals = new Vector3fc[this.faces];
            this.faceUps = new Vector3fc[this.faces];
            this.faceLefts = new Vector3fc[this.faces];
            this.tintIndices = new int[this.faces];
            this.cullfaces = new Direction[this.faces];
            this.directions = new Direction[this.faces];
            this.textures = new IconCoordinate[this.faces];
            this.shade = element.shade;
            this.lightEmission = element.lightEmission;
            int negs = 0;
            if (element.fromX > element.toX) {
                ++negs;
            }
            if (element.fromY > element.toY) {
                ++negs;
            }
            if (element.fromZ > element.toZ) {
                ++negs;
            }
            boolean bl = this.flip = (negs & 1) != 0;
            if (element.rotation != null && element.rotation.rescale) {
                float x = (45.0f - java.lang.Math.abs((element.rotation.angle + 90.0f) % 90.0f - 45.0f)) / 45.0f;
                float scalar = MathHelper.sqrt_float(1.0f + x * x);
                float cx = element.rotation.originX * 0.0625f;
                float cy = element.rotation.originY * 0.0625f;
                float cz = element.rotation.originZ * 0.0625f;
                switch (element.rotation.axis) {
                    case X: {
                        this.minX = element.fromX * 0.0625f;
                        this.minY = (element.fromY * 0.0625f - cy) * scalar + cy;
                        this.minZ = (element.fromZ * 0.0625f - cz) * scalar + cz;
                        this.maxX = element.toX * 0.0625f;
                        this.maxY = (element.toY * 0.0625f - cy) * scalar + cy;
                        this.maxZ = (element.toZ * 0.0625f - cz) * scalar + cz;
                        break;
                    }
                    case Y: {
                        this.minY = element.fromY * 0.0625f;
                        this.minX = (element.fromX * 0.0625f - cx) * scalar + cx;
                        this.minZ = (element.fromZ * 0.0625f - cz) * scalar + cz;
                        this.maxY = element.toY * 0.0625f;
                        this.maxX = (element.toX * 0.0625f - cx) * scalar + cx;
                        this.maxZ = (element.toZ * 0.0625f - cz) * scalar + cz;
                        break;
                    }
                    default: {
                        this.minZ = element.fromZ * 0.0625f;
                        this.minX = (element.fromX * 0.0625f - cx) * scalar + cx;
                        this.minY = (element.fromY * 0.0625f - cy) * scalar + cy;
                        this.maxZ = element.toZ * 0.0625f;
                        this.maxX = (element.toX * 0.0625f - cx) * scalar + cx;
                        this.maxY = (element.toY * 0.0625f - cy) * scalar + cy;
                        break;
                    }
                }
            } else {
                this.minX = element.fromX * 0.0625f;
                this.minY = element.fromY * 0.0625f;
                this.minZ = element.fromZ * 0.0625f;
                this.maxX = element.toX * 0.0625f;
                this.maxY = element.toY * 0.0625f;
                this.maxZ = element.toZ * 0.0625f;
            }
            int i = 0;
            for (Map.Entry<Direction, Face> e : element.faces.entrySet()) {
                Direction d = e.getKey();
                Face f2 = e.getValue();
                float minU = f2.u1 * 0.0625f;
                float maxU = f2.u2 * 0.0625f;
                float minV = f2.v1 * 0.0625f;
                float maxV = f2.v2 * 0.0625f;
                this.tintIndices[i] = f2.tintIndex;
                this.cullfaces[i] = f2.cullFace;
                this.directions[i] = d;
                this.textures[i] = data.textures.getOrDefault(f2.texture, BlockModelStandard.BLOCK_TEXTURE_UNASSIGNED);
                int vertexIndex = i * 4;
                int rot = 4 - f2.rotation / 90;
                switch (d) {
                    case UP: {
                        this.faceUps[i] = new Vector3f(0.0f, 0.0f, 1.0f);
                        this.faceLefts[i] = new Vector3f(1.0f, 0.0f, 0.0f);
                        this.vertexPoses[vertexIndex + 0] = new Vector3d(this.maxX, this.maxY, this.maxZ);
                        this.vertexUvs[vertexIndex + (0 + rot & 3)] = new Vector2f(maxU, maxV);
                        this.vertexPoses[vertexIndex + 3] = new Vector3d(this.minX, this.maxY, this.maxZ);
                        this.vertexUvs[vertexIndex + (3 + rot & 3)] = new Vector2f(minU, maxV);
                        this.vertexPoses[vertexIndex + 2] = new Vector3d(this.minX, this.maxY, this.minZ);
                        this.vertexUvs[vertexIndex + (2 + rot & 3)] = new Vector2f(minU, minV);
                        this.vertexPoses[vertexIndex + 1] = new Vector3d(this.maxX, this.maxY, this.minZ);
                        this.vertexUvs[vertexIndex + (1 + rot & 3)] = new Vector2f(maxU, minV);
                        break;
                    }
                    case DOWN: {
                        this.faceUps[i] = new Vector3f(0.0f, 0.0f, 1.0f);
                        this.faceLefts[i] = new Vector3f(-1.0f, 0.0f, 0.0f);
                        this.vertexPoses[vertexIndex + 0] = new Vector3d(this.minX, this.minY, this.maxZ);
                        this.vertexUvs[vertexIndex + (0 + rot & 3)] = new Vector2f(minU, minV);
                        this.vertexPoses[vertexIndex + 3] = new Vector3d(this.maxX, this.minY, this.maxZ);
                        this.vertexUvs[vertexIndex + (3 + rot & 3)] = new Vector2f(maxU, minV);
                        this.vertexPoses[vertexIndex + 2] = new Vector3d(this.maxX, this.minY, this.minZ);
                        this.vertexUvs[vertexIndex + (2 + rot & 3)] = new Vector2f(maxU, maxV);
                        this.vertexPoses[vertexIndex + 1] = new Vector3d(this.minX, this.minY, this.minZ);
                        this.vertexUvs[vertexIndex + (1 + rot & 3)] = new Vector2f(minU, maxV);
                        break;
                    }
                    case NORTH: {
                        this.faceUps[i] = new Vector3f(-1.0f, 0.0f, 0.0f);
                        this.faceLefts[i] = new Vector3f(0.0f, 1.0f, 0.0f);
                        this.vertexPoses[vertexIndex + 0] = new Vector3d(this.minX, this.maxY, this.minZ);
                        this.vertexUvs[vertexIndex + (0 + rot & 3)] = new Vector2f(maxU, minV);
                        this.vertexPoses[vertexIndex + 3] = new Vector3d(this.minX, this.minY, this.minZ);
                        this.vertexUvs[vertexIndex + (3 + rot & 3)] = new Vector2f(maxU, maxV);
                        this.vertexPoses[vertexIndex + 2] = new Vector3d(this.maxX, this.minY, this.minZ);
                        this.vertexUvs[vertexIndex + (2 + rot & 3)] = new Vector2f(minU, maxV);
                        this.vertexPoses[vertexIndex + 1] = new Vector3d(this.maxX, this.maxY, this.minZ);
                        this.vertexUvs[vertexIndex + (1 + rot & 3)] = new Vector2f(minU, minV);
                        break;
                    }
                    case SOUTH: {
                        this.faceUps[i] = new Vector3f(0.0f, 1.0f, 0.0f);
                        this.faceLefts[i] = new Vector3f(-1.0f, 0.0f, 0.0f);
                        this.vertexPoses[vertexIndex + 0] = new Vector3d(this.minX, this.maxY, this.maxZ);
                        this.vertexUvs[vertexIndex + (0 + rot & 3)] = new Vector2f(minU, minV);
                        this.vertexPoses[vertexIndex + 3] = new Vector3d(this.maxX, this.maxY, this.maxZ);
                        this.vertexUvs[vertexIndex + (3 + rot & 3)] = new Vector2f(maxU, minV);
                        this.vertexPoses[vertexIndex + 2] = new Vector3d(this.maxX, this.minY, this.maxZ);
                        this.vertexUvs[vertexIndex + (2 + rot & 3)] = new Vector2f(maxU, maxV);
                        this.vertexPoses[vertexIndex + 1] = new Vector3d(this.minX, this.minY, this.maxZ);
                        this.vertexUvs[vertexIndex + (1 + rot & 3)] = new Vector2f(minU, maxV);
                        break;
                    }
                    case WEST: {
                        this.faceUps[i] = new Vector3f(0.0f, 0.0f, 1.0f);
                        this.faceLefts[i] = new Vector3f(0.0f, 1.0f, 0.0f);
                        this.vertexPoses[vertexIndex + 0] = new Vector3d(this.minX, this.maxY, this.maxZ);
                        this.vertexUvs[vertexIndex + (0 + rot & 3)] = new Vector2f(maxU, minV);
                        this.vertexPoses[vertexIndex + 3] = new Vector3d(this.minX, this.minY, this.maxZ);
                        this.vertexUvs[vertexIndex + (3 + rot & 3)] = new Vector2f(maxU, maxV);
                        this.vertexPoses[vertexIndex + 2] = new Vector3d(this.minX, this.minY, this.minZ);
                        this.vertexUvs[vertexIndex + (2 + rot & 3)] = new Vector2f(minU, maxV);
                        this.vertexPoses[vertexIndex + 1] = new Vector3d(this.minX, this.maxY, this.minZ);
                        this.vertexUvs[vertexIndex + (1 + rot & 3)] = new Vector2f(minU, minV);
                        break;
                    }
                    case EAST: {
                        this.faceUps[i] = new Vector3f(0.0f, 0.0f, 1.0f);
                        this.faceLefts[i] = new Vector3f(0.0f, -1.0f, 0.0f);
                        this.vertexPoses[vertexIndex + 0] = new Vector3d(this.maxX, this.minY, this.maxZ);
                        this.vertexUvs[vertexIndex + (0 + rot & 3)] = new Vector2f(minU, maxV);
                        this.vertexPoses[vertexIndex + 3] = new Vector3d(this.maxX, this.maxY, this.maxZ);
                        this.vertexUvs[vertexIndex + (3 + rot & 3)] = new Vector2f(minU, minV);
                        this.vertexPoses[vertexIndex + 2] = new Vector3d(this.maxX, this.maxY, this.minZ);
                        this.vertexUvs[vertexIndex + (2 + rot & 3)] = new Vector2f(maxU, minV);
                        this.vertexPoses[vertexIndex + 1] = new Vector3d(this.maxX, this.minY, this.minZ);
                        this.vertexUvs[vertexIndex + (1 + rot & 3)] = new Vector2f(maxU, maxV);
                    }
                }
                ++i;
            }
            for (f = 0; f < this.faces; ++f) {
                int offset = f * 4;
                Vector3dc br = this.vertexPoses[offset + 2];
                Vector3dc bl2 = this.vertexPoses[offset + 1];
                Vector3dc tr = this.vertexPoses[offset + 3];
                Vector3d a = br.sub(bl2, new Vector3d());
                Vector3d b = tr.sub(bl2, new Vector3d());
                this.faceNormals[f] = new Vector3f(a.cross(b, new Vector3d())).normalize();
            }
            if (element.rotation != null) {
                block23: for (f = 0; f < this.faces; ++f) {
                    block24: for (int v = 0; v < 4; ++v) {
                        int offset = f * 4 + v;
                        switch (element.rotation.axis) {
                            case X: {
                                this.vertexPoses[offset] = this.vertexPoses[offset].sub(element.rotation.originX * 0.0625f, element.rotation.originY * 0.0625f, element.rotation.originZ * 0.0625f, new Vector3d()).rotateX(MathHelper.toRadians(element.rotation.angle)).add(element.rotation.originX * 0.0625f, element.rotation.originY * 0.0625f, element.rotation.originZ * 0.0625f);
                                continue block24;
                            }
                            case Y: {
                                this.vertexPoses[offset] = this.vertexPoses[offset].sub(element.rotation.originX * 0.0625f, element.rotation.originY * 0.0625f, element.rotation.originZ * 0.0625f, new Vector3d()).rotateY(MathHelper.toRadians(element.rotation.angle)).add(element.rotation.originX * 0.0625f, element.rotation.originY * 0.0625f, element.rotation.originZ * 0.0625f);
                                continue block24;
                            }
                            default: {
                                this.vertexPoses[offset] = this.vertexPoses[offset].sub(element.rotation.originX * 0.0625f, element.rotation.originY * 0.0625f, element.rotation.originZ * 0.0625f, new Vector3d()).rotateZ(MathHelper.toRadians(element.rotation.angle)).add(element.rotation.originX * 0.0625f, element.rotation.originY * 0.0625f, element.rotation.originZ * 0.0625f);
                            }
                        }
                    }
                    switch (element.rotation.axis) {
                        case X: {
                            this.faceUps[f] = this.faceUps[f].rotateX(Math.toRadians(element.rotation.angle), new Vector3f());
                            this.faceLefts[f] = this.faceLefts[f].rotateX(Math.toRadians(element.rotation.angle), new Vector3f());
                            this.faceNormals[f] = this.faceNormals[f].rotateX(Math.toRadians(element.rotation.angle), new Vector3f());
                            continue block23;
                        }
                        case Y: {
                            this.faceUps[f] = this.faceUps[f].rotateY(Math.toRadians(element.rotation.angle), new Vector3f());
                            this.faceLefts[f] = this.faceLefts[f].rotateY(Math.toRadians(element.rotation.angle), new Vector3f());
                            this.faceNormals[f] = this.faceNormals[f].rotateY(Math.toRadians(element.rotation.angle), new Vector3f());
                            continue block23;
                        }
                        case Z: {
                            this.faceUps[f] = this.faceUps[f].rotateZ(Math.toRadians(element.rotation.angle), new Vector3f());
                            this.faceLefts[f] = this.faceLefts[f].rotateZ(Math.toRadians(element.rotation.angle), new Vector3f());
                            this.faceNormals[f] = this.faceNormals[f].rotateZ(Math.toRadians(element.rotation.angle), new Vector3f());
                        }
                    }
                }
            }
        }
    }
}

