/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.entity.EntityRendererArrow;
import net.minecraft.client.render.entity.EntityRendererBoat;
import net.minecraft.client.render.entity.EntityRendererCannonball;
import net.minecraft.client.render.entity.EntityRendererDefault;
import net.minecraft.client.render.entity.EntityRendererFallingBlock;
import net.minecraft.client.render.entity.EntityRendererFishingBobber;
import net.minecraft.client.render.entity.EntityRendererItem;
import net.minecraft.client.render.entity.EntityRendererLightningBolt;
import net.minecraft.client.render.entity.EntityRendererMinecart;
import net.minecraft.client.render.entity.EntityRendererPainting;
import net.minecraft.client.render.entity.EntityRendererSprite;
import net.minecraft.client.render.entity.EntityRendererTNT;
import net.minecraft.client.render.entity.MobRendererButterfly;
import net.minecraft.client.render.entity.MobRendererChicken;
import net.minecraft.client.render.entity.MobRendererCreeper;
import net.minecraft.client.render.entity.MobRendererDeer;
import net.minecraft.client.render.entity.MobRendererFireflyCluster;
import net.minecraft.client.render.entity.MobRendererGhast;
import net.minecraft.client.render.entity.MobRendererGiant;
import net.minecraft.client.render.entity.MobRendererHuman;
import net.minecraft.client.render.entity.MobRendererPig;
import net.minecraft.client.render.entity.MobRendererPlayer;
import net.minecraft.client.render.entity.MobRendererQuadruped;
import net.minecraft.client.render.entity.MobRendererScorpion;
import net.minecraft.client.render.entity.MobRendererSheep;
import net.minecraft.client.render.entity.MobRendererSkeleton;
import net.minecraft.client.render.entity.MobRendererSlime;
import net.minecraft.client.render.entity.MobRendererSnowman;
import net.minecraft.client.render.entity.MobRendererSpider;
import net.minecraft.client.render.entity.MobRendererSquid;
import net.minecraft.client.render.entity.MobRendererWolf;
import net.minecraft.client.render.entity.MobRendererZombie;
import net.minecraft.client.render.entity.MobRendererZombieArmored;
import net.minecraft.client.render.font.FontRenderer;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texturepack.TexturePackList;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityFallingBlock;
import net.minecraft.core.entity.EntityFishingBobber;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.EntityLightning;
import net.minecraft.core.entity.EntityPainting;
import net.minecraft.core.entity.EntityPrimedTNT;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.animal.MobButterfly;
import net.minecraft.core.entity.animal.MobChicken;
import net.minecraft.core.entity.animal.MobCow;
import net.minecraft.core.entity.animal.MobDeer;
import net.minecraft.core.entity.animal.MobFireflyCluster;
import net.minecraft.core.entity.animal.MobPig;
import net.minecraft.core.entity.animal.MobSheep;
import net.minecraft.core.entity.animal.MobSquid;
import net.minecraft.core.entity.animal.MobWolf;
import net.minecraft.core.entity.monster.MobCreeper;
import net.minecraft.core.entity.monster.MobGhast;
import net.minecraft.core.entity.monster.MobGiant;
import net.minecraft.core.entity.monster.MobHuman;
import net.minecraft.core.entity.monster.MobScorpion;
import net.minecraft.core.entity.monster.MobSkeleton;
import net.minecraft.core.entity.monster.MobSlime;
import net.minecraft.core.entity.monster.MobSnowman;
import net.minecraft.core.entity.monster.MobSpider;
import net.minecraft.core.entity.monster.MobZombie;
import net.minecraft.core.entity.monster.MobZombieArmored;
import net.minecraft.core.entity.monster.MobZombiePig;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.projectile.ProjectileArrow;
import net.minecraft.core.entity.projectile.ProjectileCannonball;
import net.minecraft.core.entity.projectile.ProjectileEgg;
import net.minecraft.core.entity.projectile.ProjectileFireball;
import net.minecraft.core.entity.projectile.ProjectilePebble;
import net.minecraft.core.entity.projectile.ProjectileSnowball;
import net.minecraft.core.entity.vehicle.EntityBoat;
import net.minecraft.core.entity.vehicle.EntityMinecart;
import net.minecraft.core.item.Items;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EntityRendererDispatcher {
    @NotNull
    public static final EntityRendererDispatcher instance = new EntityRendererDispatcher();
    public static double renderPosX = 0.0;
    public static double renderPosY = 0.0;
    public static double renderPosZ = 0.0;
    @NotNull
    private final @NotNull Map<@NotNull Class<? extends Entity>, @Nullable EntityRenderer<? extends Entity>> renderers = new Object2ObjectOpenHashMap<Class<? extends Entity>, EntityRenderer<? extends Entity>>();
    @NotNull
    public final TextureManager textureManager;
    @NotNull
    public final TexturePackList packList;
    @NotNull
    public final FontRenderer font;
    @NotNull
    public final GameSettings settings;
    public float viewLerpYaw = 0.0f;
    public float viewLerpPitch = 0.0f;
    public double viewLerpPosX = 0.0;
    public double viewLerpPosY = 0.0;
    public double viewLerpPosZ = 0.0;

    private EntityRendererDispatcher() {
        Minecraft mc = Minecraft.getMinecraft();
        this.textureManager = mc.textureManager;
        this.packList = mc.texturePackList;
        this.font = mc.font;
        this.settings = mc.gameSettings;
        this.reload();
    }

    public void reload() {
        this.renderers.clear();
        this.assignRenderer(MobSpider.class, new MobRendererSpider(1.0f));
        this.assignRenderer(MobScorpion.class, new MobRendererScorpion(0.5f));
        this.assignRenderer(MobPig.class, new MobRendererPig(0.7f));
        this.assignRenderer(MobSheep.class, new MobRendererSheep(0.7f));
        this.assignRenderer(MobCow.class, new MobRendererQuadruped(0.7f));
        this.assignRenderer(MobWolf.class, new MobRendererWolf(0.5f));
        this.assignRenderer(MobChicken.class, new MobRendererChicken(0.3f));
        this.assignRenderer(MobCreeper.class, new MobRendererCreeper(0.5f));
        this.assignRenderer(MobSkeleton.class, new MobRendererSkeleton(0.5f));
        this.assignRenderer(MobZombie.class, new MobRendererZombie(0.5f));
        this.assignRenderer(MobZombiePig.class, new MobRendererZombie(0.5f));
        this.assignRenderer(MobSnowman.class, new MobRendererSnowman(0.5f));
        this.assignRenderer(MobZombieArmored.class, new MobRendererZombieArmored(0.5f));
        this.assignRenderer(MobSlime.class, new MobRendererSlime(0.25f));
        this.assignRenderer(Player.class, new MobRendererPlayer());
        this.assignRenderer(MobHuman.class, new MobRendererHuman());
        this.assignRenderer(MobGiant.class, new MobRendererGiant(0.5f, 6.0f));
        this.assignRenderer(MobGhast.class, new MobRendererGhast(0.5f));
        this.assignRenderer(MobSquid.class, new MobRendererSquid(0.7f));
        this.assignRenderer(Entity.class, new EntityRendererDefault());
        this.assignRenderer(Mob.class, new EntityRendererDefault());
        this.assignRenderer(EntityPainting.class, new EntityRendererPainting());
        this.assignRenderer(ProjectileArrow.class, new EntityRendererArrow());
        this.assignRenderer(ProjectileSnowball.class, new EntityRendererSprite(Items.AMMO_SNOWBALL));
        this.assignRenderer(ProjectileEgg.class, new EntityRendererSprite(Items.EGG_CHICKEN));
        this.assignRenderer(ProjectileFireball.class, new EntityRendererSprite(Items.AMMO_FIREBALL).setScale(4.0f).setFullBright());
        this.assignRenderer(EntityItem.class, new EntityRendererItem());
        this.assignRenderer(EntityPrimedTNT.class, new EntityRendererTNT());
        this.assignRenderer(EntityFallingBlock.class, new EntityRendererFallingBlock());
        this.assignRenderer(EntityMinecart.class, new EntityRendererMinecart());
        this.assignRenderer(EntityBoat.class, new EntityRendererBoat());
        this.assignRenderer(EntityFishingBobber.class, new EntityRendererFishingBobber());
        this.assignRenderer(MobFireflyCluster.class, new MobRendererFireflyCluster());
        this.assignRenderer(EntityLightning.class, new EntityRendererLightningBolt());
        this.assignRenderer(ProjectileCannonball.class, new EntityRendererCannonball());
        this.assignRenderer(ProjectilePebble.class, new EntityRendererSprite(Items.AMMO_PEBBLE));
        this.assignRenderer(MobButterfly.class, new MobRendererButterfly());
        this.assignRenderer(MobDeer.class, new MobRendererDeer(0.7f));
    }

    private <T extends Entity> void assignRenderer(@NotNull Class<? extends T> clazz, @NotNull EntityRenderer<T> renderer) {
        this.renderers.put(clazz, renderer);
        renderer.init(clazz, this);
    }

    public <T extends Entity> EntityRenderer<T> getRenderer(@NotNull Class<T> e) {
        EntityRenderer<Object> r = this.renderers.get(e);
        if (r == null && e != Entity.class) {
            r = this.getRenderer((T)((Object)e.getSuperclass()));
            this.renderers.put(e, r);
        }
        return r;
    }

    public <T extends Entity> EntityRenderer<T> getRenderer(@NotNull T entity) {
        return this.getRenderer((T)((Object)entity.getClass()));
    }

    public void onWorldChanged(@NotNull World world) {
        for (EntityRenderer<? extends Entity> renderer : this.renderers.values()) {
            if (renderer == null) continue;
            renderer.onWorldChanged(world);
        }
    }

    public void cacheActiveRenderInfo(@NotNull ICamera camera, float partialTick) {
        this.viewLerpYaw = (float)camera.getYRot(partialTick);
        this.viewLerpPitch = (float)camera.getXRot(partialTick);
        this.viewLerpPosX = camera.getX(partialTick);
        this.viewLerpPosY = camera.getY(partialTick);
        this.viewLerpPosZ = camera.getZ(partialTick);
    }

    public <T extends Entity> void renderEntity(@NotNull TessellatorGeneral tessellator, @NotNull T entity, float partialTick) {
        double lerpPosX = entity.xo + (entity.x - entity.xo) * (double)partialTick;
        double lerpPosY = entity.yo + (entity.y - entity.yo) * (double)partialTick;
        double lerpPosZ = entity.zo + (entity.z - entity.zo) * (double)partialTick;
        float lerpYaw = entity.yRotO + (entity.yRot - entity.yRotO) * partialTick;
        GLRenderer.setLightmapCoord1i(entity.getLightmap(partialTick));
        GLRenderer.setColor3f(1.0f, 1.0f, 1.0f);
        this.renderEntityWithPosYaw(tessellator, entity, lerpPosX - renderPosX, lerpPosY - renderPosY, lerpPosZ - renderPosZ, lerpYaw, partialTick);
    }

    public <T extends Entity> void renderEntityWithPosYaw(@NotNull TessellatorGeneral tessellator, @NotNull T entity, double x, double y, double z, float yaw, float partialTick) {
        EntityRenderer<T> renderer = this.getRenderer(entity);
        if (renderer != null) {
            renderer.render(tessellator, entity, x, y, z, yaw, partialTick);
            renderer.postRender(tessellator, entity, x, y, z, yaw, partialTick);
        }
    }

    public <T extends Entity> void renderEntityPreviewWithPosYaw(@NotNull TessellatorGeneral tessellator, @NotNull T entity, double x, double y, double z, float yaw, float partialTick) {
        EntityRenderer<T> renderer = this.getRenderer(entity);
        if (renderer != null) {
            renderer.renderPreview(tessellator, entity, x, y, z, yaw, partialTick);
        }
    }

    public double distanceToLerpSquared(double x, double y, double z) {
        double dx = x - this.viewLerpPosX;
        double dy = y - this.viewLerpPosY;
        double dz = z - this.viewLerpPosZ;
        return dx * dx + dy * dy + dz * dz;
    }
}

