/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.PlayerLocal;
import net.minecraft.client.render.EntityRendererDispatcher;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.PlayerSkinParser;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.entity.MobRendererPlayer;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.renderer.BlendFactor;
import net.minecraft.client.render.renderer.CompareFunc;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.tessellator.TessellatorShader;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.MathHelper;
import org.joml.Math;

public class ItemRenderer {
    private final Minecraft mc;
    private ItemStack itemToRender = null;
    private float height = 0.0f;
    private float oHeight = 0.0f;
    private int lastSlot = -1;

    public ItemRenderer(Minecraft minecraft) {
        this.mc = minecraft;
    }

    public float getEquippedProgress(float partialTick) {
        return this.oHeight + (this.height - this.oHeight) * partialTick;
    }

    public void renderItemInFirstPerson(float partialTick) {
        float equipProgress = this.getEquippedProgress(partialTick);
        PlayerLocal player = this.mc.thePlayer;
        float rotationPitch = player.xRotO + (player.xRot - player.xRotO) * partialTick;
        Lighting.enableLight();
        GLRenderer.globalGetNormalTransformMatrix().rotateX(Math.toRadians(rotationPitch)).rotateY(Math.toRadians(player.yRotO + (player.yRot - player.yRotO) * partialTick)).invert();
        ItemStack itemstack = this.itemToRender;
        if (itemstack != null) {
            GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            GLRenderer.setLightmapCoord1i(this.mc.thePlayer.getLightmap(partialTick));
            ((ItemModel)ItemModelDispatcher.getInstance().getDispatch(itemstack.getItem())).renderFirstPerson(GLRenderer.getTessellator(), this, player, itemstack, player.getLightmap(partialTick), partialTick);
        } else {
            GLRenderer.pushFrame();
            GLRenderer.enableState(State.BLEND);
            GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
            GLRenderer.enableState(State.DEPTH_TEST);
            GLRenderer.setDepthFunc(CompareFunc.LESS);
            float brightness = 1.0f;
            GLRenderer.setLightmapCoord1i(this.mc.thePlayer.getLightmap(partialTick));
            GLRenderer.setColor4f(brightness, brightness, brightness, 1.0f);
            EntityRenderer<PlayerLocal> render = EntityRendererDispatcher.instance.getRenderer(this.mc.thePlayer);
            MobRendererPlayer playerRenderer = (MobRendererPlayer)render;
            if (player.getHeldObject() == null) {
                if (player.isLeftHanded()) {
                    float f6 = 0.8f;
                    float swingProgress = player.getSwingProgress(partialTick);
                    float f14 = MathHelper.sin(swingProgress * (float)java.lang.Math.PI);
                    float f18 = MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)java.lang.Math.PI);
                    GLRenderer.modelM4f().scale(-1.0f, 1.0f, 1.0f);
                    GLRenderer.modelM4f().translate(-f18 * 0.3f, MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)java.lang.Math.PI * 2.0f) * 0.4f, -f14 * 0.4f);
                    GLRenderer.modelM4f().translate(0.8f * f6, -0.75f * f6 - (1.0f - equipProgress) * 0.6f, -0.9f * f6);
                    GLRenderer.modelM4f().rotateY(Math.toRadians(45.0f));
                    f14 = MathHelper.sin(swingProgress * swingProgress * (float)java.lang.Math.PI);
                    f18 = MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)java.lang.Math.PI);
                    GLRenderer.modelM4f().rotateY(Math.toRadians(f18 * 70.0f));
                    GLRenderer.modelM4f().rotateZ(Math.toRadians(-f14 * 20.0f));
                    this.mc.textureManager.bindDownloadableTexture(this.mc.thePlayer.skinURL, this.mc.thePlayer.getEntityTexture(), this.mc.thePlayer.slimModel ? PlayerSkinParser.instanceAlex : PlayerSkinParser.instanceSteve);
                    GLRenderer.modelM4f().translate(-1.0f, 3.6f, 3.5f);
                    GLRenderer.modelM4f().rotateZ(Math.toRadians(120.0f));
                    GLRenderer.modelM4f().rotateX(Math.toRadians(200.0f));
                    GLRenderer.modelM4f().rotateY(Math.toRadians(-135.0f));
                    GLRenderer.modelM4f().translate(5.6f, 0.0f, 0.0f);
                    GLRenderer.pushFrame();
                    GLRenderer.modelM4f().scale(-1.0f, 1.0f, 1.0f);
                    GLRenderer.modelM4f().scale(0.0625f, 0.0625f, -0.0625f);
                    GLRenderer.modelM4f().translate(0.0f, 16.0f, 0.0f);
                    GLRenderer.modelM4f().rotateX(Math.toRadians(180.0f));
                    GLRenderer.modelM4f().translate(0.0f, -16.0f, 0.0f);
                    GLRenderer.modelM4f().translate(0.0f, 8.0f, 0.0f);
                    playerRenderer.drawFirstPersonHand(GLRenderer.getTessellator(), this.mc.thePlayer, true);
                    GLRenderer.popFrame();
                } else {
                    float f6 = 0.8f;
                    float swingProgress = player.getSwingProgress(partialTick);
                    float f14 = MathHelper.sin(swingProgress * (float)java.lang.Math.PI);
                    float f18 = MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)java.lang.Math.PI);
                    GLRenderer.modelM4f().translate(-f18 * 0.3f, MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)java.lang.Math.PI * 2.0f) * 0.4f, -f14 * 0.4f);
                    GLRenderer.modelM4f().translate(0.8f * f6, -0.75f * f6 - (1.0f - equipProgress) * 0.6f, -0.9f * f6);
                    GLRenderer.modelM4f().rotateY(Math.toRadians(45.0f));
                    f14 = MathHelper.sin(swingProgress * swingProgress * (float)java.lang.Math.PI);
                    f18 = MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)java.lang.Math.PI);
                    GLRenderer.modelM4f().rotateY(Math.toRadians(f18 * 70.0f));
                    GLRenderer.modelM4f().rotateZ(Math.toRadians(-f14 * 20.0f));
                    this.mc.textureManager.bindDownloadableTexture(this.mc.thePlayer.skinURL, this.mc.thePlayer.getEntityTexture(), this.mc.thePlayer.slimModel ? PlayerSkinParser.instanceAlex : PlayerSkinParser.instanceSteve);
                    GLRenderer.modelM4f().translate(-1.0f, 3.6f, 3.5f);
                    GLRenderer.modelM4f().rotateZ(Math.toRadians(120.0f));
                    GLRenderer.modelM4f().rotateX(Math.toRadians(200.0f));
                    GLRenderer.modelM4f().rotateY(Math.toRadians(-135.0f));
                    GLRenderer.modelM4f().translate(5.6f, 0.0f, 0.0f);
                    GLRenderer.pushFrame();
                    GLRenderer.modelM4f().scale(0.0625f, 0.0625f, -0.0625f);
                    GLRenderer.modelM4f().translate(0.0f, 16.0f, 0.0f);
                    GLRenderer.modelM4f().rotateX(Math.toRadians(180.0f));
                    GLRenderer.modelM4f().translate(0.0f, -16.0f, 0.0f);
                    GLRenderer.modelM4f().translate(0.0f, 8.0f, 0.0f);
                    playerRenderer.drawFirstPersonHand(GLRenderer.getTessellator(), this.mc.thePlayer, false);
                    GLRenderer.popFrame();
                }
            } else {
                GLRenderer.pushFrame();
                float swingProgress = player.getSwingProgress(partialTick);
                GLRenderer.modelM4f().translate(0.0f, MathHelper.sin(swingProgress * (float)java.lang.Math.PI * 2.0f - 1.5707964f) / 33.0f, 0.0f);
                GLRenderer.modelM4f().scale(1.0f, -1.0f, 1.0f);
                GLRenderer.modelM4f().rotateX(Math.toRadians(-MathHelper.sin(swingProgress * (float)java.lang.Math.PI * 2.0f) * 5.0f));
                playerRenderer.drawHeldObject(this.mc.thePlayer, partialTick);
                GLRenderer.popFrame();
            }
            GLRenderer.popFrame();
        }
        Lighting.disable();
    }

    public void renderOverlays(float partialTicks) {
        GLRenderer.disableState(State.DEPTH_TEST);
        if (this.mc.thePlayer.isOnFire()) {
            TextureRegistry.worldAtlas.bind();
            this.renderFireInFirstPerson(partialTicks);
        }
        if (this.mc.thePlayer.isInWall() && !this.mc.thePlayer.noPhysics) {
            int blockX = MathHelper.floor(this.mc.thePlayer.x);
            int blockY = MathHelper.floor(this.mc.thePlayer.y);
            int blockZ = MathHelper.floor(this.mc.thePlayer.z);
            TextureRegistry.worldAtlas.bind();
            int id = this.mc.currentWorld.getBlockId(blockX, blockY, blockZ);
            int meta = this.mc.currentWorld.getBlockMetadata(blockX, blockY, blockZ);
            Block<?> block = Blocks.blocksList[id];
            BlockModel model = (BlockModel)BlockModelDispatcher.getInstance().getDispatch(block);
            if (this.mc.currentWorld.isBlockNormalCube(blockX, blockY, blockZ)) {
                this.renderInsideOfBlock(partialTicks, model.getOverlayTexture(meta));
            } else {
                id = 0;
                for (int i = 0; i < 8; ++i) {
                    int z1;
                    int y1;
                    float x0 = ((float)((i >> 0) % 2) - 0.5f) * this.mc.thePlayer.bbWidth * 0.9f;
                    float y0 = ((float)((i >> 1) % 2) - 0.5f) * this.mc.thePlayer.bbHeight * 0.2f;
                    float z0 = ((float)((i >> 2) % 2) - 0.5f) * this.mc.thePlayer.bbWidth * 0.9f;
                    int x1 = MathHelper.floor_float((float)blockX + x0);
                    if (!this.mc.currentWorld.isBlockNormalCube(x1, y1 = MathHelper.floor_float((float)blockY + y0), z1 = MathHelper.floor_float((float)blockZ + z0))) continue;
                    id = this.mc.currentWorld.getBlockId(x1, y1, z1);
                    meta = this.mc.currentWorld.getBlockMetadata(x1, y1, z1);
                    break;
                }
                if (Blocks.blocksList[id] != null) {
                    model = (BlockModel)BlockModelDispatcher.getInstance().getDispatch(Blocks.blocksList[id]);
                    this.renderInsideOfBlock(partialTicks, model.getOverlayTexture(meta));
                }
            }
        }
        if (this.mc.thePlayer.isUnderLiquid(Materials.WATER)) {
            this.mc.textureManager.loadTexture("/assets/minecraft/textures/misc/water.png").bind();
            this.renderWarpedTextureOverlay(partialTicks);
        }
        GLRenderer.enableState(State.DEPTH_TEST);
    }

    private void renderInsideOfBlock(float partialTicks, IconCoordinate texture) {
        if (texture == null) {
            return;
        }
        TessellatorShader tessellator = GLRenderer.getTessellator();
        float brightness = 0.1f;
        if (this.mc.fullbright) {
            brightness = 1.0f;
        }
        GLRenderer.pushFrame();
        GLRenderer.setColor4f(brightness, brightness, brightness, 0.5f);
        float x0 = -1.0f;
        float x1 = 1.0f;
        float y0 = -1.0f;
        float y1 = 1.0f;
        float z = -0.5f;
        float u0 = (float)texture.getIconUMin();
        float v0 = (float)texture.getIconVMin();
        float u1 = (float)texture.getIconUMax();
        float v1 = (float)texture.getIconVMax();
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(-1.0, -1.0, -0.5, u1, v1);
        tessellator.addVertexWithUV(1.0, -1.0, -0.5, u0, v1);
        tessellator.addVertexWithUV(1.0, 1.0, -0.5, u0, v0);
        tessellator.addVertexWithUV(-1.0, 1.0, -0.5, u1, v0);
        tessellator.draw();
        GLRenderer.popFrame();
    }

    private void renderWarpedTextureOverlay(float f) {
        TessellatorShader tessellator = GLRenderer.getTessellator();
        float f1 = this.mc.thePlayer.getBrightness(f);
        if (this.mc.fullbright) {
            f1 = 1.0f;
        }
        GLRenderer.setColor4f(f1, f1, f1, 0.5f);
        GLRenderer.pushFrame();
        GLRenderer.enableState(State.BLEND);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        float f2 = 4.0f;
        float f3 = -1.0f;
        float f4 = 1.0f;
        float f5 = -1.0f;
        float f6 = 1.0f;
        float f7 = -0.5f;
        float f8 = -this.mc.thePlayer.yRot / 64.0f;
        float f9 = this.mc.thePlayer.xRot / 64.0f;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(f3, f5, f7, f2 + f8, f2 + f9);
        tessellator.addVertexWithUV(f4, f5, f7, 0.0f + f8, f2 + f9);
        tessellator.addVertexWithUV(f4, f6, f7, 0.0f + f8, 0.0f + f9);
        tessellator.addVertexWithUV(f3, f6, f7, f2 + f8, 0.0f + f9);
        tessellator.draw();
        GLRenderer.popFrame();
    }

    private void renderFireInFirstPerson(float f) {
        TessellatorShader tessellator = GLRenderer.getTessellator();
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 0.85f);
        GLRenderer.enableState(State.BLEND);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        float scale = 1.5f;
        for (int i = 0; i < 2; ++i) {
            GLRenderer.pushFrame();
            IconCoordinate texture = TextureRegistry.getTexture("minecraft:block/fire");
            float uMin = (float)texture.getIconUMin();
            float uMax = (float)texture.getIconUMax();
            float vMin = (float)texture.getIconVMin();
            float vMax = (float)texture.getIconVMax();
            float xMin = (0.0f - scale) / 2.0f;
            float xMax = xMin + scale;
            float yMin = 0.0f - scale / 2.0f;
            float yMax = yMin + scale;
            float f10 = -0.5f;
            GLRenderer.modelM4f().translate((float)(-(i * 2 - 1)) * 0.4f, -0.3f, 0.0f);
            GLRenderer.modelM4f().rotateY(Math.toRadians((float)(i * 2 - 1) * 10.0f));
            tessellator.startDrawingQuads();
            tessellator.addVertexWithUV(xMin, (double)yMin - 0.5, f10, uMax, vMax);
            tessellator.addVertexWithUV(xMax, (double)yMin - 0.5, f10, uMin, vMax);
            tessellator.addVertexWithUV(xMax, yMax, f10, uMin, vMin);
            tessellator.addVertexWithUV(xMin, yMax, f10, uMax, vMin);
            tessellator.draw();
            GLRenderer.popFrame();
        }
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GLRenderer.disableState(State.BLEND);
    }

    public void updateEquippedItem() {
        float f;
        float f1;
        float f2;
        boolean flag;
        this.oHeight = this.height;
        PlayerLocal playerLocal = this.mc.thePlayer;
        ItemStack itemstack = playerLocal.inventory.getCurrentItem();
        boolean bl = flag = this.lastSlot == playerLocal.inventory.getCurrentSlot() && itemstack == this.itemToRender;
        if (this.itemToRender == null && itemstack == null) {
            flag = true;
        }
        if (itemstack != null && this.itemToRender != null && itemstack != this.itemToRender && itemstack.itemID == this.itemToRender.itemID && itemstack.getMetadata() == this.itemToRender.getMetadata()) {
            this.itemToRender = itemstack;
            flag = true;
        }
        if ((f2 = (f1 = flag ? 1.0f : 0.0f) - this.height) < -(f = 0.4f)) {
            f2 = -f;
        }
        if (f2 > f) {
            f2 = f;
        }
        this.height += f2;
        if (this.height < 0.1f) {
            this.itemToRender = itemstack;
            this.lastSlot = playerLocal.inventory.getCurrentSlot();
        }
    }

    public void resetEquippedProgress() {
        this.height = 0.0f;
    }
}

