/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model.generic;

import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.generic.BlockModelGeneric;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class BlockModelGenericLeaves<T extends BlockLogic>
extends BlockModelGeneric<T> {
    public static boolean fancyGraphics;
    @NotNull
    public StaticBlockModel fast;

    public BlockModelGenericLeaves(@NotNull Block<T> block, @NotNull String key) {
        super(block, BlockModelDispatcher.loadDataModel(key + "_fancy"));
        this.fast = BlockModelDispatcher.loadDataModel(key + "_fast").asModel();
    }

    public static void setGraphicsLevel(boolean graphicsLevel) {
        fancyGraphics = graphicsLevel;
    }

    @Override
    @NotNull
    public StaticBlockModel getModelFromData(int data) {
        return fancyGraphics ? super.getModelFromData(data) : this.fast;
    }

    @Override
    public boolean cullSide(@NotNull WorldSource worldSource, @NotNull TilePosc blockPos, @Nullable Direction direction) {
        if (fancyGraphics) {
            return super.cullSide(worldSource, blockPos, direction);
        }
        if (direction != null) {
            TilePos shifted = blockPos.add(direction, new TilePos());
            return worldSource.getBlockType(shifted) == this.block || worldSource.isBlockOpaqueCube(shifted);
        }
        return false;
    }
}

