/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;

public class EntityRendererItem
extends EntityRenderer<EntityItem> {
    public EntityRendererItem() {
        super(0.15f);
        this.shadowOpacity = 0.75f;
    }

    @Override
    public void render(@NotNull TessellatorGeneral tessellator, @NotNull EntityItem entity, double x, double y, double z, float yaw, float partialTick) {
        ItemStack itemstack = entity.item;
        if (itemstack == null) {
            return;
        }
        Item item = itemstack.getItem();
        GLRenderer.pushFrame();
        float bobbingOffset = MathHelper.sin(((float)entity.age + partialTick) / 10.0f + entity.bobOffset) * 0.1f + 0.1f;
        float yw = (float)Math.toDegrees(((float)entity.age + partialTick) / 20.0f + entity.bobOffset);
        int renderCount = 1;
        if (entity.item.stackSize > 1) {
            renderCount = 2;
        }
        if (entity.item.stackSize > 5) {
            renderCount = 3;
        }
        if (entity.item.stackSize > 20) {
            renderCount = 4;
        }
        GLRenderer.modelM4f().translate((float)x, (float)(y + (double)bobbingOffset), (float)z);
        ((ItemModel)ItemModelDispatcher.getInstance().getDispatch(item)).renderItemEntity(tessellator, itemstack, (Boolean)Minecraft.getMinecraft().gameSettings.items3D.value, renderCount, entity.age, yw, entity.getLightmap(partialTick), partialTick);
        GLRenderer.popFrame();
    }
}

